/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class VerifyUUID
extends VerifyProcess {
    private static final String[][] _MODELS = new String[][]{{"DLFileVersion", "fileVersionId"}, {"JournalArticleResource", "resourcePrimKey"}, {"JournalFeed", "id_"}, {"JournalStructure", "id_"}, {"JournalTemplate", "id_"}, {"Layout", "plid"}, {"LayoutPrototype", "layoutPrototypeId"}, {"LayoutSetPrototype", "layoutSetPrototypeId"}, {"WikiPageResource", "resourcePrimKey"}};

    public static void verifyModel(String modelName, String pkColumnName) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select " + pkColumnName + " from " + modelName + " where uuid_ is null or uuid_ = ''");
            rs = ps.executeQuery();
            while (rs.next()) {
                long pk = rs.getLong(pkColumnName);
                VerifyUUID.verifyModel(modelName, pkColumnName, pk);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    public static void verifyModel(String modelName, String pkColumnName, long pk) throws Exception {
        String uuid = PortalUUIDUtil.generate();
        DB db = DBFactoryUtil.getDB();
        db.runSQL("update " + modelName + " set uuid_ = '" + uuid + "' where " + pkColumnName + " = " + pk);
    }

    protected void doVerify() throws Exception {
        String[][] stringArray = _MODELS;
        int n = _MODELS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] model = stringArray[n2];
            VerifyUUID.verifyModel(model[0], model[1]);
            ++n2;
        }
    }
}

