/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.util.List;

public class VerifyWiki
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyWiki.class);

    protected void doVerify() throws Exception {
        List pages = WikiPageLocalServiceUtil.getNoAssetPages();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + pages.size() + " pages with no asset"));
        }
        for (WikiPage page : pages) {
            try {
                WikiPageLocalServiceUtil.updateAsset((long)page.getUserId(), (WikiPage)page, null, null, null);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for page " + page.getPageId() + ": " + e2.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for pages");
        }
    }
}

