/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    public Resource getResource(WebDAVRequest webDavRequest) {
        String path = String.valueOf(this.getRootPath()) + webDavRequest.getPath();
        return new BaseResourceImpl(path, "", "");
    }

    public List<Resource> getResources(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            long userId = webDavRequest.getUserId();
            return this.getResources(userId);
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
    }

    protected List<Resource> getResources(long userId) throws Exception {
        User user = UserLocalServiceUtil.getUserById((long)userId);
        Company company = CompanyLocalServiceUtil.getCompanyById((long)user.getCompanyId());
        List groups = WebDAVUtil.getGroups((User)user);
        ArrayList<Resource> resources = new ArrayList<Resource>(groups.size());
        for (Group group : groups) {
            String parentPath = String.valueOf(this.getRootPath()) + "/" + company.getWebId();
            String name = group.getFriendlyURL();
            name = name.substring(1);
            resources.add((Resource)new BaseResourceImpl(parentPath, name, name));
        }
        return resources;
    }
}

