/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webdav.CompanyWebDAVStorageImpl;
import com.liferay.portal.webdav.GroupWebDAVStorageImpl;
import com.liferay.portal.webdav.WebDAVRequestImpl;
import com.liferay.portal.webdav.methods.MethodFactory;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebDAVServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(WebDAVServlet.class);

    /*
     * Unable to fully structure code
     */
    public void service(HttpServletRequest request, HttpServletResponse response) {
        block22: {
            status = 412;
            userAgent = request.getHeader("User-Agent");
            if (WebDAVServlet._log.isDebugEnabled()) {
                WebDAVServlet._log.debug((Object)("User agent " + userAgent));
            }
            try {
                if (this.isIgnoredResource(request)) {
                    status = 404;
                    return;
                }
                storage = this.getStorage(request);
                if (storage == null) {
                    if (WebDAVServlet._log.isDebugEnabled()) {
                        WebDAVServlet._log.debug((Object)("Invalid WebDAV path " + request.getPathInfo()));
                    }
                    return;
                }
                try {
                    if (storage.getRootPath() == null) {
                        storage.setRootPath(this.getRootPath(request));
                    }
                    permissionChecker = null;
                    remoteUser = request.getRemoteUser();
                    if (remoteUser != null) {
                        PrincipalThreadLocal.setName((String)remoteUser);
                        userId = GetterUtil.getLong((String)remoteUser);
                        user = UserLocalServiceUtil.getUserById((long)userId);
                        permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                    }
                    method = MethodFactory.create(request);
                    try {
                        webDavRequest = new WebDAVRequestImpl(storage, request, response, userAgent, permissionChecker);
                        status = method.process(webDavRequest);
                        break block22;
                    }
                    catch (WebDAVException wde) {
                        logError = false;
                        cause = wde;
                        ** while (cause != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (cause instanceof PrincipalException) {
                            logError = true;
                        }
                        cause = cause.getCause();
                        continue;
                    }
lbl38:
                    // 1 sources

                    if (logError) {
                        WebDAVServlet._log.error((Object)wde, (Throwable)wde);
                    } else if (WebDAVServlet._log.isWarnEnabled()) {
                        WebDAVServlet._log.warn((Object)wde, (Throwable)wde);
                    }
                    status = 412;
                }
                catch (Exception e) {
                    WebDAVServlet._log.error((Object)e, (Throwable)e);
                }
            }
            finally {
                response.setStatus(status);
                if (WebDAVServlet._log.isInfoEnabled()) {
                    xLitmus = GetterUtil.getString((String)request.getHeader("X-Litmus"));
                    if (Validator.isNotNull((String)xLitmus)) {
                        xLitmus = String.valueOf(xLitmus) + " ";
                    }
                    WebDAVServlet._log.info((Object)(String.valueOf(xLitmus) + request.getMethod() + " " + request.getRequestURI() + " " + status));
                }
            }
        }
    }

    protected String getRootPath(HttpServletRequest request) {
        String contextPath = HttpUtil.fixPath((String)request.getContextPath(), (boolean)false, (boolean)true);
        String ServletPath = HttpUtil.fixPath((String)request.getServletPath(), (boolean)false, (boolean)true);
        return contextPath.concat(ServletPath);
    }

    protected WebDAVStorage getStorage(HttpServletRequest request) {
        String[] pathArray = WebDAVUtil.getPathArray((String)request.getPathInfo(), (boolean)true);
        WebDAVStorage storage = null;
        if (pathArray.length == 0) {
            storage = (WebDAVStorage)InstancePool.get((String)CompanyWebDAVStorageImpl.class.getName());
        } else if (pathArray.length == 1) {
            storage = (WebDAVStorage)InstancePool.get((String)GroupWebDAVStorageImpl.class.getName());
        } else if (pathArray.length >= 2) {
            storage = WebDAVUtil.getStorage((String)pathArray[1]);
        }
        return storage;
    }

    protected boolean isIgnoredResource(HttpServletRequest request) {
        String[] pathArray = WebDAVUtil.getPathArray((String)request.getPathInfo(), (boolean)true);
        if (pathArray == null || pathArray.length == 0) {
            return false;
        }
        String[] stringArray = PropsValues.WEBDAV_IGNORE;
        int n = PropsValues.WEBDAV_IGNORE.length;
        int n2 = 0;
        while (n2 < n) {
            String ignore = stringArray[n2];
            String[] ignoreArray = ignore.split("/");
            if (ignoreArray.length <= pathArray.length) {
                boolean match = true;
                int i2 = 1;
                while (i2 <= ignoreArray.length) {
                    if (!pathArray[pathArray.length - i2].equals(ignoreArray[ignoreArray.length - i2])) {
                        match = false;
                        break;
                    }
                    ++i2;
                }
                if (match) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Skipping over " + request.getMethod() + " " + request.getPathInfo()));
                    }
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }
}

