/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.webdav.methods.Method;
import javax.servlet.http.HttpServletRequest;

public class CopyMethodImpl
implements Method {
    private static Log _log = LogFactoryUtil.getLog(CopyMethodImpl.class);

    public int process(WebDAVRequest webDavRequest) throws WebDAVException {
        WebDAVStorage storage = webDavRequest.getWebDAVStorage();
        HttpServletRequest request = webDavRequest.getHttpServletRequest();
        long companyId = webDavRequest.getCompanyId();
        String destination = WebDAVUtil.getDestination((HttpServletRequest)request, (String)storage.getRootPath());
        StringBundler sb = new StringBundler();
        if (_log.isInfoEnabled()) {
            sb.append("Destination is ");
            sb.append(destination);
        }
        if (!destination.equals(webDavRequest.getPath()) && WebDAVUtil.getGroupId((long)companyId, (String)destination) == webDavRequest.getGroupId()) {
            Resource resource = storage.getResource(webDavRequest);
            if (resource == null) {
                return 404;
            }
            if (resource.isCollection()) {
                boolean overwrite = WebDAVUtil.isOverwrite((HttpServletRequest)request);
                long depth = WebDAVUtil.getDepth((HttpServletRequest)request);
                if (_log.isInfoEnabled()) {
                    sb.append(", overwrite is ");
                    sb.append(overwrite);
                    sb.append(", depth is ");
                    sb.append(depth);
                    _log.info((Object)sb.toString());
                }
                return storage.copyCollectionResource(webDavRequest, resource, destination, overwrite, depth);
            }
            boolean overwrite = WebDAVUtil.isOverwrite((HttpServletRequest)request);
            if (_log.isInfoEnabled()) {
                sb.append(", overwrite is ");
                sb.append(overwrite);
                _log.info((Object)sb.toString());
            }
            return storage.copySimpleResource(webDavRequest, resource, destination, overwrite);
        }
        return 403;
    }
}

