/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.webdav.InvalidRequestException;
import com.liferay.portal.webdav.methods.BasePropMethodImpl;
import com.liferay.portal.webdav.methods.Method;
import com.liferay.util.xml.XMLFormatter;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropfindMethodImpl
extends BasePropMethodImpl
implements Method {
    private static Log _log = LogFactoryUtil.getLog(PropfindMethodImpl.class);

    @Override
    public int process(WebDAVRequest webDavRequest) throws WebDAVException {
        try {
            Set<QName> props = this.getProps(webDavRequest);
            return this.writeResponseXML(webDavRequest, props);
        }
        catch (InvalidRequestException invalidRequestException) {
            return 400;
        }
        catch (Exception e2) {
            throw new WebDAVException((Throwable)e2);
        }
    }

    protected Set<QName> generateProps(Set<QName> props) {
        props.add(DISPLAYNAME);
        props.add(RESOURCETYPE);
        props.add(GETCONTENTTYPE);
        props.add(GETCONTENTLENGTH);
        props.add(GETLASTMODIFIED);
        props.add(LOCKDISCOVERY);
        return props;
    }

    protected Set<QName> getProps(WebDAVRequest webDavRequest) throws InvalidRequestException {
        try {
            Document doc;
            Element root;
            HashSet<QName> props = new HashSet<QName>();
            HttpServletRequest request = webDavRequest.getHttpServletRequest();
            String xml = new String(FileUtil.getBytes((InputStream)request.getInputStream()));
            if (Validator.isNull((String)xml)) {
                return this.generateProps(props);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Request XML: \n" + XMLFormatter.toString((String)xml, (String)"    ")));
            }
            if ((root = (doc = SAXReaderUtil.read((String)xml)).getRootElement()).element(ALLPROP.getName()) != null) {
                return this.generateProps(props);
            }
            Element prop = root.element("prop");
            for (Element el : prop.elements()) {
                String prefix = el.getNamespacePrefix();
                String uri = el.getNamespaceURI();
                Namespace namespace = WebDAVUtil.createNamespace((String)prefix, (String)uri);
                props.add(SAXReaderUtil.createQName((String)el.getName(), (Namespace)namespace));
            }
            return props;
        }
        catch (Exception e2) {
            throw new InvalidRequestException(e2);
        }
    }
}

