/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.zip;

import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactory;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.zip.ZipReaderImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ZipReaderFactoryImpl
implements ZipReaderFactory {
    public ZipReader getZipReader(File file) {
        ClassLoader portalClassLoader = PACLClassLoaderUtil.getPortalClassLoader();
        ClassLoader contextClassLoader = PACLClassLoaderUtil.getContextClassLoader();
        try {
            if (contextClassLoader != portalClassLoader) {
                PACLClassLoaderUtil.setContextClassLoader(portalClassLoader);
            }
            ZipReaderImpl zipReaderImpl = new ZipReaderImpl(file);
            return zipReaderImpl;
        }
        finally {
            if (contextClassLoader != portalClassLoader) {
                PACLClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public ZipReader getZipReader(InputStream inputStream) throws IOException {
        ClassLoader portalClassLoader = PACLClassLoaderUtil.getPortalClassLoader();
        ClassLoader contextClassLoader = PACLClassLoaderUtil.getContextClassLoader();
        try {
            if (contextClassLoader != portalClassLoader) {
                PACLClassLoaderUtil.setContextClassLoader(portalClassLoader);
            }
            ZipReaderImpl zipReaderImpl = new ZipReaderImpl(inputStream);
            return zipReaderImpl;
        }
        finally {
            if (contextClassLoader != portalClassLoader) {
                PACLClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }
}

