/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.model.Portlet;
import com.liferay.portlet.PortletConfigFactory;
import com.liferay.portlet.PortletConfigImpl;
import com.liferay.portlet.PortletContextFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;

public class PortletConfigFactoryImpl
implements PortletConfigFactory {
    private Map<String, Map<String, PortletConfig>> _pool = new ConcurrentHashMap<String, Map<String, PortletConfig>>();

    public PortletConfig create(Portlet portlet, ServletContext servletContext) {
        Object portletConfig;
        Map<String, PortletConfig> portletConfigs = this._pool.get(portlet.getRootPortletId());
        if (portletConfigs == null) {
            portletConfigs = new ConcurrentHashMap<String, PortletConfig>();
            this._pool.put(portlet.getRootPortletId(), portletConfigs);
        }
        if ((portletConfig = portletConfigs.get(portlet.getPortletId())) == null) {
            PortletContext portletContext = PortletContextFactory.create(portlet, servletContext);
            portletConfig = new PortletConfigImpl(portlet, portletContext);
            portletConfigs.put(portlet.getPortletId(), (PortletConfig)portletConfig);
        }
        return portletConfig;
    }

    public void destroy(Portlet portlet) {
        this._pool.remove(portlet.getRootPortletId());
    }

    public PortletConfig update(Portlet portlet) {
        Map<String, PortletConfig> portletConfigs = this._pool.get(portlet.getRootPortletId());
        if (portletConfigs == null) {
            return null;
        }
        Object portletConfig = portletConfigs.get(portlet.getPortletId());
        PortletContext portletContext = portletConfig.getPortletContext();
        portletConfig = new PortletConfigImpl(portlet, portletContext);
        portletConfigs.put(portlet.getPortletId(), (PortletConfig)portletConfig);
        return portletConfig;
    }
}

