/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.PortletQName;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PortletQNameImpl
implements PortletQName {
    private static final String _KEY_SEPARATOR = "_KEY_";
    private static Log _log = LogFactoryUtil.getLog(PortletQNameImpl.class);
    private Map<String, String> _identifiers;
    private Map<String, QName> _qNames = new ConcurrentHashMap<String, QName>();

    public PortletQNameImpl() {
        this._identifiers = new ConcurrentHashMap<String, String>();
    }

    public String getKey(QName qName) {
        return this.getKey(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public String getKey(String uri, String localPart) {
        return uri.concat(_KEY_SEPARATOR).concat(localPart);
    }

    public String getPublicRenderParameterIdentifier(String publicRenderParameterName) {
        if (!publicRenderParameterName.startsWith("p_r_p_") && !publicRenderParameterName.startsWith("r_p_r_p")) {
            return null;
        }
        return this._identifiers.get(publicRenderParameterName);
    }

    public String getPublicRenderParameterName(QName qName) {
        StringBundler sb = new StringBundler(4);
        sb.append("p_r_p_");
        sb.append(qName.getNamespaceURI().hashCode());
        sb.append("_");
        sb.append(qName.getLocalPart());
        String publicRenderParameterName = sb.toString();
        if (!this._qNames.containsKey(publicRenderParameterName)) {
            this._qNames.put(publicRenderParameterName, qName);
        }
        return publicRenderParameterName;
    }

    public QName getQName(Element qNameEl, Element nameEl, String defaultNamespace) {
        if (qNameEl == null && nameEl == null) {
            _log.error((Object)"both qname and name elements are null");
            return null;
        }
        if (qNameEl == null) {
            return SAXReaderUtil.createQName((String)nameEl.getTextTrim(), (Namespace)SAXReaderUtil.createNamespace((String)defaultNamespace));
        }
        String localPart = qNameEl.getTextTrim();
        int pos = localPart.indexOf(58);
        if (pos == -1) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("qname " + localPart + " does not have a prefix"));
            }
            return SAXReaderUtil.createQName((String)localPart);
        }
        String prefix = localPart.substring(0, pos);
        Namespace namespace = qNameEl.getNamespaceForPrefix(prefix);
        if (namespace == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("qname " + localPart + " does not have a valid namespace"));
            }
            return null;
        }
        localPart = localPart.substring(prefix.length() + 1);
        return SAXReaderUtil.createQName((String)localPart, (Namespace)namespace);
    }

    public QName getQName(String publicRenderParameterName) {
        if (!publicRenderParameterName.startsWith("p_r_p_") && !publicRenderParameterName.startsWith("r_p_r_p")) {
            return null;
        }
        return this._qNames.get(publicRenderParameterName);
    }

    public String getRemovePublicRenderParameterName(QName qName) {
        StringBundler sb = new StringBundler(4);
        sb.append("r_p_r_p");
        sb.append(qName.getNamespaceURI().hashCode());
        sb.append("_");
        sb.append(qName.getLocalPart());
        String removePublicRenderParameterName = sb.toString();
        if (!this._qNames.containsKey(removePublicRenderParameterName)) {
            this._qNames.put(removePublicRenderParameterName, qName);
        }
        return removePublicRenderParameterName;
    }

    public void setPublicRenderParameterIdentifier(String publicRenderParameterName, String identifier) {
        this._identifiers.put(publicRenderParameterName, identifier);
    }
}

