/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletURLListener;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletException;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.UnavailableException;

public class PortletURLListenerFactory {
    private static PortletURLListenerFactory _instance = new PortletURLListenerFactory();
    private Map<String, Map<String, PortletURLGenerationListener>> _pool = new ConcurrentHashMap<String, Map<String, PortletURLGenerationListener>>();

    public static PortletURLGenerationListener create(PortletURLListener portletURLListener) throws PortletException {
        return _instance._create(portletURLListener);
    }

    public static void destroy(PortletURLListener portletURLListener) {
        _instance._destroy(portletURLListener);
    }

    private PortletURLListenerFactory() {
    }

    private PortletURLGenerationListener _create(PortletURLListener portletURLListener) throws PortletException {
        PortletURLGenerationListener portletURLGenerationListener;
        PortletApp portletApp = portletURLListener.getPortletApp();
        Map<String, PortletURLGenerationListener> portletURLGenerationListeners = this._pool.get(portletApp.getServletContextName());
        if (portletURLGenerationListeners == null) {
            portletURLGenerationListeners = new ConcurrentHashMap<String, PortletURLGenerationListener>();
            this._pool.put(portletApp.getServletContextName(), portletURLGenerationListeners);
        }
        if ((portletURLGenerationListener = portletURLGenerationListeners.get(portletURLListener.getListenerClass())) == null) {
            if (portletApp.isWARFile()) {
                PortletContextBag portletContextBag = PortletContextBagPool.get(portletApp.getServletContextName());
                portletURLGenerationListener = portletContextBag.getPortletURLListeners().get(portletURLListener.getListenerClass());
                portletURLGenerationListener = this._init(portletURLListener, portletURLGenerationListener);
            } else {
                portletURLGenerationListener = this._init(portletURLListener);
            }
            portletURLGenerationListeners.put(portletURLListener.getListenerClass(), portletURLGenerationListener);
        }
        return portletURLGenerationListener;
    }

    private void _destroy(PortletURLListener portletURLListener) {
        PortletApp portletApp = portletURLListener.getPortletApp();
        Map<String, PortletURLGenerationListener> portletURLGenerationListeners = this._pool.get(portletApp.getServletContextName());
        if (portletURLGenerationListeners == null) {
            return;
        }
        PortletURLGenerationListener portletURLGenerationListener = portletURLGenerationListeners.get(portletURLListener.getListenerClass());
        if (portletURLGenerationListener == null) {
            return;
        }
        portletURLGenerationListeners.remove(portletURLListener.getListenerClass());
    }

    private PortletURLGenerationListener _init(PortletURLListener portletURLListener) throws PortletException {
        return this._init(portletURLListener, null);
    }

    private PortletURLGenerationListener _init(PortletURLListener portletURLListener, PortletURLGenerationListener portletURLGenerationListener) throws PortletException {
        try {
            if (portletURLGenerationListener == null) {
                portletURLGenerationListener = (PortletURLGenerationListener)InstanceFactory.newInstance((String)portletURLListener.getListenerClass());
            }
        }
        catch (Exception e2) {
            throw new UnavailableException(e2.getMessage());
        }
        return portletURLGenerationListener;
    }
}

