/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderParametersPool {
    public static void clear(HttpServletRequest request, long plid) {
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.get(request, plid);
        plidPool.clear();
    }

    public static void clear(HttpServletRequest request, long plid, String portletId) {
        Map<String, String[]> params = RenderParametersPool.get(request, plid, portletId);
        params.clear();
    }

    public static Map<String, Map<String, String[]>> get(HttpServletRequest request, long plid) {
        HttpSession session = request.getSession();
        if (plid <= 0L) {
            return new ConcurrentHashMap<String, Map<String, String[]>>();
        }
        Map<Long, Map<String, Map<String, String[]>>> pool = RenderParametersPool._getRenderParametersPool(session);
        Map<String, Map<String, String[]>> plidPool = pool.get(plid);
        if (plidPool == null) {
            plidPool = new ConcurrentHashMap<String, Map<String, String[]>>();
            pool.put(plid, plidPool);
        }
        return plidPool;
    }

    public static Map<String, String[]> get(HttpServletRequest request, long plid, String portletId) {
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.get(request, plid);
        Map<String, String[]> params = plidPool.get(portletId);
        if (params == null) {
            params = new HashMap<String, String[]>();
            plidPool.put(portletId, params);
        }
        return params;
    }

    public static void put(HttpServletRequest request, long plid, String portletId, Map<String, String[]> params) {
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.get(request, plid);
        plidPool.put(portletId, params);
    }

    private static Map<Long, Map<String, Map<String, String[]>>> _getRenderParametersPool(HttpSession session) {
        ConcurrentHashMap renderParametersPool = (ConcurrentHashMap)session.getAttribute("PORTLET_RENDER_PARAMETERS_");
        if (renderParametersPool == null) {
            renderParametersPool = new ConcurrentHashMap();
            session.setAttribute("PORTLET_RENDER_PARAMETERS_", renderParametersPool);
        }
        return renderParametersPool;
    }
}

