/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.util;

import com.liferay.portal.model.Group;
import com.liferay.portal.model.Permission;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;

public class CleanUpPermissionsUtil {
    public static void cleanUpAddToPagePermissions(ActionRequest actionRequest) throws Exception {
        if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 5) {
            CleanUpPermissionsUtil._cleanUpAddToPagePermissions_5(actionRequest);
        } else if (PropsValues.PERMISSIONS_USER_CHECK_ALGORITHM == 6) {
            CleanUpPermissionsUtil._cleanUpAddToPagePermissions_6(actionRequest);
        }
    }

    private static void _cleanUpAddToPagePermissions_5(ActionRequest actionRequest) throws Exception {
        long companyId = PortalUtil.getCompanyId((PortletRequest)actionRequest);
        Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
        CleanUpPermissionsUtil._cleanUpAddToPagePermissions_5(companyId, role.getRoleId(), false);
        role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User");
        CleanUpPermissionsUtil._cleanUpAddToPagePermissions_5(companyId, role.getRoleId(), false);
        role = RoleLocalServiceUtil.getRole((long)companyId, (String)"User");
        CleanUpPermissionsUtil._cleanUpAddToPagePermissions_5(companyId, role.getRoleId(), true);
    }

    private static void _cleanUpAddToPagePermissions_5(long companyId, long roleId, boolean limitScope) throws Exception {
        List rolePermissions = PermissionLocalServiceUtil.getRolePermissions((long)roleId);
        Group userPersonalSite = GroupLocalServiceUtil.getGroup((long)companyId, (String)"User Personal Site");
        String groupIdString = String.valueOf(userPersonalSite.getGroupId());
        for (Permission permission : rolePermissions) {
            if (permission.getActionId() != "ADD_TO_PAGE") continue;
            PermissionLocalServiceUtil.unsetRolePermission((long)roleId, (long)companyId, (String)permission.getName(), (int)permission.getScope(), (String)permission.getPrimKey(), (String)"ADD_TO_PAGE");
            if (!limitScope || groupIdString.equals(permission.getPrimKey())) continue;
            PermissionLocalServiceUtil.setRolePermission((long)roleId, (long)companyId, (String)permission.getName(), (int)2, (String)groupIdString, (String)"ADD_TO_PAGE");
        }
    }

    private static void _cleanUpAddToPagePermissions_6(ActionRequest actionRequest) throws Exception {
        long companyId = PortalUtil.getCompanyId((PortletRequest)actionRequest);
        Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
        CleanUpPermissionsUtil._cleanUpAddToPagePermissions_6(companyId, role.getRoleId(), false);
        role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User");
        CleanUpPermissionsUtil._cleanUpAddToPagePermissions_6(companyId, role.getRoleId(), false);
        role = RoleLocalServiceUtil.getRole((long)companyId, (String)"User");
        CleanUpPermissionsUtil._cleanUpAddToPagePermissions_6(companyId, role.getRoleId(), true);
    }

    private static void _cleanUpAddToPagePermissions_6(long companyId, long roleId, boolean limitScope) throws Exception {
        List roleResourcePermissions = ResourcePermissionLocalServiceUtil.getRoleResourcePermissions((long)roleId);
        Group userPersonalSite = GroupLocalServiceUtil.getGroup((long)companyId, (String)"User Personal Site");
        String groupIdString = String.valueOf(userPersonalSite.getGroupId());
        for (ResourcePermission resourcePermission : roleResourcePermissions) {
            if (!resourcePermission.hasActionId("ADD_TO_PAGE")) continue;
            ResourcePermissionLocalServiceUtil.removeResourcePermission((long)companyId, (String)resourcePermission.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)roleId, (String)"ADD_TO_PAGE");
            if (!limitScope || groupIdString.equals(resourcePermission.getPrimKey())) continue;
            ResourcePermissionLocalServiceUtil.addResourcePermission((long)companyId, (String)resourcePermission.getName(), (int)2, (String)groupIdString, (long)roleId, (String)"ADD_TO_PAGE");
        }
    }
}

