/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;

public class OmniadminUtil {
    private static Log _log = LogFactoryUtil.getLog(OmniadminUtil.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isOmniadmin(long userId) {
        if (CompanyThreadLocal.getCompanyId() != PortalInstances.getDefaultCompanyId()) {
            return false;
        }
        if (userId <= 0L) {
            return false;
        }
        try {
            if (PropsValues.OMNIADMIN_USERS.length > 0) {
                int i2 = 0;
                while (i2 < PropsValues.OMNIADMIN_USERS.length) {
                    if (PropsValues.OMNIADMIN_USERS[i2] == userId) {
                        User user = UserLocalServiceUtil.getUserById((long)userId);
                        return user.getCompanyId() == PortalInstances.getDefaultCompanyId();
                    }
                    ++i2;
                }
                return false;
            }
            User user = UserLocalServiceUtil.getUserById((long)userId);
            if (user.getCompanyId() != PortalInstances.getDefaultCompanyId()) {
                return false;
            }
            return RoleLocalServiceUtil.hasUserRole((long)userId, (long)user.getCompanyId(), (String)"Administrator", (boolean)true);
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
            return false;
        }
    }
}

