/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.amazonrankings.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.amazonrankings.model.AmazonRankings;
import com.liferay.portlet.amazonrankings.util.AmazonRankingsUtil;
import com.liferay.portlet.amazonrankings.util.AmazonSignedRequestsUtil;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class AmazonRankingsWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 1200000L;
    private static Log _log = LogFactoryUtil.getLog(AmazonRankingsWebCacheItem.class);
    private String _isbn;

    public AmazonRankingsWebCacheItem(String isbn) {
        this._isbn = isbn;
    }

    public Object convert(String key) {
        AmazonRankings amazonRankings = null;
        try {
            amazonRankings = this.doConvert(key);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return amazonRankings;
    }

    public long getRefreshTime() {
        return 1200000L;
    }

    protected AmazonRankings doConvert(String key) throws Exception {
        Element errorsElement;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("AssociateTag", AmazonRankingsUtil.getAmazonAssociateTag());
        parameters.put("AWSAccessKeyId", AmazonRankingsUtil.getAmazonAccessKeyId());
        parameters.put("IdType", "ASIN");
        parameters.put("ItemId", this._isbn);
        parameters.put("Operation", "ItemLookup");
        parameters.put("ResponseGroup", "Images,ItemAttributes,Offers,SalesRank");
        parameters.put("Service", "AWSECommerceService");
        parameters.put("Timestamp", AmazonRankingsUtil.getTimestamp());
        String urlWithSignature = AmazonSignedRequestsUtil.generateUrlWithSignature(parameters);
        String xml = HttpUtil.URLtoString((String)urlWithSignature);
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        if (rootElement == null) {
            return null;
        }
        if (this.hasErrorMessage(rootElement)) {
            return null;
        }
        Element itemsElement = rootElement.element("Items");
        if (itemsElement == null) {
            return null;
        }
        Element requestElement = itemsElement.element("Request");
        if (requestElement != null && this.hasErrorMessage(errorsElement = requestElement.element("Errors"))) {
            return null;
        }
        Element itemElement = itemsElement.element("Item");
        if (itemElement == null) {
            return null;
        }
        Element itemAttributesElement = itemElement.element("ItemAttributes");
        if (itemAttributesElement == null) {
            return null;
        }
        String productName = itemAttributesElement.elementText("Title");
        String catalog = "";
        String[] authors = this.getAuthors(itemAttributesElement);
        String releaseDateAsString = itemAttributesElement.elementText("PublicationDate");
        Date releaseDate = this.getReleaseDate(releaseDateAsString);
        String manufacturer = itemAttributesElement.elementText("Manufacturer");
        String smallImageURL = this.getImageURL(itemElement, "SmallImage");
        String mediumImageURL = this.getImageURL(itemElement, "MediumImage");
        String largeImageURL = this.getImageURL(itemElement, "LargeImage");
        double listPrice = this.getPrice(itemAttributesElement.element("ListPrice"));
        double ourPrice = 0.0;
        Element offerListingElement = this.getOfferListing(itemElement);
        if (offerListingElement != null) {
            ourPrice = this.getPrice(offerListingElement.element("Price"));
        }
        double usedPrice = 0.0;
        double collectiblePrice = 0.0;
        double thirdPartyNewPrice = 0.0;
        Element offerSummaryElement = itemElement.element("OfferSummary");
        if (offerSummaryElement != null) {
            usedPrice = this.getPrice(offerSummaryElement.element("LowestUsedPrice"));
            collectiblePrice = this.getPrice(offerSummaryElement.element("LowestCollectiblePrice"));
            thirdPartyNewPrice = this.getPrice(offerSummaryElement.element("LowestNewPrice"));
        }
        int salesRank = GetterUtil.getInteger((String)itemElement.elementText("SalesRank"));
        String media = "";
        String availability = this.getAvailability(offerListingElement);
        return new AmazonRankings(this._isbn, productName, catalog, authors, releaseDate, releaseDateAsString, manufacturer, smallImageURL, mediumImageURL, largeImageURL, listPrice, ourPrice, usedPrice, collectiblePrice, thirdPartyNewPrice, salesRank, media, availability);
    }

    protected String[] getAuthors(Element itemAttributesElement) {
        ArrayList<String> authors = new ArrayList<String>();
        for (Element authorElement : itemAttributesElement.elements("Author")) {
            authors.add(authorElement.getText());
        }
        return authors.toArray(new String[authors.size()]);
    }

    protected String getAvailability(Element offerListingElement) {
        if (offerListingElement == null) {
            return null;
        }
        Element availabilityElement = offerListingElement.element("Availability");
        return availabilityElement.elementText("Availability");
    }

    protected String getImageURL(Element itemElement, String name) {
        String imageURL = null;
        Element imageElement = itemElement.element(name);
        if (imageElement != null) {
            imageURL = imageElement.elementText("URL");
        }
        return imageURL;
    }

    protected Element getOfferListing(Element itemElement) {
        Element offersElement = itemElement.element("Offers");
        if (offersElement == null) {
            return null;
        }
        Element offerElement = offersElement.element("Offer");
        if (offerElement == null) {
            return null;
        }
        return offerElement.element("OfferListing");
    }

    protected double getPrice(Element priceElement) {
        if (priceElement == null) {
            return 0.0;
        }
        return (double)GetterUtil.getInteger((String)priceElement.elementText("Amount")) * 0.01;
    }

    protected Date getReleaseDate(String releaseDateAsString) {
        if (Validator.isNull((String)releaseDateAsString)) {
            return null;
        }
        DateFormat dateFormat = null;
        dateFormat = releaseDateAsString.length() > 7 ? DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd", (Locale)Locale.US) : DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM", (Locale)Locale.US);
        return GetterUtil.getDate((String)releaseDateAsString, (DateFormat)dateFormat);
    }

    protected boolean hasErrorMessage(Element element) {
        if (element == null) {
            return false;
        }
        Element errorElement = element.element("Error");
        if (errorElement == null) {
            return false;
        }
        Element messageElement = errorElement.element("Message");
        if (messageElement == null) {
            return false;
        }
        _log.error((Object)messageElement.getText());
        return true;
    }
}

