/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnouncementsUtil {
    private static final long _GROUP_CLASS_NAME_ID = PortalUtil.getClassNameId((String)Group.class.getName());
    private static final long _ORGANIZATION_CLASS_NAME_ID = PortalUtil.getClassNameId((String)Organization.class.getName());
    private static final long _ROLE_CLASS_NAME_ID = PortalUtil.getClassNameId((String)Role.class.getName());
    private static final long _USER_CLASS_NAME_ID = PortalUtil.getClassNameId((String)User.class.getName());
    private static final long _USER_GROUP_CLASS_NAME_ID = PortalUtil.getClassNameId((String)UserGroup.class.getName());

    public static LinkedHashMap<Long, long[]> getAnnouncementScopes(long userId) throws PortalException, SystemException {
        List userGroups;
        List groups;
        LinkedHashMap<Long, long[]> scopes = new LinkedHashMap<Long, long[]>();
        scopes.put(new Long(0L), new long[1]);
        scopes.put(_USER_CLASS_NAME_ID, new long[]{userId});
        ArrayList<Group> groupsList = new ArrayList<Group>();
        List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)userId);
        if (!organizations.isEmpty()) {
            ArrayList<Organization> organizationsList = new ArrayList<Organization>();
            organizationsList.addAll(organizations);
            for (Organization organization : organizations) {
                groupsList.add(organization.getGroup());
                List parentOrganizations = OrganizationLocalServiceUtil.getParentOrganizations((long)organization.getOrganizationId());
                Iterator iterator = parentOrganizations.iterator();
                while (iterator.hasNext()) {
                    Organization parentOrganization = (Organization)iterator.next();
                    organizationsList.add(parentOrganization);
                    groupsList.add(parentOrganization.getGroup());
                }
            }
            scopes.put(_ORGANIZATION_CLASS_NAME_ID, AnnouncementsUtil._getOrganizationIds(organizationsList));
        }
        if (!(groups = GroupLocalServiceUtil.getUserGroups((long)userId, (boolean)true)).isEmpty()) {
            scopes.put(_GROUP_CLASS_NAME_ID, AnnouncementsUtil._getGroupIds(groups));
            groupsList.addAll(groups);
        }
        if (!(userGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)userId)).isEmpty()) {
            scopes.put(_USER_GROUP_CLASS_NAME_ID, AnnouncementsUtil._getUserGroupIds(userGroups));
            for (UserGroup userGroup : userGroups) {
                groupsList.add(userGroup.getGroup());
            }
        }
        List<Role> roles = new ArrayList();
        if (!groupsList.isEmpty()) {
            roles = RoleLocalServiceUtil.getUserRelatedRoles((long)userId, groupsList);
            roles = ListUtil.copy(roles);
            for (Group group : groupsList) {
                roles.addAll(RoleLocalServiceUtil.getUserGroupRoles((long)userId, (long)group.getGroupId()));
                roles.addAll(RoleLocalServiceUtil.getUserGroupGroupRoles((long)userId, (long)group.getGroupId()));
            }
        } else {
            roles = RoleLocalServiceUtil.getUserRoles((long)userId);
        }
        if (roles.size() > 0) {
            scopes.put(_ROLE_CLASS_NAME_ID, AnnouncementsUtil._getRoleIds(roles));
        }
        return scopes;
    }

    private static long[] _getGroupIds(List<Group> groups) {
        long[] groupIds = new long[groups.size()];
        int i2 = 0;
        for (Group group : groups) {
            groupIds[i2++] = group.getGroupId();
        }
        return groupIds;
    }

    private static long[] _getOrganizationIds(List<Organization> organizations) {
        long[] organizationIds = new long[organizations.size()];
        int i2 = 0;
        for (Organization organization : organizations) {
            organizationIds[i2++] = organization.getOrganizationId();
        }
        return organizationIds;
    }

    private static long[] _getRoleIds(List<Role> roles) {
        long[] roleIds = new long[roles.size()];
        int i2 = 0;
        for (Role role : roles) {
            roleIds[i2++] = role.getRoleId();
        }
        return roleIds;
    }

    private static long[] _getUserGroupIds(List<UserGroup> userGroups) {
        long[] userGroupIds = new long[userGroups.size()];
        int i2 = 0;
        for (UserGroup userGroup : userGroups) {
            userGroupIds[i2++] = userGroup.getUserGroupId();
        }
        return userGroupIds;
    }
}

