/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.lar.ImportExportThreadLocal;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.FacetedSearcher;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.facet.AssetEntriesFacet;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.ScopeFacet;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.NoSuchEntryException;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.service.base.AssetEntryLocalServiceBaseImpl;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.asset.util.AssetEntryValidator;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.wiki.model.WikiPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetEntryLocalServiceImpl
extends AssetEntryLocalServiceBaseImpl {
    public void deleteEntry(AssetEntry entry) throws PortalException, SystemException {
        List tags = this.assetEntryPersistence.getAssetTags(entry.getEntryId());
        this.assetEntryPersistence.remove((BaseModel)entry);
        this.assetLinkLocalService.deleteLinks(entry.getEntryId());
        for (AssetTag tag : tags) {
            if (!entry.isVisible()) continue;
            this.assetTagLocalService.decrementAssetCount(tag.getTagId(), entry.getClassNameId());
        }
        this.socialActivityLocalService.deleteActivities(entry);
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        AssetEntry entry = this.assetEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public void deleteEntry(String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry != null) {
            this.deleteEntry(entry);
        }
    }

    public AssetEntry fetchEntry(long entryId) throws SystemException {
        return this.assetEntryPersistence.fetchByPrimaryKey(entryId);
    }

    public AssetEntry fetchEntry(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
    }

    public List<AssetEntry> getAncestorEntries(long entryId) throws PortalException, SystemException {
        ArrayList<AssetEntry> entries = new ArrayList<AssetEntry>();
        AssetEntry parentEntry = this.getParentEntry(entryId);
        while (parentEntry != null) {
            entries.add(parentEntry);
            parentEntry = this.getParentEntry(parentEntry.getEntryId());
        }
        return entries;
    }

    public List<AssetEntry> getChildEntries(long entryId) throws PortalException, SystemException {
        ArrayList<AssetEntry> entries = new ArrayList<AssetEntry>();
        List links = this.assetLinkLocalService.getDirectLinks(entryId, 1);
        for (AssetLink link : links) {
            AssetEntry curAsset = this.getEntry(link.getEntryId2());
            entries.add(curAsset);
        }
        return entries;
    }

    public List<AssetEntry> getCompanyEntries(long companyId, int start, int end) throws SystemException {
        return this.assetEntryPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyEntriesCount(long companyId) throws SystemException {
        return this.assetEntryPersistence.countByCompanyId(companyId);
    }

    public List<AssetEntry> getEntries(AssetEntryQuery entryQuery) throws SystemException {
        return this.assetEntryFinder.findEntries(entryQuery);
    }

    public int getEntriesCount(AssetEntryQuery entryQuery) throws SystemException {
        return this.assetEntryFinder.countEntries(entryQuery);
    }

    public AssetEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.assetEntryPersistence.findByPrimaryKey(entryId);
    }

    public AssetEntry getEntry(long groupId, String classUuid) throws PortalException, SystemException {
        return this.assetEntryPersistence.findByG_CU(groupId, classUuid);
    }

    public AssetEntry getEntry(String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.assetEntryPersistence.findByC_C(classNameId, classPK);
    }

    public AssetEntry getNextEntry(long entryId) throws PortalException, SystemException {
        try {
            this.getParentEntry(entryId);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            List<AssetEntry> childEntries = this.getChildEntries(entryId);
            if (childEntries.isEmpty()) {
                throw new NoSuchEntryException();
            }
            return childEntries.get(0);
        }
        List links = this.assetLinkLocalService.getDirectLinks(entryId, 1);
        int i2 = 0;
        while (i2 < links.size()) {
            AssetLink link = (AssetLink)links.get(i2);
            if (link.getEntryId2() == entryId) {
                if (i2 + 1 >= links.size()) {
                    throw new NoSuchEntryException();
                }
                AssetLink nextLink = (AssetLink)links.get(i2 + 1);
                return this.getEntry(nextLink.getEntryId2());
            }
            ++i2;
        }
        throw new NoSuchEntryException();
    }

    public AssetEntry getParentEntry(long entryId) throws PortalException, SystemException {
        List links = this.assetLinkLocalService.getReverseLinks(entryId, 1);
        if (links.isEmpty()) {
            throw new NoSuchEntryException();
        }
        AssetLink link = (AssetLink)links.get(0);
        return this.getEntry(link.getEntryId1());
    }

    public AssetEntry getPreviousEntry(long entryId) throws PortalException, SystemException {
        this.getParentEntry(entryId);
        List links = this.assetLinkLocalService.getDirectLinks(entryId, 1);
        int i2 = 0;
        while (i2 < links.size()) {
            AssetLink link = (AssetLink)links.get(i2);
            if (link.getEntryId2() == entryId) {
                if (i2 == 0) {
                    throw new NoSuchEntryException();
                }
                AssetLink nextAssetLink = (AssetLink)links.get(i2 - 1);
                return this.getEntry(nextAssetLink.getEntryId2());
            }
            ++i2;
        }
        throw new NoSuchEntryException();
    }

    public List<AssetEntry> getTopViewedEntries(String className, boolean asc, int start, int end) throws SystemException {
        return this.getTopViewedEntries(new String[]{className}, asc, start, end);
    }

    public List<AssetEntry> getTopViewedEntries(String[] className, boolean asc, int start, int end) throws SystemException {
        long[] classNameIds = new long[className.length];
        int i2 = 0;
        while (i2 < className.length) {
            classNameIds[i2] = PortalUtil.getClassNameId((String)className[i2]);
            ++i2;
        }
        AssetEntryQuery entryQuery = new AssetEntryQuery();
        entryQuery.setClassNameIds(classNameIds);
        entryQuery.setEnd(end);
        entryQuery.setExcludeZeroViewCount(true);
        entryQuery.setOrderByCol1("viewCount");
        entryQuery.setOrderByType1(asc ? "ASC" : "DESC");
        entryQuery.setStart(start);
        return this.assetEntryFinder.findEntries(entryQuery);
    }

    @BufferedIncrement(incrementClass=NumberIncrement.class)
    public AssetEntry incrementViewCounter(long userId, String className, long classPK, int increment) throws SystemException {
        if (!PropsValues.ASSET_ENTRY_INCREMENT_VIEW_COUNTER_ENABLED) {
            return null;
        }
        if (classPK <= 0L) {
            return null;
        }
        long classNameId = PortalUtil.getClassNameId((String)className);
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry == null) {
            return null;
        }
        entry.setViewCount(entry.getViewCount() + increment);
        this.assetEntryPersistence.update((BaseModel)entry, false);
        return entry;
    }

    public void reindex(List<AssetEntry> entries) throws PortalException {
        for (AssetEntry entry : entries) {
            String className = PortalUtil.getClassName((long)entry.getClassNameId());
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)className);
            indexer.reindex(className, entry.getClassPK());
        }
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, String keywords, int start, int end) throws SystemException {
        try {
            SearchContext searchContext = new SearchContext();
            AssetEntriesFacet assetEntriesFacet = new AssetEntriesFacet(searchContext);
            assetEntriesFacet.setStatic(true);
            searchContext.addFacet((Facet)assetEntriesFacet);
            ScopeFacet scopeFacet = new ScopeFacet(searchContext);
            scopeFacet.setStatic(true);
            searchContext.addFacet((Facet)scopeFacet);
            searchContext.setAttribute("paginationType", (Serializable)((Object)"regular"));
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            searchContext.setEntryClassNames(this.getClassNames(className));
            searchContext.setGroupIds(groupIds);
            searchContext.setKeywords(keywords);
            QueryConfig queryConfig = new QueryConfig();
            queryConfig.setHighlightEnabled(false);
            queryConfig.setScoreEnabled(false);
            searchContext.setQueryConfig(queryConfig);
            searchContext.setStart(start);
            searchContext.setUserId(userId);
            Indexer indexer = FacetedSearcher.getInstance();
            return indexer.search(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public Hits search(long companyId, long[] groupIds, long userId, String className, String userName, String title, String description, String assetCategoryIds, String assetTagNames, boolean andSearch, int start, int end) throws SystemException {
        try {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("description", description);
            attributes.put("title", title);
            attributes.put("userName", userName);
            attributes.put("paginationType", "regular");
            SearchContext searchContext = new SearchContext();
            AssetEntriesFacet assetEntriesFacet = new AssetEntriesFacet(searchContext);
            assetEntriesFacet.setStatic(true);
            searchContext.addFacet((Facet)assetEntriesFacet);
            ScopeFacet scopeFacet = new ScopeFacet(searchContext);
            scopeFacet.setStatic(true);
            searchContext.addFacet((Facet)scopeFacet);
            searchContext.setAndSearch(andSearch);
            searchContext.setAssetCategoryIds(StringUtil.split((String)assetCategoryIds, (long)0L));
            searchContext.setAssetTagNames(StringUtil.split((String)assetTagNames));
            searchContext.setAttributes(attributes);
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            searchContext.setEntryClassNames(this.getClassNames(className));
            searchContext.setGroupIds(groupIds);
            QueryConfig queryConfig = new QueryConfig();
            queryConfig.setHighlightEnabled(false);
            queryConfig.setScoreEnabled(false);
            searchContext.setQueryConfig(queryConfig);
            searchContext.setStart(start);
            searchContext.setUserId(userId);
            Indexer indexer = FacetedSearcher.getInstance();
            return indexer.search(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public Hits search(long companyId, long[] groupIds, String className, String keywords, int start, int end) throws SystemException {
        return this.search(companyId, groupIds, 0L, className, keywords, start, end);
    }

    public AssetEntry updateEntry(long userId, long groupId, String className, long classPK, long[] categoryIds, String[] tagNames) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry != null) {
            return this.updateEntry(userId, groupId, className, classPK, entry.getClassUuid(), entry.getClassTypeId(), categoryIds, tagNames, entry.isVisible(), entry.getStartDate(), entry.getEndDate(), entry.getPublishDate(), entry.getExpirationDate(), entry.getMimeType(), entry.getTitle(), entry.getDescription(), entry.getSummary(), entry.getUrl(), entry.getLayoutUuid(), entry.getHeight(), entry.getWidth(), GetterUtil.getInteger((Object)entry.getPriority()), false);
        }
        return this.updateEntry(userId, groupId, className, classPK, null, 0L, categoryIds, tagNames, true, null, null, null, null, null, null, null, null, null, null, 0, 0, null, false);
    }

    public AssetEntry updateEntry(long userId, long groupId, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Integer priority, boolean sync) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        this.validate(groupId, className, categoryIds, tagNames);
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        boolean oldVisible = false;
        if (entry != null) {
            oldVisible = entry.isVisible();
        }
        if (entry == null) {
            long entryId = this.counterLocalService.increment();
            entry = this.assetEntryPersistence.create(entryId);
            entry.setCompanyId(user.getCompanyId());
            entry.setUserId(user.getUserId());
            entry.setUserName(user.getFullName());
            entry.setCreateDate(now);
            entry.setClassNameId(classNameId);
            entry.setClassPK(classPK);
            entry.setClassUuid(classUuid);
            entry.setVisible(visible);
            entry.setPublishDate(publishDate);
            entry.setExpirationDate(expirationDate);
            if (priority == null) {
                entry.setPriority(0.0);
            }
            entry.setViewCount(0);
        }
        entry.setGroupId(groupId);
        entry.setModifiedDate(now);
        entry.setClassTypeId(classTypeId);
        entry.setVisible(visible);
        entry.setStartDate(startDate);
        entry.setEndDate(endDate);
        entry.setPublishDate(publishDate);
        entry.setExpirationDate(expirationDate);
        entry.setMimeType(mimeType);
        entry.setTitle(title);
        entry.setDescription(description);
        entry.setSummary(summary);
        entry.setUrl(url);
        entry.setLayoutUuid(layoutUuid);
        entry.setHeight(height);
        entry.setWidth(width);
        if (priority != null) {
            entry.setPriority((double)priority.intValue());
        }
        if (categoryIds != null) {
            this.assetEntryPersistence.setAssetCategories(entry.getEntryId(), categoryIds);
        }
        if (tagNames != null) {
            long parentGroupId = PortalUtil.getParentGroupId((long)groupId);
            ArrayList<AssetTag> tags = new ArrayList<AssetTag>(tagNames.length);
            String[] stringArray = tagNames;
            int n = tagNames.length;
            int n2 = 0;
            while (n2 < n) {
                String tagName = stringArray[n2];
                AssetTag tag = null;
                try {
                    tag = this.assetTagLocalService.getTag(parentGroupId, tagName);
                }
                catch (NoSuchTagException noSuchTagException) {
                    ServiceContext serviceContext = new ServiceContext();
                    serviceContext.setAddGroupPermissions(true);
                    serviceContext.setAddGuestPermissions(true);
                    serviceContext.setScopeGroupId(parentGroupId);
                    tag = this.assetTagLocalService.addTag(user.getUserId(), tagName, PropsValues.ASSET_TAG_PROPERTIES_DEFAULT, serviceContext);
                }
                if (tag != null) {
                    tags.add(tag);
                }
                ++n2;
            }
            List oldTags = this.assetEntryPersistence.getAssetTags(entry.getEntryId());
            this.assetEntryPersistence.setAssetTags(entry.getEntryId(), tags);
            if (entry.isVisible()) {
                boolean isNew = entry.isNew();
                this.assetEntryPersistence.updateImpl(entry, false);
                if (isNew) {
                    for (AssetTag tag : tags) {
                        this.assetTagLocalService.incrementAssetCount(tag.getTagId(), classNameId);
                    }
                } else {
                    for (AssetTag oldTag : oldTags) {
                        if (tags.contains(oldTag)) continue;
                        this.assetTagLocalService.decrementAssetCount(oldTag.getTagId(), classNameId);
                    }
                    for (AssetTag tag : tags) {
                        if (oldTags.contains(tag)) continue;
                        this.assetTagLocalService.incrementAssetCount(tag.getTagId(), classNameId);
                    }
                }
            } else if (oldVisible) {
                for (AssetTag oldTag : oldTags) {
                    this.assetTagLocalService.decrementAssetCount(oldTag.getTagId(), classNameId);
                }
            }
        }
        this.assetEntryPersistence.update((BaseModel)entry, false);
        if (!sync) {
            return entry;
        }
        if (className.equals(BlogsEntry.class.getName())) {
            BlogsEntry blogsEntry = this.blogsEntryPersistence.findByPrimaryKey(classPK);
            blogsEntry.setTitle(title);
            this.blogsEntryPersistence.update((BaseModel)blogsEntry, false);
        } else if (className.equals(BookmarksEntry.class.getName())) {
            BookmarksEntry bookmarksEntry = this.bookmarksEntryPersistence.findByPrimaryKey(classPK);
            bookmarksEntry.setName(title);
            bookmarksEntry.setDescription(description);
            bookmarksEntry.setUrl(url);
            this.bookmarksEntryPersistence.update((BaseModel)bookmarksEntry, false);
        } else if (className.equals(DLFileEntry.class.getName())) {
            DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByPrimaryKey(classPK);
            dlFileEntry.setTitle(title);
            dlFileEntry.setDescription(description);
            this.dlFileEntryPersistence.update((BaseModel)dlFileEntry, false);
        } else if (className.equals(JournalArticle.class.getName())) {
            JournalArticle journalArticle = this.journalArticlePersistence.findByPrimaryKey(classPK);
            journalArticle.setTitle(title);
            journalArticle.setDescription(description);
            this.journalArticlePersistence.update((BaseModel)journalArticle, false);
        } else if (className.equals(MBMessage.class.getName())) {
            MBMessage mbMessage = this.mbMessagePersistence.findByPrimaryKey(classPK);
            mbMessage.setSubject(title);
            this.mbMessagePersistence.update((BaseModel)mbMessage, false);
        } else if (className.equals(WikiPage.class.getName())) {
            WikiPage wikiPage = this.wikiPagePersistence.findByPrimaryKey(classPK);
            wikiPage.setTitle(title);
            this.wikiPagePersistence.update((BaseModel)wikiPage, false);
        }
        return entry;
    }

    public AssetEntry updateEntry(String className, long classPK, Date publishDate, Date expirationDate, boolean visible) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        AssetEntry entry = this.assetEntryPersistence.findByC_C(classNameId, classPK);
        entry.setExpirationDate(expirationDate);
        entry.setPublishDate(publishDate);
        this.updateVisible(entry, visible);
        this.assetEntryPersistence.update((BaseModel)entry, false);
        return entry;
    }

    public AssetEntry updateVisible(String className, long classPK, boolean visible) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        AssetEntry entry = this.assetEntryPersistence.findByC_C(classNameId, classPK);
        List tags = this.assetEntryPersistence.getAssetTags(entry.getEntryId());
        if (visible && !entry.isVisible()) {
            for (AssetTag tag : tags) {
                this.assetTagLocalService.incrementAssetCount(tag.getTagId(), classNameId);
            }
        } else if (!visible && entry.isVisible()) {
            for (AssetTag tag : tags) {
                this.assetTagLocalService.decrementAssetCount(tag.getTagId(), classNameId);
            }
        }
        entry.setVisible(visible);
        this.assetEntryPersistence.update((BaseModel)entry, false);
        return entry;
    }

    public void validate(long groupId, String className, long[] categoryIds, String[] tagNames) throws PortalException, SystemException {
        if (ImportExportThreadLocal.isImportInProcess()) {
            return;
        }
        AssetEntryValidator validator = (AssetEntryValidator)InstancePool.get((String)PropsValues.ASSET_ENTRY_VALIDATOR);
        validator.validate(groupId, className, categoryIds, tagNames);
    }

    protected String[] getClassNames(String className) {
        if (Validator.isNotNull((String)className)) {
            return new String[]{className};
        }
        List rendererFactories = AssetRendererFactoryRegistryUtil.getAssetRendererFactories();
        String[] classNames = new String[rendererFactories.size()];
        int i2 = 0;
        while (i2 < rendererFactories.size()) {
            AssetRendererFactory rendererFactory = (AssetRendererFactory)rendererFactories.get(i2);
            classNames[i2] = rendererFactory.getClassName();
            ++i2;
        }
        return classNames;
    }

    protected AssetEntry getEntry(Document document) throws PortalException, SystemException {
        String portletId = GetterUtil.getString((String)document.get("portletId"));
        if (portletId.equals("33")) {
            long entryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            long classNameId = PortalUtil.getClassNameId((String)BlogsEntry.class.getName());
            long classPK = entryId;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("28")) {
            long entryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            long classNameId = PortalUtil.getClassNameId((String)BookmarksEntry.class.getName());
            long classPK = entryId;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("20")) {
            long fileEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            long classNameId = PortalUtil.getClassNameId((String)DLFileEntry.class.getName());
            long classPK = fileEntryId;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("15")) {
            long groupId = GetterUtil.getLong((String)document.get("groupId"));
            String articleId = document.get("articleId");
            long articleResourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, articleId);
            long classNameId = PortalUtil.getClassNameId((String)JournalArticle.class.getName());
            long classPK = articleResourcePrimKey;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("19")) {
            long messageId = GetterUtil.getLong((String)document.get("entryClassPK"));
            long classNameId = PortalUtil.getClassNameId((String)MBMessage.class.getName());
            long classPK = messageId;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        if (portletId.equals("36")) {
            long nodeId = GetterUtil.getLong((String)document.get("entryClassPK"));
            String title = document.get("title");
            long pageResourcePrimKey = this.wikiPageResourceLocalService.getPageResourcePrimKey(nodeId, title);
            long classNameId = PortalUtil.getClassNameId((String)WikiPage.class.getName());
            long classPK = pageResourcePrimKey;
            return this.assetEntryPersistence.findByC_C(classNameId, classPK);
        }
        return null;
    }

    protected void updateVisible(AssetEntry entry, boolean visible) throws PortalException, SystemException {
        if (visible == entry.isVisible()) {
            return;
        }
        List tags = this.assetEntryPersistence.getAssetTags(entry.getEntryId());
        if (visible) {
            for (AssetTag tag : tags) {
                this.assetTagLocalService.incrementAssetCount(tag.getTagId(), entry.getClassNameId());
            }
        } else {
            for (AssetTag tag : tags) {
                this.assetTagLocalService.decrementAssetCount(tag.getTagId(), entry.getClassNameId());
            }
        }
        entry.setVisible(visible);
    }
}

