/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetVocabularyLocalServiceUtil;
import com.liferay.portlet.asset.util.AssetEntryValidator;
import java.util.List;

public class BaseAssetEntryValidator
implements AssetEntryValidator {
    public void validate(long groupId, String className, long[] categoryIds, String[] entryNames) throws PortalException, SystemException {
        List vocabularies = AssetVocabularyLocalServiceUtil.getGroupVocabularies((long)groupId, (boolean)false);
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (!group.isCompany()) {
            try {
                Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)group.getCompanyId());
                vocabularies = ListUtil.copy((List)vocabularies);
                vocabularies.addAll(AssetVocabularyLocalServiceUtil.getGroupVocabularies((long)companyGroup.getGroupId()));
            }
            catch (NoSuchGroupException noSuchGroupException) {}
        }
        long classNameId = ClassNameLocalServiceUtil.getClassNameId((String)className);
        for (AssetVocabulary vocabulary : vocabularies) {
            this.validate(classNameId, categoryIds, vocabulary);
        }
    }

    protected void validate(long classNameId, long[] categoryIds, AssetVocabulary vocabulary) throws PortalException, SystemException {
        UnicodeProperties settingsProperties = vocabulary.getSettingsProperties();
        long[] selectedClassNameIds = StringUtil.split((String)settingsProperties.getProperty("selectedClassNameIds"), (long)0L);
        if (selectedClassNameIds.length == 0) {
            return;
        }
        if (selectedClassNameIds[0] != 0L && !ArrayUtil.contains((long[])selectedClassNameIds, (long)classNameId)) {
            return;
        }
        String className = PortalUtil.getClassName((long)classNameId);
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null || !assetRendererFactory.isCategorizable()) {
            return;
        }
        long[] requiredClassNameIds = StringUtil.split((String)settingsProperties.getProperty("requiredClassNameIds"), (long)0L);
        List categories = AssetCategoryLocalServiceUtil.getVocabularyCategories((long)vocabulary.getVocabularyId(), (int)-1, (int)-1, null);
        if (requiredClassNameIds.length > 0 && (requiredClassNameIds[0] == 0L || ArrayUtil.contains((long[])requiredClassNameIds, (long)classNameId))) {
            boolean found = false;
            for (AssetCategory category : categories) {
                if (!ArrayUtil.contains((long[])categoryIds, (long)category.getCategoryId())) continue;
                found = true;
                break;
            }
            if (!found && !categories.isEmpty()) {
                throw new AssetCategoryException(vocabulary, 1);
            }
        }
        if (!vocabulary.isMultiValued()) {
            boolean duplicate = false;
            for (AssetCategory category : categories) {
                if (!ArrayUtil.contains((long[])categoryIds, (long)category.getCategoryId())) continue;
                if (!duplicate) {
                    duplicate = true;
                    continue;
                }
                throw new AssetCategoryException(vocabulary, 2);
            }
        }
    }
}

