/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.action;

import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

public class ConfigurationActionImpl
extends DefaultConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        PortletPreferences preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
        if (cmd.equals("update")) {
            this.updateDisplaySettings(actionRequest);
            String selectionStyle = this.getParameter((PortletRequest)actionRequest, "selectionStyle");
            if (selectionStyle.equals("dynamic")) {
                this.updateQueryLogic(actionRequest, preferences);
            }
            this.updateDefaultAssetPublisher(actionRequest);
            super.processAction(portletConfig, actionRequest, actionResponse);
        } else {
            try {
                String redirect;
                if (cmd.equals("add-selection")) {
                    AssetPublisherUtil.addSelection((PortletRequest)actionRequest, preferences);
                } else if (cmd.equals("move-selection-down")) {
                    this.moveSelectionDown(actionRequest, preferences);
                } else if (cmd.equals("move-selection-up")) {
                    this.moveSelectionUp(actionRequest, preferences);
                } else if (cmd.equals("remove-selection")) {
                    this.removeSelection(actionRequest, preferences);
                } else if (cmd.equals("select-scope")) {
                    this.setScopes(actionRequest, preferences);
                } else if (cmd.equals("selection-style")) {
                    this.setSelectionStyle(actionRequest, preferences);
                }
                if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                    preferences.store();
                    LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
                    SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".refreshPortlet"), (Object)portletResource);
                    SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(liferayPortletConfig.getPortletId()) + ".updatedConfiguration"));
                }
                if (Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"))))) {
                    actionResponse.sendRedirect(redirect);
                }
            }
            catch (Exception e2) {
                if (e2 instanceof AssetTagException) {
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
                }
                throw e2;
            }
        }
    }

    protected String[] getClassTypeIds(ActionRequest actionRequest, String[] classNameIds) throws Exception {
        long[] groupIds;
        String anyAssetTypeString = this.getParameter((PortletRequest)actionRequest, "anyAssetType");
        boolean anyAssetType = GetterUtil.getBoolean((String)anyAssetTypeString);
        if (anyAssetType) {
            return null;
        }
        long defaultAssetTypeId = GetterUtil.getLong((String)anyAssetTypeString);
        if (defaultAssetTypeId == 0L && classNameIds.length == 1) {
            defaultAssetTypeId = GetterUtil.getLong((String)classNameIds[0]);
        }
        if (defaultAssetTypeId <= 0L) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String className = PortalUtil.getClassName((long)defaultAssetTypeId);
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory.getClassTypes(groupIds = new long[]{themeDisplay.getCompanyGroupId(), themeDisplay.getScopeGroupId()}, themeDisplay.getLocale()) == null) {
            return null;
        }
        String assetClassName = AssetPublisherUtil.getClassName(assetRendererFactory);
        String anyAssetClassTypeString = this.getParameter((PortletRequest)actionRequest, "anyClassType" + assetClassName);
        boolean anyAssetClassType = GetterUtil.getBoolean((String)anyAssetClassTypeString);
        if (anyAssetClassType) {
            return null;
        }
        long defaultAssetClassTypeId = GetterUtil.getLong((String)anyAssetClassTypeString);
        if (defaultAssetClassTypeId > 0L) {
            return new String[]{String.valueOf(defaultAssetClassTypeId)};
        }
        return StringUtil.split((String)this.getParameter((PortletRequest)actionRequest, "classTypeIds" + assetClassName));
    }

    protected void moveSelectionDown(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        if (assetEntryOrder >= (manualEntries = preferences.getValues("assetEntryXml", new String[0])).length - 1 || assetEntryOrder < 0) {
            return;
        }
        String temp = manualEntries[assetEntryOrder + 1];
        manualEntries[assetEntryOrder + 1] = manualEntries[assetEntryOrder];
        manualEntries[assetEntryOrder] = temp;
        preferences.setValues("assetEntryXml", manualEntries);
    }

    protected void moveSelectionUp(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        if (assetEntryOrder >= (manualEntries = preferences.getValues("assetEntryXml", new String[0])).length || assetEntryOrder <= 0) {
            return;
        }
        String temp = manualEntries[assetEntryOrder - 1];
        manualEntries[assetEntryOrder - 1] = manualEntries[assetEntryOrder];
        manualEntries[assetEntryOrder] = temp;
        preferences.setValues("assetEntryXml", manualEntries);
    }

    protected void removeSelection(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String[] manualEntries;
        int assetEntryOrder = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"assetEntryOrder");
        if (assetEntryOrder >= (manualEntries = preferences.getValues("assetEntryXml", new String[0])).length) {
            return;
        }
        String[] newEntries = new String[manualEntries.length - 1];
        int i2 = 0;
        int j = 0;
        while (i2 < manualEntries.length) {
            if (i2 != assetEntryOrder) {
                newEntries[j++] = manualEntries[i2];
            }
            ++i2;
        }
        preferences.setValues("assetEntryXml", newEntries);
    }

    protected void setScopes(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String defaultScope = this.getParameter((PortletRequest)actionRequest, "defaultScope");
        String[] scopeIds = StringUtil.split((String)this.getParameter((PortletRequest)actionRequest, "scopeIds"));
        preferences.setValue("defaultScope", defaultScope);
        preferences.setValues("scopeIds", scopeIds);
    }

    protected void setSelectionStyle(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String selectionStyle = this.getParameter((PortletRequest)actionRequest, "selectionStyle");
        String displayStyle = this.getParameter((PortletRequest)actionRequest, "displayStyle");
        preferences.setValue("selectionStyle", selectionStyle);
        if (selectionStyle.equals("manual") || selectionStyle.equals("view-count")) {
            preferences.setValue("enableRss", String.valueOf(false));
            preferences.setValue("showQueryLogic", Boolean.FALSE.toString());
            preferences.reset("rssDelta");
            preferences.reset("rssDisplayStyle");
            preferences.reset("rssFormat");
            preferences.reset("rssName");
        }
        if (!selectionStyle.equals("view-count") && displayStyle.equals("view-count-details")) {
            preferences.setValue("displayStyle", "full-content");
        }
    }

    protected void updateDefaultAssetPublisher(ActionRequest actionRequest) throws Exception {
        boolean defaultAssetPublisher = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"defaultAssetPublisher");
        Layout layout = (Layout)actionRequest.getAttribute("LAYOUT");
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        if (defaultAssetPublisher) {
            typeSettingsProperties.setProperty("default-asset-publisher-portlet-id", portletResource);
        } else {
            String defaultAssetPublisherPortletId = typeSettingsProperties.getProperty("default-asset-publisher-portlet-id");
            if (Validator.isNotNull((String)defaultAssetPublisherPortletId) && defaultAssetPublisherPortletId.equals(portletResource)) {
                typeSettingsProperties.setProperty("default-asset-publisher-portlet-id", "");
            }
        }
        layout = LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
    }

    protected void updateDisplaySettings(ActionRequest actionRequest) throws Exception {
        String[] classNameIds = StringUtil.split((String)this.getParameter((PortletRequest)actionRequest, "classNameIds"));
        String[] classTypeIds = this.getClassTypeIds(actionRequest, classNameIds);
        String[] extensions = actionRequest.getParameterValues("extensions");
        String[] scopeIds = StringUtil.split((String)this.getParameter((PortletRequest)actionRequest, "scopeIds"));
        this.setPreference((PortletRequest)actionRequest, "classNameIds", classNameIds);
        this.setPreference((PortletRequest)actionRequest, "classTypeIds", classTypeIds);
        this.setPreference((PortletRequest)actionRequest, "extensions", extensions);
        this.setPreference((PortletRequest)actionRequest, "scopeIds", scopeIds);
    }

    protected void updateQueryLogic(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long userId = themeDisplay.getUserId();
        long groupId = themeDisplay.getScopeGroupId();
        int[] queryRulesIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"queryLogicIndexes"), (int)0);
        int i2 = 0;
        int[] nArray = queryRulesIndexes;
        int n = queryRulesIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int queryRulesIndex = nArray[n2];
            boolean contains = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("queryContains" + queryRulesIndex));
            boolean andOperator = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("queryAndOperator" + queryRulesIndex));
            String name = ParamUtil.getString((PortletRequest)actionRequest, (String)("queryName" + queryRulesIndex));
            String[] values = null;
            if (name.equals("assetTags")) {
                values = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("queryTagNames" + queryRulesIndex)));
                AssetTagLocalServiceUtil.checkTags((long)userId, (long)groupId, (String[])values);
            } else {
                values = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("queryCategoryIds" + queryRulesIndex)));
            }
            this.setPreference((PortletRequest)actionRequest, "queryContains" + i2, String.valueOf(contains));
            this.setPreference((PortletRequest)actionRequest, "queryAndOperator" + i2, String.valueOf(andOperator));
            this.setPreference((PortletRequest)actionRequest, "queryName" + i2, name);
            this.setPreference((PortletRequest)actionRequest, "queryValues" + i2, values);
            ++i2;
            ++n2;
        }
        String[] values = preferences.getValues("queryValues" + i2, new String[0]);
        while (values.length > 0) {
            this.setPreference((PortletRequest)actionRequest, "queryContains" + i2, "");
            this.setPreference((PortletRequest)actionRequest, "queryAndOperator" + i2, "");
            this.setPreference((PortletRequest)actionRequest, "queryName" + i2, "");
            this.setPreference((PortletRequest)actionRequest, "queryValues" + i2, new String[0]);
            values = preferences.getValues("queryValues" + ++i2, new String[0]);
        }
    }
}

