/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetpublisher.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetRendererFactoryRegistryUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.service.AssetEntryServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSAction
extends PortletAction {
    @Override
    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        resourceResponse.setContentType("text/xml; charset=UTF-8");
        OutputStream outputStream = resourceResponse.getPortletOutputStream();
        try {
            byte[] bytes = this.getRSS((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
            outputStream.write(bytes);
        }
        finally {
            outputStream.close();
        }
    }

    protected String exportToRSS(PortletRequest portletRequest, PortletResponse portletResponse, String name, String description, String type, double version, String displayStyle, String linkBehavior, List<AssetEntry> assetEntries) throws Exception {
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        syndFeed.setTitle(name);
        syndFeed.setLink(this.getFeedURL(portletRequest));
        syndFeed.setDescription(GetterUtil.getString((String)description, (String)name));
        ArrayList<SyndEntryImpl> syndEntries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(syndEntries);
        for (AssetEntry assetEntry : assetEntries) {
            String link = this.getEntryURL(portletRequest, portletResponse, linkBehavior, assetEntry);
            String author = HtmlUtil.escape((String)PortalUtil.getUserName((long)assetEntry.getUserId(), (String)assetEntry.getUserName()));
            String value = null;
            String languageId = LanguageUtil.getLanguageId((PortletRequest)portletRequest);
            value = displayStyle.equals("title") ? "" : assetEntry.getSummary(languageId, true);
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            syndEntry.setAuthor(author);
            syndEntry.setTitle(assetEntry.getTitle(languageId, true));
            syndEntry.setLink(link);
            syndEntry.setUri(syndEntry.getLink());
            syndEntry.setPublishedDate(assetEntry.getCreateDate());
            syndEntry.setUpdatedDate(assetEntry.getModifiedDate());
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType("html");
            syndContent.setValue(value);
            syndEntry.setDescription((SyndContent)syndContent);
            syndEntries.add(syndEntry);
        }
        return RSSUtil.export((SyndFeed)syndFeed);
    }

    protected List<AssetEntry> getAssetEntries(PortletRequest portletRequest, PortletPreferences preferences) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        AssetEntryQuery assetEntryQuery = AssetPublisherUtil.getAssetEntryQuery(preferences, new long[]{themeDisplay.getScopeGroupId()});
        boolean anyAssetType = GetterUtil.getBoolean((String)preferences.getValue("anyAssetType", null), (boolean)true);
        if (!anyAssetType) {
            long[] availableClassNameIds = AssetRendererFactoryRegistryUtil.getClassNameIds();
            long[] classNameIds = AssetPublisherUtil.getClassNameIds(preferences, availableClassNameIds);
            assetEntryQuery.setClassNameIds(classNameIds);
        }
        long[] classTypeIds = GetterUtil.getLongValues((String[])preferences.getValues("classTypeIds", null));
        assetEntryQuery.setClassTypeIds(classTypeIds);
        boolean enablePermissions = GetterUtil.getBoolean((String)preferences.getValue("enablePermissions", null));
        assetEntryQuery.setEnablePermissions(enablePermissions);
        int rssDelta = GetterUtil.getInteger((String)preferences.getValue("rssDelta", "20"));
        assetEntryQuery.setEnd(rssDelta);
        boolean excludeZeroViewCount = GetterUtil.getBoolean((String)preferences.getValue("excludeZeroViewCount", null));
        assetEntryQuery.setExcludeZeroViewCount(excludeZeroViewCount);
        long[] groupIds = AssetPublisherUtil.getGroupIds(preferences, themeDisplay.getScopeGroupId(), themeDisplay.getLayout());
        assetEntryQuery.setGroupIds(groupIds);
        boolean showOnlyLayoutAssets = GetterUtil.getBoolean((String)preferences.getValue("showOnlyLayoutAssets", null));
        if (showOnlyLayoutAssets) {
            assetEntryQuery.setLayout(themeDisplay.getLayout());
        }
        String orderByColumn1 = GetterUtil.getString((String)preferences.getValue("orderByColumn1", "modifiedDate"));
        assetEntryQuery.setOrderByCol1(orderByColumn1);
        String orderByColumn2 = GetterUtil.getString((String)preferences.getValue("orderByColumn2", "title"));
        assetEntryQuery.setOrderByCol2(orderByColumn2);
        String orderByType1 = GetterUtil.getString((String)preferences.getValue("orderByType1", "DESC"));
        assetEntryQuery.setOrderByType1(orderByType1);
        String orderByType2 = GetterUtil.getString((String)preferences.getValue("orderByType2", "ASC"));
        assetEntryQuery.setOrderByType2(orderByType2);
        assetEntryQuery.setStart(0);
        return AssetEntryServiceUtil.getEntries((AssetEntryQuery)assetEntryQuery);
    }

    protected String getAssetPublisherURL(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        StringBundler sb = new StringBundler(7);
        String layoutFriendlyURL = GetterUtil.getString((String)PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay));
        if (!layoutFriendlyURL.startsWith("http://") && !layoutFriendlyURL.startsWith("https://")) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(layoutFriendlyURL);
        sb.append("/-/");
        sb.append("asset_publisher/");
        sb.append(portletDisplay.getInstanceId());
        sb.append("/");
        return sb.toString();
    }

    protected String getEntryURL(PortletRequest portletRequest, PortletResponse portletResponse, String linkBehavior, AssetEntry assetEntry) throws Exception {
        if (linkBehavior.equals("viewInPortlet")) {
            return this.getEntryURLViewInContext(portletRequest, portletResponse, assetEntry);
        }
        return this.getEntryURLAssetPublisher(portletRequest, portletResponse, assetEntry);
    }

    protected String getEntryURLAssetPublisher(PortletRequest portletRequest, PortletResponse portletResponse, AssetEntry assetEntry) throws Exception {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
        StringBundler sb = new StringBundler(4);
        sb.append(this.getAssetPublisherURL(portletRequest));
        sb.append(assetRendererFactory.getType());
        sb.append("/id/");
        sb.append(assetEntry.getEntryId());
        return sb.toString();
    }

    protected String getEntryURLViewInContext(PortletRequest portletRequest, PortletResponse portletResponse, AssetEntry assetEntry) throws Exception {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK());
        String viewInContextURL = assetRenderer.getURLViewInContext((LiferayPortletRequest)portletRequest, (LiferayPortletResponse)portletResponse, null);
        if (Validator.isNotNull((String)viewInContextURL) && !viewInContextURL.startsWith("http://") && !viewInContextURL.startsWith("https://")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("THEME_DISPLAY");
            viewInContextURL = String.valueOf(themeDisplay.getPortalURL()) + viewInContextURL;
        }
        return viewInContextURL;
    }

    protected String getFeedURL(PortletRequest portletRequest) throws Exception {
        String feedURL = this.getAssetPublisherURL(portletRequest);
        return feedURL.concat("rss");
    }

    protected byte[] getRSS(PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        PortletPreferences preferences = portletRequest.getPreferences();
        String selectionStyle = preferences.getValue("selectionStyle", "dynamic");
        if (!selectionStyle.equals("dynamic")) {
            return new byte[0];
        }
        String rssName = preferences.getValue("rssName", null);
        String rssFormat = preferences.getValue("rssFormat", "atom10");
        String rssDisplayStyle = preferences.getValue("rssDisplayStyle", "abstract");
        String assetLinkBehavior = preferences.getValue("assetLinkBehavior", "showFullContent");
        String rss = this.exportToRSS(portletRequest, portletResponse, rssName, null, RSSUtil.getFormatType((String)rssFormat), RSSUtil.getFormatVersion((String)rssFormat), rssDisplayStyle, assetLinkBehavior, this.getAssetEntries(portletRequest, preferences));
        return rss.getBytes("UTF-8");
    }
}

