/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.blogs.EntryContentException;
import com.liferay.portlet.blogs.EntryDisplayDateException;
import com.liferay.portlet.blogs.EntrySmallImageNameException;
import com.liferay.portlet.blogs.EntrySmallImageSizeException;
import com.liferay.portlet.blogs.EntryTitleException;
import com.liferay.portlet.blogs.NoSuchEntryException;
import com.liferay.portlet.blogs.action.ActionUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.BlogsEntryServiceUtil;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            BlogsEntry entry = null;
            String oldUrlTitle = "";
            if (cmd.equals("add") || cmd.equals("update")) {
                Object[] returnValue = this.updateEntry(actionRequest);
                entry = (BlogsEntry)returnValue[0];
                oldUrlTitle = (String)returnValue[1];
            } else if (cmd.equals("delete")) {
                this.deleteEntries(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribe(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribe(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            boolean updateRedirect = false;
            if (redirect.contains("/blogs/" + oldUrlTitle + "/maximized")) {
                oldUrlTitle = String.valueOf(oldUrlTitle) + "/maximized";
            }
            if (entry != null && Validator.isNotNull((String)oldUrlTitle) && (redirect.endsWith("/blogs/" + oldUrlTitle) || redirect.contains("/blogs/" + oldUrlTitle + "?") || redirect.contains("/blog/" + oldUrlTitle + "?"))) {
                int pos = redirect.indexOf("?");
                if (pos == -1) {
                    pos = redirect.length();
                }
                String newRedirect = redirect.substring(0, pos - oldUrlTitle.length());
                newRedirect = String.valueOf(newRedirect) + entry.getUrlTitle();
                if (oldUrlTitle.indexOf("/maximized") != -1) {
                    newRedirect = String.valueOf(newRedirect) + "/maximized";
                }
                if (pos < redirect.length()) {
                    newRedirect = String.valueOf(newRedirect) + "?" + redirect.substring(pos + 1);
                }
                redirect = newRedirect;
                updateRedirect = true;
            }
            int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)2);
            boolean ajax = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"ajax");
            if (ajax) {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.put("entryId", entry.getEntryId());
                jsonObject.put("redirect", redirect);
                jsonObject.put("updateRedirect", updateRedirect);
                this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
                return;
            }
            if (entry != null && workflowAction == 2) {
                redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, entry, redirect);
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else {
                WindowState windowState = actionRequest.getWindowState();
                if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                } else if (Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)redirect)))) {
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchEntryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.blogs.error");
            }
            if (e2 instanceof EntryContentException || e2 instanceof EntryDisplayDateException || e2 instanceof EntrySmallImageNameException || e2 instanceof EntrySmallImageSizeException || e2 instanceof EntryTitleException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof AssetCategoryException || e2 instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            throw e2;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            BlogsEntry entry;
            ActionUtil.getEntry((PortletRequest)renderRequest);
            if (PropsValues.BLOGS_PINGBACK_ENABLED && (entry = (BlogsEntry)renderRequest.getAttribute("BLOGS_ENTRY")) != null && entry.isAllowPingbacks()) {
                HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)renderResponse);
                response.addHeader("X-Pingback", String.valueOf(PortalUtil.getPortalURL((PortletRequest)renderRequest)) + "/xmlrpc/pingback");
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchEntryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.blogs.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.blogs.edit_entry"));
    }

    protected void deleteEntries(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        if (entryId > 0L) {
            BlogsEntryServiceUtil.deleteEntry((long)entryId);
        } else {
            long[] deleteEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteEntryIds"), (long)0L);
            int i2 = 0;
            while (i2 < deleteEntryIds.length) {
                BlogsEntryServiceUtil.deleteEntry((long)deleteEntryIds[i2]);
                ++i2;
            }
        }
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, BlogsEntry entry, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String backURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"backURL");
        boolean preview = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"preview");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setWindowState(actionRequest.getWindowState());
        String portletName = portletConfig.getPortletName();
        if (portletName.equals("161")) {
            portletURL.setParameter("struts_action", "/blogs_admin/edit_entry");
        } else {
            portletURL.setParameter("struts_action", "/blogs/edit_entry");
        }
        portletURL.setParameter("cmd", "update", false);
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("backURL", backURL, false);
        portletURL.setParameter("groupId", String.valueOf(entry.getGroupId()), false);
        portletURL.setParameter("entryId", String.valueOf(entry.getEntryId()), false);
        portletURL.setParameter("preview", String.valueOf(preview), false);
        return portletURL.toString();
    }

    protected void subscribe(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        BlogsEntryServiceUtil.subscribe((long)themeDisplay.getScopeGroupId());
    }

    protected void unsubscribe(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        BlogsEntryServiceUtil.unsubscribe((long)themeDisplay.getScopeGroupId());
    }

    protected Object[] updateEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        int displayDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateMonth");
        int displayDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateDay");
        int displayDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateYear");
        int displayDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateHour");
        int displayDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateMinute");
        int displayDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateAmPm");
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        boolean allowPingbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowPingbacks");
        boolean allowTrackbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowTrackbacks");
        String[] trackbacks = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"trackbacks"));
        boolean smallImage = false;
        String smallImageURL = null;
        String smallImageFileName = null;
        InputStream smallImageInputStream = null;
        BlogsEntry entry = null;
        String oldUrlTitle = null;
        try {
            boolean ajax = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"ajax");
            if (!ajax) {
                boolean attachments;
                smallImage = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"smallImage");
                smallImageURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"smallImageURL");
                if (smallImage && Validator.isNull((String)smallImageURL) && (attachments = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"attachments"))) {
                    UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
                    smallImageFileName = uploadPortletRequest.getFileName("smallFile");
                    smallImageInputStream = uploadPortletRequest.getFileAsStream("smallFile");
                }
            }
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BlogsEntry.class.getName(), (PortletRequest)actionRequest);
            entry = null;
            oldUrlTitle = "";
            if (entryId <= 0L) {
                entry = BlogsEntryServiceUtil.addEntry((String)title, (String)description, (String)content, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (boolean)smallImage, (String)smallImageURL, (String)smallImageFileName, (InputStream)smallImageInputStream, (ServiceContext)serviceContext);
                AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, BlogsEntry.class.getName(), entry.getEntryId(), -1);
            } else {
                entry = BlogsEntryLocalServiceUtil.getEntry((long)entryId);
                String tempOldUrlTitle = entry.getUrlTitle();
                if (!tempOldUrlTitle.equals((entry = BlogsEntryServiceUtil.updateEntry((long)entryId, (String)title, (String)description, (String)content, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (boolean)smallImage, (String)smallImageURL, (String)smallImageFileName, (InputStream)smallImageInputStream, (ServiceContext)serviceContext)).getUrlTitle())) {
                    oldUrlTitle = tempOldUrlTitle;
                }
                AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, BlogsEntry.class.getName(), entry.getEntryId(), -1);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(smallImageInputStream);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)smallImageInputStream);
        return new Object[]{entry, oldUrlTitle};
    }
}

