/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.blogs.NoSuchEntryException;
import com.liferay.portlet.blogs.action.ActionUtil;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.util.LinkbackConsumerUtil;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class TrackbackAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;
    private static Log _log = LogFactoryUtil.getLog(TrackbackAction.class);

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.addTrackback(actionRequest, actionResponse);
        }
        catch (NoSuchEntryException nsee) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)nsee, (Throwable)nsee);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
    }

    protected void addTrackback(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String trackbackIp;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String excerpt = ParamUtil.getString((PortletRequest)actionRequest, (String)"excerpt");
        String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"url");
        String blogName = ParamUtil.getString((PortletRequest)actionRequest, (String)"blog_name");
        if (!this.isCommentsEnabled(actionRequest)) {
            this.sendError(actionRequest, actionResponse, "Comments have been disabled for this blog entry.");
            return;
        }
        if (Validator.isNull((String)url)) {
            this.sendError(actionRequest, actionResponse, "Trackback requires a valid permanent URL.");
            return;
        }
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        String remoteIp = request.getRemoteAddr();
        if (!remoteIp.equals(trackbackIp = HttpUtil.getIpAddress((String)url))) {
            this.sendError(actionRequest, actionResponse, "Remote IP " + remoteIp + " does not match trackback URL's IP " + trackbackIp + ".");
            return;
        }
        try {
            ActionUtil.getEntry((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            this.sendError(actionRequest, actionResponse, "Blog entry must have guest view permissions to enable trackbacks.");
            return;
        }
        BlogsEntry entry = (BlogsEntry)actionRequest.getAttribute("BLOGS_ENTRY");
        if (!entry.isAllowTrackbacks()) {
            this.sendError(actionRequest, actionResponse, "Trackbacks are not enabled on this blog entry.");
            return;
        }
        long userId = UserLocalServiceUtil.getDefaultUserId((long)themeDisplay.getCompanyId());
        long groupId = entry.getGroupId();
        String className = BlogsEntry.class.getName();
        long classPK = entry.getEntryId();
        MBMessageDisplay messageDisplay = MBMessageLocalServiceUtil.getDiscussionMessageDisplay((long)userId, (long)groupId, (String)className, (long)classPK, (int)0);
        MBThread thread = messageDisplay.getThread();
        long threadId = thread.getThreadId();
        long parentMessageId = thread.getRootMessageId();
        String body = "[...] " + excerpt + " [...] [url=" + url + "]" + themeDisplay.translate("read-more") + "[/url]";
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBMessage.class.getName(), (PortletRequest)actionRequest);
        MBMessage message = MBMessageLocalServiceUtil.addDiscussionMessage((long)userId, (String)blogName, (long)groupId, (String)className, (long)classPK, (long)threadId, (long)parentMessageId, (String)title, (String)body, (ServiceContext)serviceContext);
        String entryURL = String.valueOf(PortalUtil.getLayoutFullURL((ThemeDisplay)themeDisplay)) + "/-/" + "blogs/" + entry.getUrlTitle();
        LinkbackConsumerUtil.addNewTrackback(message.getMessageId(), url, entryURL);
        this.sendSuccess(actionRequest, actionResponse);
    }

    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected boolean isCommentsEnabled(ActionRequest actionRequest) throws Exception {
        PortletPreferences preferences = actionRequest.getPreferences();
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        if (Validator.isNotNull((String)portletResource)) {
            preferences = PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
        }
        return GetterUtil.getBoolean((String)preferences.getValue("enableComments", null), (boolean)true);
    }

    protected void sendError(ActionRequest actionRequest, ActionResponse actionResponse, String msg) throws Exception {
        this.sendResponse(actionRequest, actionResponse, msg, false);
    }

    protected void sendResponse(ActionRequest actionRequest, ActionResponse actionResponse, String msg, boolean success) throws Exception {
        StringBundler sb = new StringBundler(7);
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        sb.append("<response>");
        if (success) {
            sb.append("<error>0</error>");
        } else {
            sb.append("<error>1</error>");
            sb.append("<message>");
            sb.append(msg);
            sb.append("</message>");
        }
        sb.append("</response>");
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])sb.toString().getBytes("UTF-8"), (String)"text/xml; charset=UTF-8");
    }

    protected void sendSuccess(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.sendResponse(actionRequest, actionResponse, null, true);
    }
}

