/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.social;

import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;
import java.text.Format;
import java.util.Locale;
import java.util.TimeZone;

public class BlogsActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{BlogsEntry.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected SocialActivityFeedEntry doInterpret(SocialActivity activity, ThemeDisplay themeDisplay) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!BlogsEntryPermission.contains(permissionChecker, activity.getClassPK(), "VIEW")) {
            return null;
        }
        String groupName = "";
        if (activity.getGroupId() != themeDisplay.getScopeGroupId()) {
            groupName = this.getGroupName(activity.getGroupId(), themeDisplay);
        }
        String creatorUserName = this.getUserName(activity.getUserId(), themeDisplay);
        String receiverUserName = this.getUserName(activity.getReceiverUserId(), themeDisplay);
        int activityType = activity.getType();
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)activity.getClassPK());
        String link = String.valueOf(themeDisplay.getPortalURL()) + themeDisplay.getPathMain() + "/blogs/find_entry?entryId=" + activity.getClassPK();
        String entryTitle = this.getValue(activity.getExtraData(), "title", entry.getTitle());
        String displayTitle = this.wrapLink(link, entryTitle);
        String displayDate = "";
        String titlePattern = null;
        if (activityType == 1 || activityType == 10005) {
            titlePattern = Validator.isNull((String)groupName) ? "activity-blogs-add-comment" : "activity-blogs-add-comment-in";
        } else if (activityType == 2) {
            if (entry.getStatus() == 7) {
                titlePattern = Validator.isNull((String)groupName) ? "activity-blogs-scheduled-entry" : "activity-blogs-scheduled-entry-in";
                Format dateFormatDate = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"MMMM d", (Locale)themeDisplay.getLocale(), (TimeZone)themeDisplay.getTimeZone());
                displayDate = dateFormatDate.format(entry.getDisplayDate());
                displayTitle = entryTitle;
            } else {
                titlePattern = Validator.isNull((String)groupName) ? "activity-blogs-add-entry" : "activity-blogs-add-entry-in";
            }
        } else if (activityType == 3) {
            titlePattern = Validator.isNull((String)groupName) ? "activity-blogs-update-entry" : "activity-blogs-update-entry-in";
        }
        Object[] titleArguments = new Object[]{groupName, creatorUserName, receiverUserName, displayTitle, displayDate};
        String title = themeDisplay.translate(titlePattern, titleArguments);
        String body = "";
        return new SocialActivityFeedEntry(link, title, body);
    }
}

