/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionList;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryLocalServiceUtil;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class BlogsIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{BlogsEntry.class.getName()};
    public static final String PORTLET_ID = "33";
    private static final boolean _FILTER_SEARCH = true;
    private static final boolean _PERMISSION_AWARE = true;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long entryClassPK, String actionId) throws Exception {
        return BlogsEntryPermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public boolean isFilterSearch() {
        return true;
    }

    public boolean isPermissionAware() {
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)-1);
        if (status != -1) {
            contextQuery.addRequiredTerm("status", status);
        }
    }

    protected void addReindexCriteria(DynamicQuery dynamicQuery, long companyId) {
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        Property displayDateProperty = PropertyFactoryUtil.forName((String)"displayDate");
        dynamicQuery.add(displayDateProperty.lt((Object)new Date()));
        Property statusProperty = PropertyFactoryUtil.forName((String)"status");
        dynamicQuery.add(statusProperty.eq((Object)0));
    }

    protected void doDelete(Object obj) throws Exception {
        BlogsEntry entry = (BlogsEntry)obj;
        this.deleteDocument(entry.getCompanyId(), entry.getEntryId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        BlogsEntry entry = (BlogsEntry)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)entry);
        document.addText("content", HtmlUtil.extractText((String)entry.getContent()));
        document.addDate("modified", entry.getDisplayDate());
        document.addText("title", entry.getTitle());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String entryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/blogs/view_entry");
        portletURL.setParameter("entryId", entryId);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        BlogsEntry entry = (BlogsEntry)obj;
        if (!entry.isApproved()) {
            return;
        }
        Document document = this.getDocument(entry);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)entry.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BlogsEntry entry = BlogsEntryLocalServiceUtil.getEntry((long)classPK);
        this.doReindex(entry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexEntries(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEntries(long companyId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(BlogsEntry.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minEntryIdProjection = ProjectionFactoryUtil.min((String)"entryId");
        Projection maxEntryIdProjection = ProjectionFactoryUtil.max((String)"entryId");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minEntryIdProjection);
        projectionList.add(maxEntryIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, companyId);
        List results = BlogsEntryLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxEntryIds = (Object[])results.get(0);
        if (minAndMaxEntryIds[0] == null || minAndMaxEntryIds[1] == null) {
            return;
        }
        long minEntryId = (Long)minAndMaxEntryIds[0];
        long maxEntryId = (Long)minAndMaxEntryIds[1];
        long startEntryId = minEntryId;
        long endEntryId = startEntryId + 10000L;
        while (startEntryId <= maxEntryId) {
            this.reindexEntries(companyId, startEntryId, endEntryId);
            startEntryId = endEntryId;
            endEntryId += 10000L;
        }
    }

    protected void reindexEntries(long companyId, long startEntryId, long endEntryId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(BlogsEntry.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"entryId");
        dynamicQuery.add(property.ge((Object)startEntryId));
        dynamicQuery.add(property.lt((Object)endEntryId));
        this.addReindexCriteria(dynamicQuery, companyId);
        List entries = BlogsEntryLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>(entries.size());
        for (BlogsEntry entry : entries) {
            Document document = this.getDocument(entry);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }
}

