/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.util.ContentUtil;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogsUtil {
    private static final char[] _URL_TITLE_REPLACE_CHARS = new char[]{'.', '/'};

    public static Map<Locale, String> getEmailEntryAddedBodyMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailEntryAddedBody");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get("blogs.email.entry.added.body")));
        return map;
    }

    public static boolean getEmailEntryAddedEnabled(PortletPreferences preferences) {
        String emailEntryAddedEnabled = preferences.getValue("emailEntryAddedEnabled", "");
        if (Validator.isNotNull((String)emailEntryAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailEntryAddedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("blogs.email.entry.added.enabled"));
    }

    public static Map<Locale, String> getEmailEntryAddedSubjectMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailEntryAddedSubject");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get("blogs.email.entry.added.subject")));
        return map;
    }

    public static Map<Locale, String> getEmailEntryUpdatedBodyMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailEntryUpdatedBody");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get("blogs.email.entry.updated.body")));
        return map;
    }

    public static boolean getEmailEntryUpdatedEnabled(PortletPreferences preferences) {
        String emailEntryUpdatedEnabled = preferences.getValue("emailEntryUpdatedEnabled", "");
        if (Validator.isNotNull((String)emailEntryUpdatedEnabled)) {
            return GetterUtil.getBoolean((String)emailEntryUpdatedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("blogs.email.entry.updated.enabled"));
    }

    public static Map<Locale, String> getEmailEntryUpdatedSubjectMap(PortletPreferences preferences) {
        Locale defaultLocale;
        Map map = LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailEntryUpdatedSubject");
        String defaultValue = (String)map.get(defaultLocale = LocaleUtil.getDefault());
        if (Validator.isNotNull((String)defaultValue)) {
            return map;
        }
        map.put(defaultLocale, ContentUtil.get((String)PropsUtil.get("blogs.email.entry.updated.subject")));
        return map;
    }

    public static String getEmailFromAddress(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromAddress((PortletPreferences)preferences, (long)companyId, (String)PropsValues.BLOGS_EMAIL_FROM_ADDRESS);
    }

    public static String getEmailFromName(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromName((PortletPreferences)preferences, (long)companyId, (String)PropsValues.BLOGS_EMAIL_FROM_NAME);
    }

    public static String getUrlTitle(long entryId, String title) {
        if (title == null) {
            return String.valueOf(entryId);
        }
        title = Validator.isNull((String)(title = title.trim().toLowerCase())) || Validator.isNumber((String)title) || title.equals("rss") ? String.valueOf(entryId) : FriendlyURLNormalizerUtil.normalize((String)title, (char[])_URL_TITLE_REPLACE_CHARS);
        return ModelHintsUtil.trimString((String)BlogsEntry.class.getName(), (String)"urlTitle", (String)title);
    }
}

