/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.action;

import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.bookmarks.EntryURLException;
import com.liferay.portlet.bookmarks.NoSuchEntryException;
import com.liferay.portlet.bookmarks.NoSuchFolderException;
import com.liferay.portlet.bookmarks.action.ActionUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateEntry(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteEntry(actionRequest);
            }
            WindowState windowState = actionRequest.getWindowState();
            if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                this.sendRedirect(actionRequest, actionResponse);
            } else {
                String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                if (Validator.isNotNull((String)redirect)) {
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchEntryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.bookmarks.error");
            }
            if (e2 instanceof EntryURLException || e2 instanceof NoSuchFolderException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof AssetCategoryException || e2 instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            throw e2;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getEntry((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchEntryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.bookmarks.error");
            }
            throw e2;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.bookmarks.edit_entry"));
    }

    protected void deleteEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        BookmarksEntryServiceUtil.deleteEntry((long)entryId);
    }

    protected void updateEntry(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        long groupId = themeDisplay.getScopeGroupId();
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"url");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BookmarksEntry.class.getName(), (PortletRequest)actionRequest);
        if (entryId <= 0L) {
            BookmarksEntry entry = BookmarksEntryServiceUtil.addEntry((long)groupId, (long)folderId, (String)name, (String)url, (String)description, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, BookmarksEntry.class.getName(), entry.getEntryId(), -1);
        } else {
            BookmarksEntryServiceUtil.updateEntry((long)entryId, (long)groupId, (long)folderId, (String)name, (String)url, (String)description, (ServiceContext)serviceContext);
        }
        AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, BookmarksEntry.class.getName(), folderId);
    }
}

