/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksEntryUtil;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksFolderUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class BookmarksPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "bookmarks";
    private static final boolean _PUBLISH_TO_LIVE_BY_DEFAULT = true;
    private static PortletDataHandlerBoolean _foldersAndEntries = new PortletDataHandlerBoolean("bookmarks", "folders-and-entries", true, true);
    private static PortletDataHandlerControl[] _metadataControls = new PortletDataHandlerControl[]{new PortletDataHandlerBoolean("bookmarks", "categories"), new PortletDataHandlerBoolean("bookmarks", "ratings"), new PortletDataHandlerBoolean("bookmarks", "tags")};

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_foldersAndEntries};
    }

    public PortletDataHandlerControl[] getExportMetadataControls() {
        return new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(_NAMESPACE, _NAMESPACE, true, _metadataControls)};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_foldersAndEntries};
    }

    public PortletDataHandlerControl[] getImportMetadataControls() {
        return new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(_NAMESPACE, _NAMESPACE, true, _metadataControls)};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return true;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (!portletDataContext.addPrimaryKey(BookmarksPortletDataHandlerImpl.class, "deleteData")) {
            BookmarksFolderLocalServiceUtil.deleteFolders((long)portletDataContext.getScopeGroupId());
            BookmarksEntryLocalServiceUtil.deleteEntries((long)portletDataContext.getScopeGroupId(), (long)0L);
        }
        return null;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.bookmarks", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("bookmarks-data");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        Element foldersElement = rootElement.addElement("folders");
        Element entriesElement = rootElement.addElement("entries");
        List folders = BookmarksFolderUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
        for (BookmarksFolder folder : folders) {
            this.exportFolder(portletDataContext, foldersElement, entriesElement, folder);
        }
        List entries = BookmarksEntryUtil.findByG_F((long)portletDataContext.getScopeGroupId(), (long)0L);
        for (BookmarksEntry entry : entries) {
            this.exportEntry(portletDataContext, null, entriesElement, entry);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.bookmarks", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element foldersElement = rootElement.element("folders");
        for (Element folderElement : foldersElement.elements("folder")) {
            String path = folderElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            BookmarksFolder folder = (BookmarksFolder)portletDataContext.getZipEntryAsObject(path);
            this.importFolder(portletDataContext, path, folder);
        }
        Element entriesElement = rootElement.element("entries");
        for (Element entryElement : entriesElement.elements("entry")) {
            String path = entryElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            BookmarksEntry entry = (BookmarksEntry)portletDataContext.getZipEntryAsObject(path);
            this.importEntry(portletDataContext, entryElement, entry);
        }
        return null;
    }

    protected void exportEntry(PortletDataContext portletDataContext, Element foldersElement, Element entriesElement, BookmarksEntry entry) throws Exception {
        String path;
        if (!portletDataContext.isWithinDateRange(entry.getModifiedDate())) {
            return;
        }
        if (foldersElement != null) {
            this.exportParentFolder(portletDataContext, foldersElement, entry.getFolderId());
        }
        if (portletDataContext.isPathNotProcessed(path = this.getEntryPath(portletDataContext, entry))) {
            Element entryElement = entriesElement.addElement("entry");
            portletDataContext.addClassedModel(entryElement, path, (ClassedModel)entry, _NAMESPACE);
        }
    }

    protected void exportFolder(PortletDataContext portletDataContext, Element foldersElement, Element entriesElement, BookmarksFolder folder) throws Exception {
        if (portletDataContext.isWithinDateRange(folder.getModifiedDate())) {
            this.exportParentFolder(portletDataContext, foldersElement, folder.getParentFolderId());
            String path = this.getFolderPath(portletDataContext, folder);
            if (portletDataContext.isPathNotProcessed(path)) {
                Element folderElement = foldersElement.addElement("folder");
                portletDataContext.addClassedModel(folderElement, path, (ClassedModel)folder, _NAMESPACE);
            }
        }
        List entries = BookmarksEntryUtil.findByG_F((long)folder.getGroupId(), (long)folder.getFolderId());
        for (BookmarksEntry entry : entries) {
            this.exportEntry(portletDataContext, foldersElement, entriesElement, entry);
        }
    }

    protected void exportParentFolder(PortletDataContext portletDataContext, Element foldersElement, long folderId) throws Exception {
        if (folderId == 0L) {
            return;
        }
        BookmarksFolder folder = BookmarksFolderUtil.findByPrimaryKey((long)folderId);
        this.exportParentFolder(portletDataContext, foldersElement, folder.getParentFolderId());
        String path = this.getFolderPath(portletDataContext, folder);
        if (portletDataContext.isPathNotProcessed(path)) {
            Element folderElement = foldersElement.addElement("folder");
            portletDataContext.addClassedModel(folderElement, path, (ClassedModel)folder, _NAMESPACE);
        }
    }

    protected String getEntryPath(PortletDataContext portletDataContext, BookmarksEntry entry) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("28"));
        sb.append("/entries/");
        sb.append(entry.getEntryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getFolderPath(PortletDataContext portletDataContext, BookmarksFolder folder) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("28"));
        sb.append("/folders/");
        sb.append(folder.getFolderId());
        sb.append(".xml");
        return sb.toString();
    }

    protected String getImportFolderPath(PortletDataContext portletDataContext, long folderId) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getSourcePortletPath("28"));
        sb.append("/folders/");
        sb.append(folderId);
        sb.append(".xml");
        return sb.toString();
    }

    protected void importEntry(PortletDataContext portletDataContext, Element entryElement, BookmarksEntry entry) throws Exception {
        long userId = portletDataContext.getUserId(entry.getUserUuid());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(BookmarksFolder.class);
        long folderId = MapUtil.getLong((Map)folderIds, (long)entry.getFolderId(), (long)entry.getFolderId());
        if (folderId != 0L && folderId == entry.getFolderId()) {
            String path = this.getImportFolderPath(portletDataContext, folderId);
            BookmarksFolder folder = (BookmarksFolder)portletDataContext.getZipEntryAsObject(path);
            this.importFolder(portletDataContext, path, folder);
            folderId = MapUtil.getLong((Map)folderIds, (long)entry.getFolderId(), (long)entry.getFolderId());
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext(entryElement, (ClassedModel)entry, _NAMESPACE);
        BookmarksEntry importedEntry = null;
        if (portletDataContext.isDataStrategyMirror()) {
            BookmarksEntry existingEntry = BookmarksEntryUtil.fetchByUUID_G((String)entry.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingEntry == null) {
                serviceContext.setUuid(entry.getUuid());
                importedEntry = BookmarksEntryLocalServiceUtil.addEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)entry.getName(), (String)entry.getUrl(), (String)entry.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedEntry = BookmarksEntryLocalServiceUtil.updateEntry((long)userId, (long)existingEntry.getEntryId(), (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)entry.getName(), (String)entry.getUrl(), (String)entry.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            importedEntry = BookmarksEntryLocalServiceUtil.addEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)entry.getName(), (String)entry.getUrl(), (String)entry.getDescription(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)entry, (ClassedModel)importedEntry, _NAMESPACE);
    }

    protected void importFolder(PortletDataContext portletDataContext, String folderPath, BookmarksFolder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(BookmarksFolder.class);
        long parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        if (parentFolderId != 0L && parentFolderId == folder.getParentFolderId()) {
            String path = this.getImportFolderPath(portletDataContext, parentFolderId);
            BookmarksFolder parentFolder = (BookmarksFolder)portletDataContext.getZipEntryAsObject(path);
            this.importFolder(portletDataContext, path, parentFolder);
            parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext(folderPath, (ClassedModel)folder, _NAMESPACE);
        BookmarksFolder importedFolder = null;
        if (portletDataContext.isDataStrategyMirror()) {
            BookmarksFolder existingFolder = BookmarksFolderUtil.fetchByUUID_G((String)folder.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingFolder == null) {
                serviceContext.setUuid(folder.getUuid());
                importedFolder = BookmarksFolderLocalServiceUtil.addFolder((long)userId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedFolder = BookmarksFolderLocalServiceUtil.updateFolder((long)existingFolder.getFolderId(), (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (boolean)false, (ServiceContext)serviceContext);
            }
        } else {
            importedFolder = BookmarksFolderLocalServiceUtil.addFolder((long)userId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder, _NAMESPACE);
    }
}

