/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.base.BookmarksFolderServiceBaseImpl;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarksFolderServiceImpl
extends BookmarksFolderServiceBaseImpl {
    public BookmarksFolder addFolder(long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolderPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentFolderId, "ADD_FOLDER");
        return this.bookmarksFolderLocalService.addFolder(this.getUserId(), parentFolderId, name, description, serviceContext);
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        BookmarksFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        this.bookmarksFolderLocalService.deleteFolder(folderId);
    }

    public BookmarksFolder getFolder(long folderId) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        BookmarksFolderPermission.check(this.getPermissionChecker(), folder, "VIEW");
        return folder;
    }

    public List<BookmarksFolder> getFolders(long groupId) throws SystemException {
        return this.bookmarksFolderPersistence.filterFindByGroupId(groupId);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.bookmarksFolderPersistence.filterFindByG_P(groupId, parentFolderId);
    }

    public List<BookmarksFolder> getFolders(long groupId, long parentFolderId, int start, int end) throws SystemException {
        return this.bookmarksFolderPersistence.filterFindByG_P(groupId, parentFolderId, start, end);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.bookmarksFolderPersistence.filterCountByG_P(groupId, parentFolderId);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List folders = this.bookmarksFolderPersistence.filterFindByG_P(groupId, folderId);
        for (BookmarksFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    public BookmarksFolder updateFolder(long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksFolder folder = this.bookmarksFolderLocalService.getFolder(folderId);
        BookmarksFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        return this.bookmarksFolderLocalService.updateFolder(folderId, parentFolderId, name, description, mergeWithParentFolder, serviceContext);
    }
}

