/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.social;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityFeedEntry;

public class BookmarksActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{BookmarksEntry.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected SocialActivityFeedEntry doInterpret(SocialActivity activity, ThemeDisplay themeDisplay) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!BookmarksEntryPermission.contains(permissionChecker, activity.getClassPK(), "VIEW")) {
            return null;
        }
        String groupName = "";
        if (activity.getGroupId() != themeDisplay.getScopeGroupId()) {
            groupName = this.getGroupName(activity.getGroupId(), themeDisplay);
        }
        String creatorUserName = this.getUserName(activity.getUserId(), themeDisplay);
        String receiverUserName = this.getUserName(activity.getReceiverUserId(), themeDisplay);
        int activityType = activity.getType();
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)activity.getClassPK());
        String link = String.valueOf(themeDisplay.getPortalURL()) + themeDisplay.getPathMain() + "/bookmarks/find_entry?entryId=" + activity.getClassPK();
        String titlePattern = null;
        if (activityType == 1) {
            titlePattern = "activity-bookmarks-add-entry";
        } else if (activityType == 2) {
            titlePattern = "activity-bookmarks-update-entry";
        }
        if (Validator.isNotNull((String)groupName)) {
            titlePattern = String.valueOf(titlePattern) + "-in";
        }
        String entryTitle = this.getValue(activity.getExtraData(), "title", entry.getName());
        Object[] titleArguments = new Object[]{groupName, creatorUserName, receiverUserName, this.wrapLink(link, entryTitle)};
        String title = themeDisplay.translate(titlePattern, titleArguments);
        String body = "";
        return new SocialActivityFeedEntry(link, title, body);
    }
}

