/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionList;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.BookmarksFolderServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class BookmarksIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{BookmarksEntry.class.getName()};
    public static final String PORTLET_ID = "28";
    private static final boolean _PERMISSION_AWARE = true;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean isPermissionAware() {
        return true;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        long[] folderIds = searchContext.getFolderIds();
        if (folderIds != null && folderIds.length > 0) {
            if (folderIds[0] == 0L) {
                return;
            }
            BooleanQuery folderIdsQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            long[] lArray = folderIds;
            int n = folderIds.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    long folderId = lArray[n2];
                    try {
                        BookmarksFolderServiceUtil.getFolder((long)folderId);
                    }
                    catch (Exception exception) {
                        break block5;
                    }
                    folderIdsQuery.addTerm("folderId", folderId);
                }
                ++n2;
            }
            contextQuery.add((Query)folderIdsQuery, BooleanClauseOccur.MUST);
        }
    }

    protected void addReindexCriteria(DynamicQuery dynamicQuery, long companyId) {
        Property property = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(property.eq((Object)companyId));
    }

    protected void addReindexCriteria(DynamicQuery dynamicQuery, long groupId, long folderId) {
        Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(groupIdProperty.eq((Object)groupId));
        Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
        dynamicQuery.add(folderIdProperty.eq((Object)folderId));
    }

    protected void doDelete(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        this.deleteDocument(entry.getCompanyId(), entry.getEntryId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)entry);
        document.addText("description", entry.getDescription());
        document.addKeyword("folderId", entry.getFolderId());
        document.addText("title", entry.getName());
        document.addText("url", entry.getUrl());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String url = document.get("url");
        String entryId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/bookmarks/view_entry");
        portletURL.setParameter("entryId", entryId);
        return new Summary(title, url, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        BookmarksEntry entry = (BookmarksEntry)obj;
        Document document = this.getDocument(entry);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)entry.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        BookmarksEntry entry = BookmarksEntryLocalServiceUtil.getEntry((long)classPK);
        this.doReindex(entry);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
        this.reindexRoot(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEntries(long companyId, long groupId, long folderId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(BookmarksEntry.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minEntryIdProjection = ProjectionFactoryUtil.min((String)"entryId");
        Projection maxEntryIdProjection = ProjectionFactoryUtil.max((String)"entryId");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minEntryIdProjection);
        projectionList.add(maxEntryIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, groupId, folderId);
        List results = BookmarksEntryLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxEntryIds = (Object[])results.get(0);
        if (minAndMaxEntryIds[0] == null || minAndMaxEntryIds[1] == null) {
            return;
        }
        long minEntryId = (Long)minAndMaxEntryIds[0];
        long maxEntryId = (Long)minAndMaxEntryIds[1];
        long startEntryId = minEntryId;
        long endEntryId = startEntryId + 10000L;
        while (startEntryId <= maxEntryId) {
            this.reindexEntries(companyId, groupId, folderId, startEntryId, endEntryId);
            startEntryId = endEntryId;
            endEntryId += 10000L;
        }
    }

    protected void reindexEntries(long companyId, long groupId, long folderId, long startEntryId, long endEntryId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(BookmarksEntry.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"entryId");
        dynamicQuery.add(property.ge((Object)startEntryId));
        dynamicQuery.add(property.lt((Object)endEntryId));
        this.addReindexCriteria(dynamicQuery, groupId, folderId);
        List entries = BookmarksEntryLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>(entries.size());
        for (BookmarksEntry entry : entries) {
            Document document = this.getDocument(entry);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }

    protected void reindexFolders(long companyId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(BookmarksFolder.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minFolderIdProjection = ProjectionFactoryUtil.min((String)"folderId");
        Projection maxFolderIdProjection = ProjectionFactoryUtil.max((String)"folderId");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minFolderIdProjection);
        projectionList.add(maxFolderIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, companyId);
        List results = BookmarksFolderLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxFolderIds = (Object[])results.get(0);
        if (minAndMaxFolderIds[0] == null || minAndMaxFolderIds[1] == null) {
            return;
        }
        long minFolderId = (Long)minAndMaxFolderIds[0];
        long maxFolderId = (Long)minAndMaxFolderIds[1];
        long startFolderId = minFolderId;
        long endFolderId = startFolderId + 10000L;
        while (startFolderId <= maxFolderId) {
            this.reindexFolders(companyId, startFolderId, endFolderId);
            startFolderId = endFolderId;
            endFolderId += 10000L;
        }
    }

    protected void reindexFolders(long companyId, long startFolderId, long endFolderId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(BookmarksFolder.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"folderId");
        dynamicQuery.add(property.ge((Object)startFolderId));
        dynamicQuery.add(property.lt((Object)endFolderId));
        this.addReindexCriteria(dynamicQuery, companyId);
        List folders = BookmarksFolderLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (BookmarksFolder folder : folders) {
            long groupId = folder.getGroupId();
            long folderId = folder.getFolderId();
            this.reindexEntries(companyId, groupId, folderId);
        }
    }

    protected void reindexRoot(long companyId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(Group.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minGroupIdProjection = ProjectionFactoryUtil.min((String)"groupId");
        Projection maxGroupIdProjection = ProjectionFactoryUtil.max((String)"groupId");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minGroupIdProjection);
        projectionList.add(maxGroupIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, companyId);
        List results = GroupLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxGroupIds = (Object[])results.get(0);
        if (minAndMaxGroupIds[0] == null || minAndMaxGroupIds[1] == null) {
            return;
        }
        long minGroupId = (Long)minAndMaxGroupIds[0];
        long maxGroupId = (Long)minAndMaxGroupIds[1];
        long startGroupId = minGroupId;
        long endGroupId = startGroupId + 10000L;
        while (startGroupId <= maxGroupId) {
            this.reindexRoot(companyId, startGroupId, endGroupId);
            startGroupId = endGroupId;
            endGroupId += 10000L;
        }
    }

    protected void reindexRoot(long companyId, long startGroupId, long endGroupId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(Group.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(property.ge((Object)startGroupId));
        dynamicQuery.add(property.lt((Object)endGroupId));
        this.addReindexCriteria(dynamicQuery, companyId);
        List groups = GroupLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        for (Group group : groups) {
            long groupId = group.getGroupId();
            long folderId = 0L;
            this.reindexEntries(companyId, groupId, folderId);
        }
    }
}

