/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.util;

import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.util.comparator.EntryCreateDateComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryModifiedDateComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryNameComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryPriorityComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryURLComparator;
import com.liferay.portlet.bookmarks.util.comparator.EntryVisitsComparator;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class BookmarksUtil {
    public static void addPortletBreadcrumbEntries(BookmarksEntry entry, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        BookmarksFolder folder = entry.getFolder();
        if (folder.getFolderId() != 0L) {
            BookmarksUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/bookmarks/view_entry");
        portletURL.setParameter("entryId", String.valueOf(entry.getEntryId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)entry.getName(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(BookmarksFolder folder, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (strutsAction.equals("/bookmarks/select_folder")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            portletURL.setParameter("struts_action", "/bookmarks/select_folder");
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString());
        } else {
            portletURL.setParameter("struts_action", "/bookmarks/view");
        }
        List ancestorFolders = folder.getAncestors();
        Collections.reverse(ancestorFolders);
        for (BookmarksFolder ancestorFolder : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorFolder.getName(), (String)portletURL.toString());
        }
        portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
        if (folder.getFolderId() != 0L) {
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)folder.getName(), (String)portletURL.toString());
        }
    }

    public static void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (folderId == 0L) {
            return;
        }
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)folderId);
        BookmarksUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
    }

    public static OrderByComparator getEntriesOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        EntryCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new EntryCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new EntryModifiedDateComparator(orderByAsc);
        } else if (orderByCol.equals("name")) {
            orderByComparator = new EntryNameComparator(orderByAsc);
        } else if (orderByCol.equals("priority")) {
            orderByComparator = new EntryPriorityComparator(orderByAsc);
        } else if (orderByCol.equals("url")) {
            orderByComparator = new EntryURLComparator(orderByAsc);
        } else if (orderByCol.equals("visits")) {
            orderByComparator = new EntryVisitsComparator(orderByAsc);
        }
        return orderByComparator;
    }
}

