/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.lar;

import com.liferay.portal.kernel.cal.TZSRecurrence;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import com.liferay.portlet.calendar.service.persistence.CalEventUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletPreferences;

public class CalendarPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "calendar";
    private static final boolean _PUBLISH_TO_LIVE_BY_DEFAULT = true;
    private static PortletDataHandlerBoolean _events = new PortletDataHandlerBoolean("calendar", "events", true, true);
    private static PortletDataHandlerControl[] _metadataControls = new PortletDataHandlerControl[]{new PortletDataHandlerBoolean("calendar", "categories"), new PortletDataHandlerBoolean("calendar", "comments"), new PortletDataHandlerBoolean("calendar", "ratings"), new PortletDataHandlerBoolean("calendar", "tags")};

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_events};
    }

    public PortletDataHandlerControl[] getExportMetadataControls() {
        return new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(_NAMESPACE, "events", true, _metadataControls)};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_events};
    }

    public PortletDataHandlerControl[] getImportMetadataControls() {
        return new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(_NAMESPACE, "events", true, _metadataControls)};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return true;
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (!portletDataContext.addPrimaryKey(CalendarPortletDataHandlerImpl.class, "deleteData")) {
            CalEventLocalServiceUtil.deleteEvents((long)portletDataContext.getScopeGroupId());
        }
        return null;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.calendar", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("calendar-data");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        List events = CalEventUtil.findByGroupId((long)portletDataContext.getScopeGroupId());
        for (CalEvent event : events) {
            this.exportEvent(portletDataContext, rootElement, event);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPermissions("com.liferay.portlet.calendar", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        for (Element eventElement : rootElement.elements("event")) {
            String path = eventElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) continue;
            CalEvent event = (CalEvent)portletDataContext.getZipEntryAsObject(path);
            this.importEvent(portletDataContext, eventElement, event);
        }
        return null;
    }

    protected void exportEvent(PortletDataContext portletDataContext, Element rootElement, CalEvent event) throws PortalException, SystemException {
        if (!portletDataContext.isWithinDateRange(event.getModifiedDate())) {
            return;
        }
        String path = this.getEventPath(portletDataContext, event);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element eventElement = rootElement.addElement("event");
        portletDataContext.addClassedModel(eventElement, path, (ClassedModel)event, _NAMESPACE);
    }

    protected String getEventPath(PortletDataContext portletDataContext, CalEvent event) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("8"));
        sb.append("/events/");
        sb.append(event.getEventId());
        sb.append(".xml");
        return sb.toString();
    }

    protected void importEvent(PortletDataContext portletDataContext, Element eventElement, CalEvent event) throws Exception {
        long userId = portletDataContext.getUserId(event.getUserUuid());
        Date startDate = event.getStartDate();
        int startDateMonth = 0;
        int startDateDay = 0;
        int startDateYear = 0;
        int startDateHour = 0;
        int startDateMinute = 0;
        if (startDate != null) {
            Calendar startCal = CalendarFactoryUtil.getCalendar();
            startCal.setTime(startDate);
            startDateMonth = startCal.get(2);
            startDateDay = startCal.get(5);
            startDateYear = startCal.get(1);
            startDateHour = startCal.get(10);
            startDateMinute = startCal.get(12);
            if (startCal.get(9) == 1) {
                startDateHour += 12;
            }
        }
        Date endDate = event.getEndDate();
        int endDateMonth = 0;
        int endDateDay = 0;
        int endDateYear = 0;
        if (endDate != null) {
            Calendar endCal = CalendarFactoryUtil.getCalendar();
            endCal.setTime(endDate);
            endDateMonth = endCal.get(2);
            endDateDay = endCal.get(5);
            endDateYear = endCal.get(1);
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext(eventElement, (ClassedModel)event, _NAMESPACE);
        CalEvent importedEvent = null;
        if (portletDataContext.isDataStrategyMirror()) {
            CalEvent existingEvent = CalEventUtil.fetchByUUID_G((String)event.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingEvent == null) {
                serviceContext.setUuid(event.getUuid());
                importedEvent = CalEventLocalServiceUtil.addEvent((long)userId, (String)event.getTitle(), (String)event.getDescription(), (String)event.getLocation(), (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)event.getDurationHour(), (int)event.getDurationMinute(), (boolean)event.getAllDay(), (boolean)event.getTimeZoneSensitive(), (String)event.getType(), (boolean)event.getRepeating(), (TZSRecurrence)event.getRecurrenceObj(), (int)event.getRemindBy(), (int)event.getFirstReminder(), (int)event.getSecondReminder(), (ServiceContext)serviceContext);
            } else {
                importedEvent = CalEventLocalServiceUtil.updateEvent((long)userId, (long)existingEvent.getEventId(), (String)event.getTitle(), (String)event.getDescription(), (String)event.getLocation(), (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)event.getDurationHour(), (int)event.getDurationMinute(), (boolean)event.getAllDay(), (boolean)event.getTimeZoneSensitive(), (String)event.getType(), (boolean)event.getRepeating(), (TZSRecurrence)event.getRecurrenceObj(), (int)event.getRemindBy(), (int)event.getFirstReminder(), (int)event.getSecondReminder(), (ServiceContext)serviceContext);
            }
        } else {
            importedEvent = CalEventLocalServiceUtil.addEvent((long)userId, (String)event.getTitle(), (String)event.getDescription(), (String)event.getLocation(), (int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)event.getDurationHour(), (int)event.getDurationMinute(), (boolean)event.getAllDay(), (boolean)event.getTimeZoneSensitive(), (String)event.getType(), (boolean)event.getRepeating(), (TZSRecurrence)event.getRecurrenceObj(), (int)event.getRemindBy(), (int)event.getFirstReminder(), (int)event.getSecondReminder(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)event, (ClassedModel)importedEvent, _NAMESPACE);
    }
}

