/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.service.impl;

import com.liferay.portal.kernel.cal.TZSRecurrence;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.base.CalEventServiceBaseImpl;
import com.liferay.portlet.calendar.service.permission.CalEventPermission;
import com.liferay.portlet.calendar.service.permission.CalendarPermission;
import java.io.File;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalEventServiceImpl
extends CalEventServiceBaseImpl {
    public CalEvent addEvent(String title, String description, String location, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int durationHour, int durationMinute, boolean allDay, boolean timeZoneSensitive, String type, boolean repeating, TZSRecurrence recurrence, int remindBy, int firstReminder, int secondReminder, ServiceContext serviceContext) throws PortalException, SystemException {
        CalendarPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_EVENT");
        return this.calEventLocalService.addEvent(this.getUserId(), title, description, location, startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, endDateMonth, endDateDay, endDateYear, durationHour, durationMinute, allDay, timeZoneSensitive, type, repeating, recurrence, remindBy, firstReminder, secondReminder, serviceContext);
    }

    public void deleteEvent(long eventId) throws PortalException, SystemException {
        CalEventPermission.check(this.getPermissionChecker(), eventId, "DELETE");
        this.calEventLocalService.deleteEvent(eventId);
    }

    public File exportEvent(long eventId) throws PortalException, SystemException {
        CalEventPermission.check(this.getPermissionChecker(), eventId, "VIEW");
        return this.calEventLocalService.exportEvent(this.getGuestOrUserId(), eventId);
    }

    public File exportGroupEvents(long groupId, String fileName) throws PortalException, SystemException {
        CalendarPermission.check(this.getPermissionChecker(), groupId, "EXPORT_ALL_EVENTS");
        return this.calEventLocalService.exportGroupEvents(this.getGuestOrUserId(), groupId, fileName);
    }

    public CalEvent getEvent(long eventId) throws PortalException, SystemException {
        CalEventPermission.check(this.getPermissionChecker(), eventId, "VIEW");
        return this.calEventLocalService.getEvent(eventId);
    }

    public List<CalEvent> getEvents(long groupId, Calendar cal, String type) throws PortalException, SystemException {
        return this.getEvents(groupId, cal, new String[]{type});
    }

    public List<CalEvent> getEvents(long groupId, Calendar cal, String[] types) throws PortalException, SystemException {
        List events = this.calEventLocalService.getEvents(groupId, cal, types);
        events = ListUtil.copy((List)events);
        Iterator itr = events.iterator();
        while (itr.hasNext()) {
            CalEvent event = (CalEvent)itr.next();
            if (CalEventPermission.contains(this.getPermissionChecker(), event, "VIEW")) continue;
            itr.remove();
        }
        return events;
    }

    public List<CalEvent> getEvents(long groupId, String type, int start, int end) throws SystemException {
        return this.getEvents(groupId, new String[]{type}, start, end);
    }

    public List<CalEvent> getEvents(long groupId, String[] types, int start, int end) throws SystemException {
        if (types != null && types.length > 0 && (types.length > 1 || Validator.isNotNull((String)types[0]))) {
            return this.calEventPersistence.filterFindByG_T(groupId, types, start, end);
        }
        return this.calEventPersistence.filterFindByGroupId(groupId, start, end);
    }

    public int getEventsCount(long groupId, String type) throws SystemException {
        return this.getEventsCount(groupId, new String[]{type});
    }

    public int getEventsCount(long groupId, String[] types) throws SystemException {
        if (types != null && types.length > 0 && (types.length > 1 || Validator.isNotNull((String)types[0]))) {
            return this.calEventPersistence.filterCountByG_T(groupId, types);
        }
        return this.calEventPersistence.filterCountByGroupId(groupId);
    }

    public boolean hasEvents(long groupId, Calendar cal) throws PortalException, SystemException {
        return this.hasEvents(groupId, cal, new String[0]);
    }

    public boolean hasEvents(long groupId, Calendar cal, String type) throws PortalException, SystemException {
        return this.hasEvents(groupId, cal, new String[]{type});
    }

    public boolean hasEvents(long groupId, Calendar cal, String[] types) throws PortalException, SystemException {
        List<CalEvent> events = this.getEvents(groupId, cal, types);
        return !events.isEmpty();
    }

    public void importICal4j(long groupId, InputStream inputStream) throws PortalException, SystemException {
        CalendarPermission.check(this.getPermissionChecker(), groupId, "ADD_EVENT");
        this.calEventLocalService.importICal4j(this.getUserId(), groupId, inputStream);
    }

    public CalEvent updateEvent(long eventId, String title, String description, String location, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, int endDateMonth, int endDateDay, int endDateYear, int durationHour, int durationMinute, boolean allDay, boolean timeZoneSensitive, String type, boolean repeating, TZSRecurrence recurrence, int remindBy, int firstReminder, int secondReminder, ServiceContext serviceContext) throws PortalException, SystemException {
        CalEventPermission.check(this.getPermissionChecker(), eventId, "UPDATE");
        return this.calEventLocalService.updateEvent(this.getUserId(), eventId, title, description, location, startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, endDateMonth, endDateDay, endDateYear, durationHour, durationMinute, allDay, timeZoneSensitive, type, repeating, recurrence, remindBy, firstReminder, secondReminder, serviceContext);
    }
}

