/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.model.impl.CalEventImpl;
import com.liferay.portlet.calendar.service.persistence.CalEventFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalEventFinderImpl
extends BasePersistenceImpl<CalEvent>
implements CalEventFinder {
    public static final String COUNT_BY_G_SD_T = String.valueOf(CalEventFinder.class.getName()) + ".countByG_SD_T";
    public static final String FIND_BY_FUTURE_REMINDERS = String.valueOf(CalEventFinder.class.getName()) + ".findByFutureReminders";
    public static final String FIND_BY_NO_ASSETS = String.valueOf(CalEventFinder.class.getName()) + ".findByNoAssets";
    public static final String FIND_BY_G_SD_T = String.valueOf(CalEventFinder.class.getName()) + ".findByG_SD_T";

    public int countByG_SD_T(long groupId, Date startDateGT, Date startDateLT, boolean timeZoneSensitive, String[] types) throws SystemException {
        Timestamp startDateGT_TS = CalendarUtil.getTimestamp((Date)startDateGT);
        Timestamp startDateLT_TS = CalendarUtil.getTimestamp((Date)startDateLT);
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_G_SD_T);
            sql = StringUtil.replace((String)sql, (String)"[$TYPE$]", (String)this.getTypes(types));
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("CalEvent", CalEventImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(startDateGT_TS);
            qPos.add(startDateLT_TS);
            qPos.add(timeZoneSensitive);
            qPos.add(false);
            if (types != null && types.length > 0 && (types.length > 1 || Validator.isNotNull((String)types[0]))) {
                String[] stringArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    qPos.add(type);
                    ++n2;
                }
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CalEvent> findByFutureReminders() throws SystemException {
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, -24);
        Timestamp calendar_TS = CalendarUtil.getTimestamp((Date)calendar.getTime());
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_FUTURE_REMINDERS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("CalEvent", CalEventImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(0);
            qPos.add(calendar_TS);
            qPos.add(calendar_TS);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CalEvent> findByNoAssets() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("CalEvent", CalEventImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CalEvent> findByG_SD_T(long groupId, Date startDateGT, Date startDateLT, boolean timeZoneSensitive, String[] types) throws SystemException {
        return this.findByG_SD_T(groupId, startDateGT, startDateLT, timeZoneSensitive, types, -1, -1);
    }

    public List<CalEvent> findByG_SD_T(long groupId, Date startDateGT, Date startDateLT, boolean timeZoneSensitive, String[] types, int start, int end) throws SystemException {
        Timestamp startDateGT_TS = CalendarUtil.getTimestamp((Date)startDateGT);
        Timestamp startDateLT_TS = CalendarUtil.getTimestamp((Date)startDateLT);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_G_SD_T);
            sql = StringUtil.replace((String)sql, (String)"[$TYPE$]", (String)this.getTypes(types));
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("CalEvent", CalEventImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(startDateGT_TS);
            qPos.add(startDateLT_TS);
            qPos.add(timeZoneSensitive);
            qPos.add(false);
            if (types != null && types.length > 0 && (types.length > 1 || Validator.isNotNull((String)types[0]))) {
                String[] stringArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    qPos.add(type);
                    ++n2;
                }
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getTypes(String[] types) {
        if (types != null && types.length > 0 && (types.length > 1 || Validator.isNotNull((String)types[0]))) {
            StringBundler sb = new StringBundler(types.length * 2 + 1);
            sb.append(" AND (");
            int i2 = 0;
            while (i2 < types.length) {
                sb.append("type_ = ? ");
                if (i2 + 1 != types.length) {
                    sb.append("OR ");
                }
                ++i2;
            }
            sb.append(")");
            return sb.toString();
        }
        return "";
    }
}

