/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.util;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ProjectionList;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletURL;

public class CalIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{CalEvent.class.getName()};
    public static final String PORTLET_ID = "8";
    private static final boolean _PERMISSION_AWARE = true;

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean isPermissionAware() {
        return true;
    }

    protected void addReindexCriteria(DynamicQuery dynamicQuery, long companyId) {
        Property property = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(property.eq((Object)companyId));
    }

    protected void doDelete(Object obj) throws Exception {
        CalEvent event = (CalEvent)obj;
        this.deleteDocument(event.getCompanyId(), event.getEventId());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        CalEvent event = (CalEvent)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)event);
        document.addText("description", HtmlUtil.extractText((String)event.getDescription()));
        document.addText("title", event.getTitle());
        document.addKeyword("type", event.getType());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("description"), (int)200);
        }
        String eventId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/calendar/view_event");
        portletURL.setParameter("eventId", eventId);
        return new Summary(title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        CalEvent event = (CalEvent)obj;
        Document document = this.getDocument(event);
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)event.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        CalEvent event = CalEventLocalServiceUtil.getEvent((long)classPK);
        this.doReindex(event);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexEvents(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexEvents(long companyId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(CalEvent.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Projection minEventIdProjection = ProjectionFactoryUtil.min((String)"eventId");
        Projection maxEventIdProjection = ProjectionFactoryUtil.max((String)"eventId");
        ProjectionList projectionList = ProjectionFactoryUtil.projectionList();
        projectionList.add(minEventIdProjection);
        projectionList.add(maxEventIdProjection);
        dynamicQuery.setProjection((Projection)projectionList);
        this.addReindexCriteria(dynamicQuery, companyId);
        List results = CalEventLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        Object[] minAndMaxEventIds = (Object[])results.get(0);
        if (minAndMaxEventIds[0] == null || minAndMaxEventIds[1] == null) {
            return;
        }
        long minEventId = (Long)minAndMaxEventIds[0];
        long maxEventId = (Long)minAndMaxEventIds[1];
        long startEventId = minEventId;
        long endEventId = startEventId + 10000L;
        while (startEventId <= maxEventId) {
            this.reindexEvents(companyId, startEventId, endEventId);
            startEventId = endEventId;
            endEventId += 10000L;
        }
    }

    protected void reindexEvents(long companyId, long startEventId, long endEventId) throws Exception {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(CalEvent.class, (ClassLoader)PACLClassLoaderUtil.getPortalClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"eventId");
        dynamicQuery.add(property.ge((Object)startEventId));
        dynamicQuery.add(property.lt((Object)endEventId));
        this.addReindexCriteria(dynamicQuery, companyId);
        List events = CalEventLocalServiceUtil.dynamicQuery((DynamicQuery)dynamicQuery);
        if (events.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>(events.size());
        for (CalEvent event : events) {
            Document document = this.getDocument(event);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)companyId, documents);
    }
}

