/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.util.ContentUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;

public class CalUtil {
    public static String getEmailEventReminderBody(PortletPreferences preferences) {
        String emailEventReminderBody = preferences.getValue("emailEventReminderBody", "");
        if (Validator.isNotNull((String)emailEventReminderBody)) {
            return emailEventReminderBody;
        }
        return ContentUtil.get((String)PropsUtil.get("calendar.email.event.reminder.body"));
    }

    public static boolean getEmailEventReminderEnabled(PortletPreferences preferences) {
        String emailEventReminderEnabled = preferences.getValue("emailEventReminderEnabled", "");
        if (Validator.isNotNull((String)emailEventReminderEnabled)) {
            return GetterUtil.getBoolean((String)emailEventReminderEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("calendar.email.event.reminder.enabled"));
    }

    public static String getEmailEventReminderSubject(PortletPreferences preferences) {
        String emailEventReminderSubject = preferences.getValue("emailEventReminderSubject", "");
        if (Validator.isNotNull((String)emailEventReminderSubject)) {
            return emailEventReminderSubject;
        }
        return ContentUtil.get((String)PropsUtil.get("calendar.email.event.reminder.subject"));
    }

    public static String getEmailFromAddress(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromAddress((PortletPreferences)preferences, (long)companyId, (String)PropsValues.CALENDAR_EMAIL_FROM_ADDRESS);
    }

    public static String getEmailFromName(PortletPreferences preferences, long companyId) throws SystemException {
        return PortalUtil.getEmailFromName((PortletPreferences)preferences, (long)companyId, (String)PropsValues.CALENDAR_EMAIL_FROM_NAME);
    }

    public static Date getEndTime(CalEvent event) {
        long startTime = event.getStartDate().getTime();
        long endTime = startTime + 3600000L * (long)event.getDurationHour() + 60000L * (long)event.getDurationMinute();
        return new Date(endTime);
    }

    public static boolean isAllDay(CalEvent event, TimeZone timeZone, Locale locale) {
        if (event.isAllDay()) {
            return true;
        }
        Calendar cal = null;
        cal = event.getTimeZoneSensitive() ? CalendarFactoryUtil.getCalendar((TimeZone)timeZone, (Locale)locale) : CalendarFactoryUtil.getCalendar();
        cal.setTime(event.getStartDate());
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int millisecond = cal.get(14);
        int dHour = event.getDurationHour();
        int dMinute = event.getDurationMinute();
        return hour == 0 && minute == 0 && second == 0 && millisecond == 0 && dHour == 24 && dMinute == 0;
    }

    public static String toString(Calendar cal, String[] types) {
        StringBundler sb = new StringBundler(9);
        if (cal != null) {
            sb.append(cal.get(1));
            sb.append(".");
            sb.append(cal.get(2));
            sb.append(".");
            sb.append(cal.get(5));
            sb.append(".");
            sb.append(cal.getTimeZone().getRawOffset());
        }
        if (types != null && types.length > 0 && (types.length > 1 || Validator.isNotNull((String)types[0]))) {
            sb.append(".");
            sb.append(StringUtil.merge((Object[])types, (String)"."));
        }
        return sb.toString();
    }
}

