/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.util.comparator;

import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.util.CalUtil;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTimeComparator
implements Comparator<CalEvent> {
    private Locale _locale;
    private TimeZone _timeZone;

    public EventTimeComparator(TimeZone timeZone, Locale locale) {
        this._timeZone = timeZone;
        this._locale = locale;
    }

    @Override
    public int compare(CalEvent event1, CalEvent event2) {
        Long duration2;
        Date startDate2;
        boolean allDay1 = CalUtil.isAllDay(event1, this._timeZone, this._locale);
        boolean allDay2 = CalUtil.isAllDay(event2, this._timeZone, this._locale);
        if (allDay1 && allDay2) {
            return this.compareTitle(event1, event2);
        }
        if (allDay1) {
            return -1;
        }
        if (allDay2) {
            return 1;
        }
        boolean repeating = event1.isRepeating() || event2.isRepeating();
        Date startDate1 = this.getStartDate(event1, this._timeZone, repeating);
        int value = startDate1.compareTo(startDate2 = this.getStartDate(event2, this._timeZone, repeating));
        if (value != 0) {
            return value;
        }
        Long duration1 = this.getDuration(event1);
        value = duration1.compareTo(duration2 = this.getDuration(event2));
        if (value != 0) {
            return value;
        }
        return this.compareTitle(event1, event2);
    }

    protected int compareTitle(CalEvent event1, CalEvent event2) {
        return event1.getTitle().toLowerCase().compareTo(event2.getTitle().toLowerCase());
    }

    protected Long getDuration(CalEvent event) {
        return 3600000L * (long)event.getDurationHour() + 60000L * (long)event.getDurationMinute();
    }

    protected Date getStartDate(CalEvent event, TimeZone timeZone, boolean repeating) {
        if (repeating) {
            Calendar calendar = null;
            calendar = event.isTimeZoneSensitive() ? CalendarFactoryUtil.getCalendar((TimeZone)this._timeZone) : CalendarFactoryUtil.getCalendar();
            calendar.setTime(event.getStartDate());
            calendar.set(2, 0);
            calendar.set(5, 1);
            calendar.set(1, 1);
            return Time.getDate((Calendar)calendar);
        }
        if (event.isTimeZoneSensitive()) {
            return Time.getDate((Date)event.getStartDate(), (TimeZone)timeZone);
        }
        return event.getStartDate();
    }
}

