/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.directory.asset;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class UserAssetRenderer
extends BaseAssetRenderer {
    private User _user;

    public UserAssetRenderer(User user) {
        this._user = user;
    }

    public long getClassPK() {
        return this._user.getPrimaryKey();
    }

    public String getDiscussionPath() {
        return null;
    }

    public long getGroupId() {
        return 0L;
    }

    public String getSummary(Locale locale) {
        return this._user.getComments();
    }

    public String getTitle(Locale locale) {
        return this._user.getFullName();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "125", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/users_admin/edit_user");
        portletURL.setParameter("p_u_i_d", String.valueOf(this._user.getUserId()));
        return portletURL;
    }

    public String getUrlTitle() {
        return this._user.getScreenName();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/directory/find_user", "p_u_i_d", this._user.getUserId());
    }

    public long getUserId() {
        return this._user.getUserId();
    }

    public String getUserName() {
        return this._user.getFullName();
    }

    public String getUuid() {
        return this._user.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this._user.getUserId(), (String)"UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)this._user.getUserId(), (String)"VIEW");
    }

    public boolean isPrintable() {
        return false;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("USER", (Object)this._user);
            return "/html/portlet/directory/asset/abstract.jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/user_icon.png";
    }
}

