/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.SourceFileNameException;
import com.liferay.portlet.documentlibrary.action.ActionUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteEntries(actionRequest);
            } else if (cmd.equals("cancel_checkout")) {
                this.cancelCheckedOutEntries(actionRequest);
            } else if (cmd.equals("checkin")) {
                this.checkInEntries(actionRequest);
            } else if (cmd.equals("checkout")) {
                this.checkOutEntries(actionRequest);
            } else if (cmd.equals("move")) {
                this.moveEntries(actionRequest);
            }
            WindowState windowState = actionRequest.getWindowState();
            if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                this.sendRedirect(actionRequest, actionResponse);
            } else {
                String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                if (Validator.isNotNull((String)redirect)) {
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (Exception e2) {
            if (e2 instanceof DuplicateLockException || e2 instanceof NoSuchFileEntryException || e2 instanceof NoSuchFolderException || e2 instanceof PrincipalException) {
                if (e2 instanceof DuplicateLockException) {
                    DuplicateLockException dle = (DuplicateLockException)e2;
                    SessionErrors.add((PortletRequest)actionRequest, dle.getClass(), (Object)dle.getLock());
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                }
                this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
            }
            if (e2 instanceof DuplicateFileException || e2 instanceof DuplicateFolderNameException || e2 instanceof NoSuchFolderException || e2 instanceof SourceFileNameException) {
                if (e2 instanceof DuplicateFileException) {
                    HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                    response.setStatus(490);
                }
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof AssetCategoryException || e2 instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            throw e2;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFileEntries((PortletRequest)renderRequest);
            ActionUtil.getFileShortcuts((PortletRequest)renderRequest);
            ActionUtil.getFolders((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchFileEntryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.document_library.error");
            }
            throw e2;
        }
        String forward = "portlet.document_library.edit_entry";
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, forward));
    }

    protected void cancelCheckedOutEntries(ActionRequest actionRequest) throws Exception {
        long[] fileEntryIds;
        long[] lArray = fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
        int n = fileEntryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long fileEntryId = lArray[n2];
            DLAppServiceUtil.cancelCheckOut((long)fileEntryId);
            ++n2;
        }
    }

    protected void checkInEntries(ActionRequest actionRequest) throws Exception {
        long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        long[] lArray = fileEntryIds;
        int n = fileEntryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long fileEntryId = lArray[n2];
            DLAppServiceUtil.checkInFileEntry((long)fileEntryId, (boolean)false, (String)"", (ServiceContext)serviceContext);
            ++n2;
        }
    }

    protected void checkOutEntries(ActionRequest actionRequest) throws Exception {
        long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        long[] lArray = fileEntryIds;
        int n = fileEntryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long fileEntryId = lArray[n2];
            DLAppServiceUtil.checkOutFileEntry((long)fileEntryId, (ServiceContext)serviceContext);
            ++n2;
        }
    }

    protected void deleteEntries(ActionRequest actionRequest) throws Exception {
        long[] deleteFileEntryIds;
        long[] deleteFileShortcutIds;
        long[] deleteFolderIds;
        long[] lArray = deleteFolderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        int n = deleteFolderIds.length;
        int n2 = 0;
        while (n2 < n) {
            long deleteFolderId = lArray[n2];
            DLAppServiceUtil.deleteFolder((long)deleteFolderId);
            ++n2;
        }
        long[] lArray2 = deleteFileShortcutIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileShortcutIds"), (long)0L);
        int n3 = deleteFileShortcutIds.length;
        n = 0;
        while (n < n3) {
            long deleteFileShortcutId = lArray2[n];
            DLAppServiceUtil.deleteFileShortcut((long)deleteFileShortcutId);
            ++n;
        }
        long[] lArray3 = deleteFileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
        int n4 = deleteFileEntryIds.length;
        n3 = 0;
        while (n3 < n4) {
            long deleteFileEntryId = lArray3[n3];
            DLAppServiceUtil.deleteFileEntry((long)deleteFileEntryId);
            ++n3;
        }
    }

    protected void moveEntries(ActionRequest actionRequest) throws Exception {
        long[] fileShortcutIds;
        long[] fileEntryIds;
        long[] folderIds;
        long newFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"newFolderId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        long[] lArray = folderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        int n = folderIds.length;
        int n2 = 0;
        while (n2 < n) {
            long folderId = lArray[n2];
            DLAppServiceUtil.moveFolder((long)folderId, (long)newFolderId, (ServiceContext)serviceContext);
            ++n2;
        }
        long[] lArray2 = fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
        int n3 = fileEntryIds.length;
        n = 0;
        while (n < n3) {
            long fileEntryId = lArray2[n];
            DLAppServiceUtil.moveFileEntry((long)fileEntryId, (long)newFolderId, (ServiceContext)serviceContext);
            ++n;
        }
        long[] lArray3 = fileShortcutIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileShortcutIds"), (long)0L);
        int n4 = fileShortcutIds.length;
        n3 = 0;
        while (n3 < n4) {
            long fileShortcutId = lArray3[n3];
            if (fileShortcutId != 0L) {
                DLFileShortcut fileShortcut = DLAppServiceUtil.getFileShortcut((long)fileShortcutId);
                DLAppServiceUtil.updateFileShortcut((long)fileShortcutId, (long)newFolderId, (long)fileShortcut.getToFileEntryId(), (ServiceContext)serviceContext);
            }
            ++n3;
        }
    }
}

