/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FileExtensionException;
import com.liferay.portlet.documentlibrary.FileMimeTypeException;
import com.liferay.portlet.documentlibrary.FileNameException;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.documentlibrary.InvalidFileEntryTypeException;
import com.liferay.portlet.documentlibrary.InvalidFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileVersionException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.SourceFileNameException;
import com.liferay.portlet.documentlibrary.action.ActionUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.StorageFieldRequiredException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditFileEntryAction
extends PortletAction {
    private static final String _TEMP_FOLDER_NAME = EditFileEntryAction.class.getName();

    @Override
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (Validator.isNull((String)cmd)) {
                UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
                if (uploadException != null) {
                    if (uploadException.isExceededSizeLimit()) {
                        throw new FileSizeException(uploadException.getCause());
                    }
                    throw new PortalException(uploadException.getCause());
                }
            } else if (cmd.equals("add") || cmd.equals("update") || cmd.equals("update_and_checkin")) {
                this.updateFileEntry(portletConfig, actionRequest, actionResponse);
            } else if (cmd.equals("add_multiple")) {
                this.addMultipleFileEntries(actionRequest, actionResponse);
            } else if (cmd.equals("add_temp")) {
                this.addTempFileEntry(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFileEntry(actionRequest);
            } else if (cmd.equals("delete_temp")) {
                this.deleteTempFileEntry(actionRequest, actionResponse);
            } else if (cmd.equals("cancel_checkout")) {
                this.cancelFileEntriesCheckOut(actionRequest);
            } else if (cmd.equals("checkin")) {
                this.checkInFileEntries(actionRequest);
            } else if (cmd.equals("checkout")) {
                this.checkOutFileEntries(actionRequest);
            } else if (cmd.equals("move")) {
                this.moveFileEntries(actionRequest);
            } else if (cmd.equals("revert")) {
                this.revertFileEntry(actionRequest);
            }
            WindowState windowState = actionRequest.getWindowState();
            if (cmd.equals("add_temp") || cmd.equals("delete_temp")) {
                this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
            } else if (!cmd.equals("preview")) {
                if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    this.sendRedirect(actionRequest, actionResponse);
                } else {
                    String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                    if (Validator.isNotNull((String)redirect)) {
                        actionResponse.sendRedirect(redirect);
                    }
                }
            }
        }
        catch (Exception e2) {
            if (e2 instanceof DuplicateLockException || e2 instanceof InvalidFileVersionException || e2 instanceof NoSuchFileEntryException || e2 instanceof PrincipalException) {
                if (e2 instanceof DuplicateLockException) {
                    DuplicateLockException dle = (DuplicateLockException)e2;
                    SessionErrors.add((PortletRequest)actionRequest, dle.getClass(), (Object)dle.getLock());
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                }
                this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
            }
            if (e2 instanceof DuplicateFileException || e2 instanceof DuplicateFolderNameException || e2 instanceof FileExtensionException || e2 instanceof FileMimeTypeException || e2 instanceof FileNameException || e2 instanceof FileSizeException || e2 instanceof NoSuchFolderException || e2 instanceof SourceFileNameException || e2 instanceof StorageFieldRequiredException) {
                if (!cmd.equals("add_multiple") && !cmd.equals("add_temp")) {
                    SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                    return;
                }
                if (e2 instanceof DuplicateFileException) {
                    HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                    response.setStatus(490);
                } else if (e2 instanceof FileExtensionException) {
                    HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                    response.setStatus(491);
                } else if (e2 instanceof FileNameException) {
                    HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                    response.setStatus(492);
                } else if (e2 instanceof FileSizeException) {
                    HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                    response.setStatus(493);
                }
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof AssetCategoryException || e2 instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass(), (Object)e2);
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFileEntry((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchFileEntryException || e2 instanceof NoSuchFileVersionException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return mapping.findForward("portlet.document_library.error");
            }
            throw e2;
        }
        String forward = "portlet.document_library.edit_file_entry";
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, forward));
    }

    @Override
    public void serveResource(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/html/portlet/document_library/upload_multiple_file_entries_resources.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void addMultipleFileEntries(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String[] selectedFileNames;
        ArrayList<String> validFileNames = new ArrayList<String>();
        ArrayList<KeyValuePair> invalidFileNameKVPs = new ArrayList<KeyValuePair>();
        String[] stringArray = selectedFileNames = ParamUtil.getParameterValues((PortletRequest)actionRequest, (String)"selectedFileName");
        int n = selectedFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String selectedFileName = stringArray[n2];
            this.addMultipleFileEntries(actionRequest, actionResponse, selectedFileName, validFileNames, invalidFileNameKVPs);
            ++n2;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (String validFileName : validFileNames) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("added", Boolean.TRUE.booleanValue());
            jsonObject.put("fileName", validFileName);
            jsonArray.put(jsonObject);
        }
        for (KeyValuePair invalidFileNameKVP : invalidFileNameKVPs) {
            String fileName = invalidFileNameKVP.getKey();
            String errorMessage = invalidFileNameKVP.getValue();
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("added", Boolean.FALSE.booleanValue());
            jsonObject.put("errorMessage", errorMessage);
            jsonObject.put("fileName", fileName);
            jsonArray.put(jsonObject);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonArray);
    }

    protected void addMultipleFileEntries(ActionRequest actionRequest, ActionResponse actionResponse, String selectedFileName, List<String> validFileNames, List<KeyValuePair> invalidFileNameKVPs) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String contentType = MimeTypesUtil.getContentType((String)selectedFileName);
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        String changeLog = ParamUtil.getString((PortletRequest)actionRequest, (String)"changeLog");
        String tempFileName = TempFileUtil.getTempFileName((long)themeDisplay.getUserId(), (String)selectedFileName, (String)_TEMP_FOLDER_NAME);
        try {
            InputStream inputStream = TempFileUtil.getTempFileAsStream((String)tempFileName);
            long size = TempFileUtil.getTempFileSize((String)tempFileName);
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
            FileEntry fileEntry = DLAppServiceUtil.addFileEntry((long)repositoryId, (long)folderId, (String)selectedFileName, (String)contentType, (String)selectedFileName, (String)description, (String)changeLog, (InputStream)inputStream, (long)size, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, DLFileEntry.class.getName(), fileEntry.getFileEntryId(), -1);
            AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, DLFileEntry.class.getName(), folderId);
            validFileNames.add(selectedFileName);
            return;
        }
        catch (Exception e2) {
            String errorMessage = this.getAddMultipleFileEntriesErrorMessage(themeDisplay, e2);
            invalidFileNameKVPs.add(new KeyValuePair(selectedFileName, errorMessage));
        }
        finally {
            TempFileUtil.deleteTempFile((String)tempFileName);
        }
    }

    protected void addTempFileEntry(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
        String sourceFileName = uploadPortletRequest.getFileName("file");
        InputStream inputStream = null;
        try {
            inputStream = uploadPortletRequest.getFileAsStream("file");
            DLAppServiceUtil.addTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)folderId, (String)sourceFileName, (String)_TEMP_FOLDER_NAME, (InputStream)inputStream);
        }
        finally {
            StreamUtil.cleanUp((InputStream)inputStream);
        }
    }

    protected void cancelFileEntriesCheckOut(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        if (fileEntryId > 0L) {
            DLAppServiceUtil.cancelCheckOut((long)fileEntryId);
        } else {
            long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
            int i2 = 0;
            while (i2 < fileEntryIds.length) {
                DLAppServiceUtil.cancelCheckOut((long)fileEntryIds[i2]);
                ++i2;
            }
        }
    }

    protected void checkInFileEntries(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        if (fileEntryId > 0L) {
            DLAppServiceUtil.checkInFileEntry((long)fileEntryId, (boolean)false, (String)"", (ServiceContext)serviceContext);
        } else {
            long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
            int i2 = 0;
            while (i2 < fileEntryIds.length) {
                DLAppServiceUtil.checkInFileEntry((long)fileEntryIds[i2], (boolean)false, (String)"", (ServiceContext)serviceContext);
                ++i2;
            }
        }
    }

    protected void checkOutFileEntries(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        if (fileEntryId > 0L) {
            DLAppServiceUtil.checkOutFileEntry((long)fileEntryId, (ServiceContext)serviceContext);
        } else {
            long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
            int i2 = 0;
            while (i2 < fileEntryIds.length) {
                DLAppServiceUtil.checkOutFileEntry((long)fileEntryIds[i2], (ServiceContext)serviceContext);
                ++i2;
            }
        }
    }

    protected void deleteFileEntry(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
        if (fileEntryId == 0L) {
            return;
        }
        if (Validator.isNotNull((String)version)) {
            DLAppServiceUtil.deleteFileVersion((long)fileEntryId, (String)version);
        } else {
            DLAppServiceUtil.deleteFileEntry((long)fileEntryId);
        }
    }

    protected void deleteTempFileEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            DLAppServiceUtil.deleteTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)folderId, (String)fileName, (String)_TEMP_FOLDER_NAME);
            jsonObject.put("deleted", Boolean.TRUE.booleanValue());
        }
        catch (Exception exception) {
            String errorMessage = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"an-unexpected-error-occurred-while-deleting-the-file");
            jsonObject.put("deleted", Boolean.FALSE.booleanValue());
            jsonObject.put("errorMessage", errorMessage);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
    }

    protected String getAddMultipleFileEntriesErrorMessage(ThemeDisplay themeDisplay, Exception e2) throws Exception {
        String errorMessage = null;
        if (e2 instanceof AssetCategoryException) {
            AssetCategoryException ace = (AssetCategoryException)e2;
            AssetVocabulary assetVocabulary = ace.getVocabulary();
            String vocabularyTitle = "";
            if (assetVocabulary != null) {
                vocabularyTitle = assetVocabulary.getTitle(themeDisplay.getLocale());
            }
            if (ace.getType() == 1) {
                errorMessage = LanguageUtil.format((Locale)themeDisplay.getLocale(), (String)"please-select-at-least-one-category-for-x", (Object)vocabularyTitle);
            } else if (ace.getType() == 2) {
                errorMessage = LanguageUtil.format((Locale)themeDisplay.getLocale(), (String)"you-cannot-select-more-than-one-category-for-x", (Object)vocabularyTitle);
            }
        } else if (e2 instanceof DuplicateFileException) {
            errorMessage = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-folder-you-selected-already-has-an-entry-with-this-name.-please-select-a-different-folder");
        } else if (e2 instanceof FileExtensionException) {
            errorMessage = LanguageUtil.format((Locale)themeDisplay.getLocale(), (String)"please-enter-a-file-with-a-valid-extension-x", (Object)StringUtil.merge((Object[])PrefsPropsUtil.getStringArray("dl.file.extensions", ",")));
        } else if (e2 instanceof FileNameException) {
            errorMessage = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"please-enter-a-file-with-a-valid-file-name");
        } else if (e2 instanceof FileSizeException) {
            long maxSizeMB = PrefsPropsUtil.getLong("dl.file.max.size") / 1024L / 1024L;
            errorMessage = LanguageUtil.format((Locale)themeDisplay.getLocale(), (String)"file-size-is-larger-than-x-megabytes", (Object)maxSizeMB);
        } else {
            errorMessage = e2 instanceof InvalidFileEntryTypeException ? LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-document-type-you-selected-is-not-valid-for-this-folder") : LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"an-unexpected-error-occurred-while-saving-your-document");
        }
        return errorMessage;
    }

    protected void moveFileEntries(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        long newFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"newFolderId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        if (fileEntryId > 0L) {
            DLAppServiceUtil.moveFileEntry((long)fileEntryId, (long)newFolderId, (ServiceContext)serviceContext);
        } else {
            long[] fileEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"fileEntryIds"), (long)0L);
            int i2 = 0;
            while (i2 < fileEntryIds.length) {
                DLAppServiceUtil.moveFileEntry((long)fileEntryIds[i2], (long)newFolderId, (ServiceContext)serviceContext);
                ++i2;
            }
        }
    }

    protected void revertFileEntry(ActionRequest actionRequest) throws Exception {
        long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
        String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        DLAppServiceUtil.revertFileEntry((long)fileEntryId, (String)version, (ServiceContext)serviceContext);
    }

    protected void updateFileEntry(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Folder folder;
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        String cmd = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"cmd");
        long fileEntryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"fileEntryId");
        long repositoryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"repositoryId");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
        String sourceFileName = uploadPortletRequest.getFileName("file");
        String title = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"title");
        String description = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"description");
        String changeLog = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"changeLog");
        boolean majorVersion = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"majorVersion");
        if (folderId > 0L && (folder = DLAppServiceUtil.getFolder((long)folderId)).getGroupId() != themeDisplay.getScopeGroupId()) {
            throw new NoSuchFolderException();
        }
        InputStream inputStream = null;
        try {
            String portletName;
            String contentType = uploadPortletRequest.getContentType("file");
            long size = uploadPortletRequest.getSize("file");
            if (cmd.equals("add") && size == 0L) {
                contentType = MimeTypesUtil.getContentType((String)title);
            }
            if ((cmd.equals("add") || size > 0L) && (portletName = portletConfig.getPortletName()).equals("31")) {
                String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
                PortletPreferences portletPreferences = null;
                if (Validator.isNotNull((String)portletResource)) {
                    PortletPreferencesFactoryUtil.getPortletSetup((PortletRequest)actionRequest, (String)portletResource);
                } else {
                    portletPreferences = actionRequest.getPreferences();
                }
                Object[] mimeTypes = DLUtil.getMediaGalleryMimeTypes((PortletPreferences)portletPreferences, (PortletRequest)actionRequest);
                if (Arrays.binarySearch(mimeTypes, contentType) < 0) {
                    throw new FileMimeTypeException(contentType);
                }
            }
            inputStream = uploadPortletRequest.getFileAsStream("file");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (UploadPortletRequest)uploadPortletRequest);
            FileEntry fileEntry = null;
            if (cmd.equals("add")) {
                fileEntry = DLAppServiceUtil.addFileEntry((long)repositoryId, (long)folderId, (String)sourceFileName, (String)contentType, (String)title, (String)description, (String)changeLog, (InputStream)inputStream, (long)size, (ServiceContext)serviceContext);
                AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, DLFileEntry.class.getName(), fileEntry.getFileEntryId(), -1);
            } else {
                fileEntry = cmd.equals("update_and_checkin") ? DLAppServiceUtil.updateFileEntryAndCheckIn((long)fileEntryId, (String)sourceFileName, (String)contentType, (String)title, (String)description, (String)changeLog, (boolean)majorVersion, (InputStream)inputStream, (long)size, (ServiceContext)serviceContext) : DLAppServiceUtil.updateFileEntry((long)fileEntryId, (String)sourceFileName, (String)contentType, (String)title, (String)description, (String)changeLog, (boolean)majorVersion, (InputStream)inputStream, (long)size, (ServiceContext)serviceContext);
            }
            AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, DLFileEntry.class.getName(), folderId);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(inputStream);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)inputStream);
    }
}

