/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class GetFileAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
        try {
            long fileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryId");
            long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
            String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
            String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
            long fileShortcutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileShortcutId");
            String uuid = ParamUtil.getString((PortletRequest)actionRequest, (String)"uuid");
            String targetExtension = ParamUtil.getString((PortletRequest)actionRequest, (String)"targetExtension");
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId", (long)themeDisplay.getScopeGroupId());
            this.getFile(fileEntryId, folderId, title, version, fileShortcutId, uuid, groupId, targetExtension, themeDisplay, request, response);
            this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
        }
        catch (NoSuchFileEntryException nsfee) {
            PortalUtil.sendError((int)404, (Exception)((Object)nsfee), (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
        catch (PrincipalException pe) {
            this.processPrincipalException(pe, request, response);
        }
        catch (Exception e2) {
            PortalUtil.sendError((Exception)e2, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    public ActionForward strutsExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            long fileEntryId = ParamUtil.getLong((HttpServletRequest)request, (String)"fileEntryId");
            long folderId = ParamUtil.getLong((HttpServletRequest)request, (String)"folderId");
            String title = ParamUtil.getString((HttpServletRequest)request, (String)"title");
            String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
            long fileShortcutId = ParamUtil.getLong((HttpServletRequest)request, (String)"fileShortcutId");
            String uuid = ParamUtil.getString((HttpServletRequest)request, (String)"uuid");
            String targetExtension = ParamUtil.getString((HttpServletRequest)request, (String)"targetExtension");
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId", (long)themeDisplay.getScopeGroupId());
            this.getFile(fileEntryId, folderId, title, version, fileShortcutId, uuid, groupId, targetExtension, themeDisplay, request, response);
            return null;
        }
        catch (PrincipalException pe) {
            this.processPrincipalException(pe, request, response);
            return null;
        }
        catch (Exception e2) {
            PortalUtil.sendError((Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected void getFile(long fileEntryId, long folderId, String title, String version, long fileShortcutId, String uuid, long groupId, String targetExtension, ThemeDisplay themeDisplay, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FileEntry fileEntry = null;
        if (Validator.isNotNull((String)uuid) && groupId > 0L) {
            fileEntry = DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
            folderId = fileEntry.getFolderId();
        }
        if (fileEntryId > 0L) {
            fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
        } else if (fileShortcutId <= 0L) {
            if (Validator.isNotNull((String)title)) {
                fileEntry = DLAppServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)title);
            }
        } else {
            DLFileShortcut fileShortcut = DLAppServiceUtil.getFileShortcut((long)fileShortcutId);
            fileEntryId = fileShortcut.getToFileEntryId();
            fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
        }
        if (Validator.isNull((String)version)) {
            if (Validator.isNotNull((String)fileEntry.getVersion())) {
                version = fileEntry.getVersion();
            } else {
                throw new NoSuchFileEntryException();
            }
        }
        FileVersion fileVersion = fileEntry.getFileVersion(version);
        InputStream is = fileVersion.getContentStream(true);
        String fileName = fileVersion.getTitle();
        long contentLength = fileVersion.getSize();
        String contentType = fileVersion.getMimeType();
        if (Validator.isNotNull((String)targetExtension)) {
            File convertedFile;
            String id = DLUtil.getTempFileId((long)fileEntry.getFileEntryId(), (String)version);
            String sourceExtension = fileVersion.getExtension();
            if (!fileName.endsWith("." + sourceExtension)) {
                fileName = String.valueOf(fileName) + "." + sourceExtension;
            }
            if ((convertedFile = DocumentConversionUtil.convert(id, is, sourceExtension, targetExtension)) != null) {
                fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(targetExtension);
                is = new FileInputStream(convertedFile);
                contentLength = convertedFile.length();
                contentType = MimeTypesUtil.getContentType((String)fileName);
            }
        }
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)is, (long)contentLength, (String)contentType);
    }

    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected void processPrincipalException(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        long userId = permissionChecker.getUserId();
        User user = null;
        try {
            user = UserLocalServiceUtil.getUser((long)userId);
        }
        catch (Exception exception) {}
        if (user != null && !user.isDefaultUser()) {
            PortalUtil.sendError((int)401, (Exception)((Exception)t), (HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        String redirect = String.valueOf(request.getContextPath()) + "/c" + "/portal/login";
        String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
        redirect = HttpUtil.addParameter((String)redirect, (String)"redirect", (String)currentURL);
        response.sendRedirect(redirect);
    }
}

