/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.antivirus;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.documentlibrary.antivirus.AntivirusScannerException;
import com.liferay.portlet.documentlibrary.antivirus.BaseFileAntivirusScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ClamAntivirusScannerImpl
extends BaseFileAntivirusScanner {
    public void scan(File file) throws AntivirusScannerException, SystemException {
        Runtime runtime = Runtime.getRuntime();
        String filePath = file.getAbsolutePath();
        String[] parameters = new String[]{"clamscan", "--stdout", "--no-summary", filePath};
        Process process = null;
        try {
            try {
                process = runtime.exec(parameters);
                InputStream inputStream = process.getInputStream();
                String scanResult = StringUtil.read((InputStream)inputStream);
                process.waitFor();
                int exitValue = process.exitValue();
                if (exitValue != 0) {
                    throw new AntivirusScannerException("Unable to scan file due to inability to execute antivirus process");
                }
                if (scanResult.contains("FOUND")) {
                    throw new AntivirusScannerException("Virus detected in " + filePath);
                }
            }
            catch (IOException ioe) {
                throw new SystemException("Unable to scan file", (Throwable)ioe);
            }
            catch (InterruptedException ie) {
                throw new SystemException("Unable to scan file", (Throwable)ie);
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }
}

