/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.RepositoryEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RepositoryEntryLocalServiceUtil;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.RepositoryEntryUtil;
import com.liferay.portal.service.persistence.RepositoryUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.portlet.documentlibrary.lar.FolderUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileEntryTypeUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileRankUtil;
import com.liferay.portlet.documentlibrary.service.persistence.DLFileShortcutUtil;
import com.liferay.portlet.documentlibrary.util.DLProcessorRegistryUtil;
import com.liferay.portlet.documentlibrary.util.DLProcessorThreadLocal;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.lar.DDMPortletDataHandlerImpl;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.persistence.DDMStructureUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.util.PwdGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class DLPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final boolean _DATA_LOCALIZED = true;
    private static final String _NAMESPACE = "document_library";
    private static Log _log = LogFactoryUtil.getLog(DLPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _foldersAndDocuments = new PortletDataHandlerBoolean("document_library", "folders-and-documents", true, true);
    private static PortletDataHandlerControl[] _metadataControls = new PortletDataHandlerControl[]{new PortletDataHandlerBoolean("document_library", "categories"), new PortletDataHandlerBoolean("document_library", "comments"), new PortletDataHandlerBoolean("document_library", "ratings"), new PortletDataHandlerBoolean("document_library", "tags")};
    private static PortletDataHandlerBoolean _previewsAndThumbnails = new PortletDataHandlerBoolean("document_library", "previews-and-thumbnails");
    private static PortletDataHandlerBoolean _ranks = new PortletDataHandlerBoolean("document_library", "ranks");
    private static PortletDataHandlerBoolean _shortcuts = new PortletDataHandlerBoolean("document_library", "shortcuts");

    public static void exportFileEntry(PortletDataContext portletDataContext, Element fileEntryTypesElement, Element foldersElement, Element fileEntriesElement, Element fileRanksElement, Element repositoriesElement, Element repositoryEntriesElement, FileEntry fileEntry, boolean checkDateRange) throws Exception {
        if (checkDateRange && !portletDataContext.isWithinDateRange(fileEntry.getModifiedDate())) {
            return;
        }
        if (!fileEntry.isDefaultRepository()) {
            Repository repository = RepositoryUtil.findByPrimaryKey((long)fileEntry.getRepositoryId());
            DLPortletDataHandlerImpl.exportRepository(portletDataContext, repositoriesElement, repositoryEntriesElement, repository);
            return;
        }
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (fileVersion.getStatus() != 0) {
            return;
        }
        String path = DLPortletDataHandlerImpl.getFileEntryPath(portletDataContext, fileEntry);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element fileEntryElement = fileEntriesElement.addElement("file-entry");
        if (foldersElement != null) {
            DLPortletDataHandlerImpl.exportParentFolder(portletDataContext, fileEntryTypesElement, foldersElement, repositoriesElement, repositoryEntriesElement, fileEntry.getFolderId());
        }
        if (!portletDataContext.isPerformDirectBinaryImport()) {
            InputStream is = null;
            try {
                is = FileEntryUtil.getContentStream(fileEntry);
            }
            catch (NoSuchFileException noSuchFileException) {}
            if (is == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No file found for file entry " + fileEntry.getFileEntryId()));
                }
                fileEntryElement.detach();
                return;
            }
            try {
                String binPath = DLPortletDataHandlerImpl.getFileEntryBinPath(portletDataContext, fileEntry);
                portletDataContext.addZipEntry(binPath, is);
                fileEntryElement.addAttribute("bin-path", binPath);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    _log.error((Object)ioe, (Throwable)ioe);
                }
            }
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "ranks")) {
            List fileRanks = DLFileRankUtil.findByFileEntryId((long)fileEntry.getFileEntryId());
            for (DLFileRank fileRank : fileRanks) {
                DLPortletDataHandlerImpl.exportFileRank(portletDataContext, fileRanksElement, fileRank);
            }
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "previews-and-thumbnails")) {
            DLProcessorRegistryUtil.exportGeneratedFiles((PortletDataContext)portletDataContext, (FileEntry)fileEntry, (Element)fileEntryElement);
        }
        DLPortletDataHandlerImpl.exportMetaData(portletDataContext, fileEntryTypesElement, fileEntryElement, fileEntry);
        portletDataContext.addClassedModel(fileEntryElement, path, (ClassedModel)fileEntry, _NAMESPACE);
    }

    public static String getFileEntryPath(PortletDataContext portletDataContext, FileEntry fileEntry) {
        StringBundler sb = new StringBundler(6);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/file-entries/");
        sb.append(fileEntry.getFileEntryId());
        sb.append("/");
        sb.append(fileEntry.getVersion());
        sb.append(".xml");
        return sb.toString();
    }

    public static PortletDataHandlerControl[] getMetadataControls() {
        return _metadataControls;
    }

    public static String getRepositoryEntryPath(PortletDataContext portletDataContext, long repositoryEntryId) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/repository-entries/");
        sb.append(repositoryEntryId);
        sb.append(".xml");
        return sb.toString();
    }

    public static void importFileEntry(PortletDataContext portletDataContext, Element fileEntryElement) throws Exception {
        String path = fileEntryElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        boolean dlProcessorEnabled = DLProcessorThreadLocal.isEnabled();
        try {
            DLProcessorThreadLocal.setEnabled((boolean)false);
            DLPortletDataHandlerImpl.importFileEntry(portletDataContext, fileEntryElement, path);
        }
        finally {
            DLProcessorThreadLocal.setEnabled((boolean)dlProcessorEnabled);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void importFileEntry(PortletDataContext portletDataContext, Element fileEntryElement, String path) throws Exception {
        fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
        userId = portletDataContext.getUserId(fileEntry.getUserUuid());
        folderIds = portletDataContext.getNewPrimaryKeysMap(DLFolder.class);
        folderId = MapUtil.getLong((Map)folderIds, (long)fileEntry.getFolderId(), (long)fileEntry.getFolderId());
        assetCategoryIds = null;
        assetTagNames = null;
        if (portletDataContext.getBooleanParameter("document_library", "categories")) {
            assetCategoryIds = portletDataContext.getAssetCategoryIds(DLFileEntry.class, fileEntry.getFileEntryId());
        }
        if (portletDataContext.getBooleanParameter("document_library", "tags")) {
            assetTagNames = portletDataContext.getAssetTagNames(DLFileEntry.class, fileEntry.getFileEntryId());
        }
        serviceContext = portletDataContext.createServiceContext(fileEntryElement, (ClassedModel)fileEntry, "document_library");
        serviceContext.setAttribute("sourceFileName", (Serializable)("A." + fileEntry.getExtension()));
        serviceContext.setUserId(userId);
        binPath = fileEntryElement.attributeValue("bin-path");
        is = null;
        if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
            try {
                is = FileEntryUtil.getContentStream(fileEntry);
            }
            catch (NoSuchFileException v0) {}
        } else {
            is = portletDataContext.getZipEntryAsInputStream(binPath);
        }
        if (is == null) {
            if (DLPortletDataHandlerImpl._log.isWarnEnabled()) {
                DLPortletDataHandlerImpl._log.warn((Object)("No file found for file entry " + fileEntry.getFileEntryId()));
            }
            return;
        }
        if (folderId != 0L && folderId == fileEntry.getFolderId()) {
            folderPath = DLPortletDataHandlerImpl.getImportFolderPath(portletDataContext, folderId);
            folder = (Folder)portletDataContext.getZipEntryAsObject(folderPath);
            document = fileEntryElement.getDocument();
            rootElement = document.getRootElement();
            folderElement = (Element)rootElement.selectSingleNode("//folder[@path='".concat(folderPath).concat("']"));
            DLPortletDataHandlerImpl.importFolder(portletDataContext, folderPath, folderElement, folder);
            folderId = MapUtil.getLong((Map)folderIds, (long)fileEntry.getFolderId(), (long)fileEntry.getFolderId());
        }
        DLPortletDataHandlerImpl.importMetaData(portletDataContext, fileEntryElement, serviceContext);
        importedFileEntry = null;
        titleWithExtension = DLUtil.getTitleWithExtension((FileEntry)fileEntry);
        extension = fileEntry.getExtension();
        dotExtension = "." + extension;
        if (portletDataContext.isDataStrategyMirror()) {
            existingFileEntry = FileEntryUtil.fetchByUUID_R(fileEntry.getUuid(), portletDataContext.getScopeGroupId());
            fileVersion = fileEntry.getFileVersion();
            if (existingFileEntry == null) {
                fileEntryTitle = fileEntry.getTitle();
                existingTitleFileEntry = FileEntryUtil.fetchByR_F_T(portletDataContext.getScopeGroupId(), folderId, fileEntryTitle);
                if (existingTitleFileEntry != null) {
                    if (fileEntry.getGroupId() == portletDataContext.getSourceGroupId() && portletDataContext.isDataStrategyMirrorWithOverwriting()) {
                        DLAppLocalServiceUtil.deleteFileEntry((long)existingTitleFileEntry.getFileEntryId());
                    } else {
                        titleHasExtension = false;
                        if (fileEntryTitle.endsWith(dotExtension)) {
                            fileEntryTitle = FileUtil.stripExtension((String)fileEntryTitle);
                            titleHasExtension = true;
                        }
                        i = 1;
                        while (true) {
                            fileEntryTitle = String.valueOf(fileEntryTitle) + " " + i;
                            titleWithExtension = String.valueOf(fileEntryTitle) + dotExtension;
                            existingTitleFileEntry = FileEntryUtil.fetchByR_F_T(portletDataContext.getScopeGroupId(), folderId, titleWithExtension);
                            if (existingTitleFileEntry == null) {
                                if (!titleHasExtension) break;
                                fileEntryTitle = String.valueOf(fileEntryTitle) + dotExtension;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                serviceContext.setAttribute("fileVersionUuid", (Serializable)fileVersion.getUuid());
                serviceContext.setUuid(fileEntry.getUuid());
                importedFileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)titleWithExtension, (String)fileEntry.getMimeType(), (String)fileEntryTitle, (String)fileEntry.getDescription(), null, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            } else {
                latestExistingFileVersion = existingFileEntry.getLatestFileVersion();
                indexEnabled = serviceContext.isIndexingEnabled();
                try {
                    serviceContext.setIndexingEnabled(false);
                    if (!fileVersion.getUuid().equals(latestExistingFileVersion.getUuid())) {
                        alreadyExistingFileVersion = DLFileVersionLocalServiceUtil.getFileVersionByUuidAndGroupId((String)fileVersion.getUuid(), (long)existingFileEntry.getGroupId());
                        if (alreadyExistingFileVersion != null) {
                            serviceContext.setAttribute("existingDLFileVersionId", (Serializable)Long.valueOf(alreadyExistingFileVersion.getFileVersionId()));
                        }
                        serviceContext.setUuid(fileVersion.getUuid());
                        importedFileEntry = DLAppLocalServiceUtil.updateFileEntry((long)userId, (long)existingFileEntry.getFileEntryId(), (String)fileEntry.getTitle(), (String)fileEntry.getMimeType(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), null, (boolean)false, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
                    } else {
                        DLAppLocalServiceUtil.updateAsset((long)userId, (FileEntry)existingFileEntry, (FileVersion)latestExistingFileVersion, (long[])assetCategoryIds, (String[])assetTagNames, null);
                        importedFileEntry = existingFileEntry;
                    }
                    if (importedFileEntry.getFolderId() != folderId) {
                        importedFileEntry = DLAppLocalServiceUtil.moveFileEntry((long)userId, (long)importedFileEntry.getFileEntryId(), (long)folderId, (ServiceContext)serviceContext);
                    }
                    if (!(importedFileEntry instanceof LiferayFileEntry)) ** GOTO lbl104
                    liferayFileEntry = (LiferayFileEntry)importedFileEntry;
                    indexer = IndexerRegistryUtil.getIndexer(DLFileEntry.class);
                    indexer.reindex(liferayFileEntry.getModel());
                }
                finally {
                    serviceContext.setIndexingEnabled(indexEnabled);
                }
            }
        } else {
            try {
                importedFileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)titleWithExtension, (String)fileEntry.getMimeType(), (String)fileEntry.getTitle(), (String)fileEntry.getDescription(), null, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            }
            catch (DuplicateFileException v1) {
                title = fileEntry.getTitle();
                titleParts = title.split("\\.", 2);
                title = String.valueOf(titleParts[0]) + PwdGenerator.getPassword();
                if (titleParts.length > 1) {
                    title = String.valueOf(title) + "." + titleParts[1];
                }
                if (!title.endsWith(dotExtension)) {
                    title = String.valueOf(title) + dotExtension;
                }
                importedFileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (String)title, (String)fileEntry.getMimeType(), (String)title, (String)fileEntry.getDescription(), null, (InputStream)is, (long)fileEntry.getSize(), (ServiceContext)serviceContext);
            }
        }
lbl104:
        // 5 sources

        if (portletDataContext.getBooleanParameter("document_library", "previews-and-thumbnails")) {
            DLProcessorRegistryUtil.importGeneratedFiles((PortletDataContext)portletDataContext, (FileEntry)fileEntry, (FileEntry)importedFileEntry, (Element)fileEntryElement);
        }
        fileEntryTitles = portletDataContext.getNewPrimaryKeysMap(String.valueOf(DLFileEntry.class.getName()) + ".title");
        fileEntryTitles.put(fileEntry.getTitle(), importedFileEntry.getTitle());
        portletDataContext.importClassedModel((ClassedModel)fileEntry, (ClassedModel)importedFileEntry, "document_library");
    }

    public static void importFileRank(PortletDataContext portletDataContext, Element fileRankElement) throws Exception {
        String path = fileRankElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        DLFileRank fileRank = (DLFileRank)portletDataContext.getZipEntryAsObject(path);
        String fileEntryUuid = fileRankElement.attributeValue("file-entry-uuid");
        DLPortletDataHandlerImpl.importFileRank(portletDataContext, fileRank, fileEntryUuid);
    }

    public static void importFolder(PortletDataContext portletDataContext, Element folderElement) throws Exception {
        String path = folderElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Folder folder = (Folder)portletDataContext.getZipEntryAsObject(path);
        DLPortletDataHandlerImpl.importFolder(portletDataContext, path, folderElement, folder);
    }

    public static void importRepository(PortletDataContext portletDataContext, Element repositoryElement) throws Exception {
        long importedRepositoryId;
        Repository repository;
        block7: {
            String path = repositoryElement.attributeValue("path");
            if (!portletDataContext.isPathNotProcessed(path)) {
                return;
            }
            repository = (Repository)portletDataContext.getZipEntryAsObject(path);
            long userId = portletDataContext.getUserId(repository.getUserUuid());
            long classNameId = PortalUtil.getClassNameId((String)repositoryElement.attributeValue("class-name"));
            ServiceContext serviceContext = portletDataContext.createServiceContext(repositoryElement, (ClassedModel)repository, _NAMESPACE);
            importedRepositoryId = 0L;
            try {
                if (portletDataContext.isDataStrategyMirror()) {
                    Repository existingRepository = RepositoryUtil.fetchByUUID_G((String)repository.getUuid(), (long)portletDataContext.getScopeGroupId());
                    if (existingRepository == null) {
                        serviceContext.setUuid(repository.getUuid());
                        importedRepositoryId = RepositoryLocalServiceUtil.addRepository((long)userId, (long)portletDataContext.getScopeGroupId(), (long)classNameId, (long)0L, (String)repository.getName(), (String)repository.getDescription(), (String)repository.getPortletId(), (UnicodeProperties)repository.getTypeSettingsProperties(), (ServiceContext)serviceContext);
                    } else {
                        RepositoryLocalServiceUtil.updateRepository((long)existingRepository.getRepositoryId(), (String)repository.getName(), (String)repository.getDescription());
                        importedRepositoryId = existingRepository.getRepositoryId();
                    }
                } else {
                    importedRepositoryId = RepositoryLocalServiceUtil.addRepository((long)userId, (long)portletDataContext.getScopeGroupId(), (long)classNameId, (long)0L, (String)repository.getName(), (String)repository.getDescription(), (String)repository.getPortletId(), (UnicodeProperties)repository.getTypeSettingsProperties(), (ServiceContext)serviceContext);
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block7;
                _log.warn((Object)("Unable to connect to repository {name=" + repository.getName() + ", typeSettings=" + repository.getTypeSettingsProperties() + "}"), (Throwable)e2);
            }
        }
        Repository importedRepository = RepositoryLocalServiceUtil.getRepository((long)importedRepositoryId);
        portletDataContext.importClassedModel((ClassedModel)repository, (ClassedModel)importedRepository, _NAMESPACE);
    }

    public static void importRepositoryEntry(PortletDataContext portletDataContext, Element repositoryEntryElement) throws Exception {
        String path = repositoryEntryElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        RepositoryEntry repositoryEntry = (RepositoryEntry)portletDataContext.getZipEntryAsObject(path);
        Map repositoryIds = portletDataContext.getNewPrimaryKeysMap(Repository.class);
        long repositoryId = MapUtil.getLong((Map)repositoryIds, (long)repositoryEntry.getRepositoryId(), (long)repositoryEntry.getRepositoryId());
        ServiceContext serviceContext = portletDataContext.createServiceContext(repositoryEntryElement, (ClassedModel)repositoryEntry, _NAMESPACE);
        RepositoryEntry importedRepositoryEntry = null;
        if (portletDataContext.isDataStrategyMirror()) {
            RepositoryEntry existingRepositoryEntry = RepositoryEntryUtil.fetchByUUID_G((String)repositoryEntry.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingRepositoryEntry == null) {
                serviceContext.setUuid(repositoryEntry.getUuid());
                importedRepositoryEntry = RepositoryEntryLocalServiceUtil.addRepositoryEntry((long)portletDataContext.getScopeGroupId(), (long)repositoryId, (String)repositoryEntry.getMappedId(), (ServiceContext)serviceContext);
            } else {
                importedRepositoryEntry = RepositoryEntryLocalServiceUtil.updateRepositoryEntry((long)existingRepositoryEntry.getRepositoryEntryId(), (String)repositoryEntry.getMappedId());
            }
        } else {
            importedRepositoryEntry = RepositoryEntryLocalServiceUtil.addRepositoryEntry((long)portletDataContext.getScopeGroupId(), (long)repositoryId, (String)repositoryEntry.getMappedId(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)repositoryEntry, (ClassedModel)importedRepositoryEntry, _NAMESPACE);
    }

    public String[] getDataPortletPreferences() {
        return new String[]{"rootFolderId"};
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_foldersAndDocuments, _shortcuts, _previewsAndThumbnails, _ranks};
    }

    public PortletDataHandlerControl[] getExportMetadataControls() {
        return new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(_NAMESPACE, "folders-and-documents", true, _metadataControls)};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_foldersAndDocuments, _shortcuts, _previewsAndThumbnails, _ranks};
    }

    public PortletDataHandlerControl[] getImportMetadataControls() {
        return new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(_NAMESPACE, "folders-and-documents", true, _metadataControls)};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isDataLocalized() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return PropsValues.DL_PUBLISH_TO_LIVE_BY_DEFAULT;
    }

    protected static void exportFileEntryType(PortletDataContext portletDataContext, Element fileEntryTypesElement, DLFileEntryType dlFileEntryType) throws Exception {
        String path = DLPortletDataHandlerImpl.getFileEntryTypePath(portletDataContext, dlFileEntryType);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element fileEntryTypeElement = fileEntryTypesElement.addElement("file-entry-type");
        List ddmStructures = dlFileEntryType.getDDMStructures();
        Object[] ddmStructureUuids = new String[ddmStructures.size()];
        int i2 = 0;
        while (i2 < ddmStructures.size()) {
            DDMStructure ddmStructure = (DDMStructure)ddmStructures.get(i2);
            ddmStructureUuids[i2] = ddmStructure.getUuid();
            DDMPortletDataHandlerImpl.exportStructure(portletDataContext, fileEntryTypeElement, ddmStructure);
            ++i2;
        }
        fileEntryTypeElement.addAttribute("structureUuids", StringUtil.merge((Object[])ddmStructureUuids));
        portletDataContext.addClassedModel(fileEntryTypeElement, path, (ClassedModel)dlFileEntryType, _NAMESPACE);
    }

    protected static void exportFileRank(PortletDataContext portletDataContext, Element fileRanksElement, DLFileRank fileRank) throws Exception {
        String path = DLPortletDataHandlerImpl.getFileRankPath(portletDataContext, fileRank);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element fileRankElement = fileRanksElement.addElement("file-rank");
        FileEntry fileEntry = FileEntryUtil.fetchByPrimaryKey(fileRank.getFileEntryId());
        String fileEntryUuid = fileEntry.getUuid();
        fileRankElement.addAttribute("file-entry-uuid", fileEntryUuid);
        portletDataContext.addClassedModel(fileRankElement, path, (ClassedModel)fileRank, _NAMESPACE);
    }

    protected static void exportFileShortcut(PortletDataContext portletDataContext, Element fileEntryTypesElement, Element foldersElement, Element fileShortcutsElement, Element repositoriesElement, Element repositoryEntriesElement, DLFileShortcut fileShortcut) throws Exception {
        if (!portletDataContext.isWithinDateRange(fileShortcut.getModifiedDate())) {
            return;
        }
        DLPortletDataHandlerImpl.exportParentFolder(portletDataContext, fileEntryTypesElement, foldersElement, repositoriesElement, repositoryEntriesElement, fileShortcut.getFolderId());
        String path = DLPortletDataHandlerImpl.getFileShortcutPath(portletDataContext, fileShortcut);
        if (portletDataContext.isPathNotProcessed(path)) {
            Element fileShortcutElement = fileShortcutsElement.addElement("file-shortcut");
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileShortcut.getToFileEntryId());
            String fileEntryUuid = fileEntry.getUuid();
            fileShortcutElement.addAttribute("file-entry-uuid", fileEntryUuid);
            portletDataContext.addClassedModel(fileShortcutElement, path, (ClassedModel)fileShortcut, _NAMESPACE);
        }
    }

    protected static void exportFolder(PortletDataContext portletDataContext, Element fileEntryTypesElement, Element foldersElement, Element fileEntriesElement, Element fileShortcutsElement, Element fileRanksElement, Element repositoriesElement, Element repositoryEntriesElement, Folder folder, boolean recurse) throws Exception {
        if (!portletDataContext.isWithinDateRange(folder.getModifiedDate())) {
            return;
        }
        if (folder.isMountPoint()) {
            Repository repository = RepositoryUtil.findByPrimaryKey((long)folder.getRepositoryId());
            DLPortletDataHandlerImpl.exportRepository(portletDataContext, repositoriesElement, repositoryEntriesElement, repository);
            return;
        }
        if (!folder.isDefaultRepository()) {
            return;
        }
        DLPortletDataHandlerImpl.exportParentFolder(portletDataContext, fileEntryTypesElement, foldersElement, repositoriesElement, repositoryEntriesElement, folder.getParentFolderId());
        String path = DLPortletDataHandlerImpl.getFolderPath(portletDataContext, folder);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element folderElement = foldersElement.addElement("folder");
        DLPortletDataHandlerImpl.exportFolderFileEntryTypes(portletDataContext, folder, fileEntryTypesElement, folderElement);
        portletDataContext.addClassedModel(folderElement, path, (ClassedModel)folder, _NAMESPACE);
        if (recurse) {
            List<Folder> folders = FolderUtil.findByR_P(folder.getRepositoryId(), folder.getFolderId());
            for (Folder curFolder : folders) {
                DLPortletDataHandlerImpl.exportFolder(portletDataContext, fileEntryTypesElement, foldersElement, fileEntriesElement, fileShortcutsElement, fileRanksElement, repositoriesElement, repositoryEntriesElement, curFolder, recurse);
            }
        }
        List<FileEntry> fileEntries = FileEntryUtil.findByR_F(folder.getRepositoryId(), folder.getFolderId());
        for (FileEntry fileEntry : fileEntries) {
            DLPortletDataHandlerImpl.exportFileEntry(portletDataContext, fileEntryTypesElement, foldersElement, fileEntriesElement, fileRanksElement, repositoriesElement, repositoryEntriesElement, fileEntry, true);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "shortcuts")) {
            List fileShortcuts = DLFileShortcutUtil.findByG_F((long)folder.getRepositoryId(), (long)folder.getFolderId());
            for (DLFileShortcut fileShortcut : fileShortcuts) {
                DLPortletDataHandlerImpl.exportFileShortcut(portletDataContext, fileEntryTypesElement, foldersElement, fileShortcutsElement, repositoriesElement, repositoryEntriesElement, fileShortcut);
            }
        }
    }

    protected static void exportFolderFileEntryTypes(PortletDataContext portletDataContext, Folder folder, Element fileEntryTypesElement, Element folderElement) throws Exception {
        List dlFileEntryTypes = DLFileEntryTypeLocalServiceUtil.getFolderFileEntryTypes((long[])new long[]{portletDataContext.getScopeGroupId()}, (long)folder.getFolderId(), (boolean)false);
        Object[] fileEntryTypeUuids = new String[dlFileEntryTypes.size()];
        long defaultFileEntryTypeId = DLFileEntryTypeLocalServiceUtil.getDefaultFileEntryTypeId((long)folder.getFolderId());
        String defaultFileEntryTypeUuid = "";
        int i2 = 0;
        while (i2 < dlFileEntryTypes.size()) {
            DLFileEntryType dlFileEntryType = (DLFileEntryType)dlFileEntryTypes.get(i2);
            if (DLPortletDataHandlerImpl.isFileEntryTypeExportable(portletDataContext.getCompanyId(), dlFileEntryType)) {
                fileEntryTypeUuids[i2] = dlFileEntryType.getUuid();
                if (defaultFileEntryTypeId == dlFileEntryType.getFileEntryTypeId()) {
                    defaultFileEntryTypeUuid = dlFileEntryType.getUuid();
                }
                DLPortletDataHandlerImpl.exportFileEntryType(portletDataContext, fileEntryTypesElement, dlFileEntryType);
            }
            ++i2;
        }
        folderElement.addAttribute("fileEntryTypeUuids", StringUtil.merge((Object[])fileEntryTypeUuids));
        folderElement.addAttribute("defaultFileEntryTypeUuid", defaultFileEntryTypeUuid);
    }

    protected static void exportMetaData(PortletDataContext portletDataContext, Element fileEntryTypesElement, Element fileEntryElement, FileEntry fileEntry) throws Exception {
        if (!(fileEntry instanceof LiferayFileEntry)) {
            return;
        }
        LiferayFileEntry liferayFileEntry = (LiferayFileEntry)fileEntry;
        DLFileEntry dlFileEntry = liferayFileEntry.getDLFileEntry();
        long fileEntryTypeId = dlFileEntry.getFileEntryTypeId();
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchFileEntryType((long)fileEntryTypeId);
        if (dlFileEntryType == null) {
            return;
        }
        fileEntryElement.addAttribute("fileEntryTypeUuid", dlFileEntryType.getUuid());
        if (!DLPortletDataHandlerImpl.isFileEntryTypeExportable(portletDataContext.getCompanyId(), dlFileEntryType)) {
            return;
        }
        DLPortletDataHandlerImpl.exportFileEntryType(portletDataContext, fileEntryTypesElement, dlFileEntryType);
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            Element structureFields = fileEntryElement.addElement("structure-fields");
            String path = DLPortletDataHandlerImpl.getFileEntryFileEntryTypeStructureFieldsPath(portletDataContext, fileEntry, dlFileEntryType.getUuid(), ddmStructure.getStructureId());
            structureFields.addAttribute("path", path);
            structureFields.addAttribute("structureUuid", ddmStructure.getUuid());
            FileVersion fileVersion = fileEntry.getFileVersion();
            DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadata((long)ddmStructure.getStructureId(), (long)fileVersion.getFileVersionId());
            Fields fields = StorageEngineUtil.getFields((long)dlFileEntryMetadata.getDDMStorageId());
            portletDataContext.addZipEntry(path, (Object)fields);
        }
    }

    protected static void exportParentFolder(PortletDataContext portletDataContext, Element fileEntryTypesElement, Element foldersElement, Element repositoriesElement, Element repositoryEntriesElement, long folderId) throws Exception {
        if (folderId == 0L) {
            return;
        }
        Folder folder = DLAppLocalServiceUtil.getFolder((long)folderId);
        if (folder.isMountPoint()) {
            Repository repository = RepositoryUtil.findByPrimaryKey((long)folder.getRepositoryId());
            DLPortletDataHandlerImpl.exportRepository(portletDataContext, repositoriesElement, repositoryEntriesElement, repository);
            return;
        }
        if (!folder.isDefaultRepository()) {
            return;
        }
        DLPortletDataHandlerImpl.exportParentFolder(portletDataContext, fileEntryTypesElement, foldersElement, repositoriesElement, repositoryEntriesElement, folder.getParentFolderId());
        String path = DLPortletDataHandlerImpl.getFolderPath(portletDataContext, folder);
        if (portletDataContext.isPathNotProcessed(path)) {
            Element folderElement = foldersElement.addElement("folder");
            DLPortletDataHandlerImpl.exportFolderFileEntryTypes(portletDataContext, folder, fileEntryTypesElement, folderElement);
            portletDataContext.addClassedModel(folderElement, path, (ClassedModel)folder, _NAMESPACE);
        }
    }

    protected static void exportRepository(PortletDataContext portletDataContext, Element repositoriesElement, Element repositoryEntriesElement, Repository repository) throws Exception {
        if (!portletDataContext.isWithinDateRange(repository.getModifiedDate())) {
            return;
        }
        String path = DLPortletDataHandlerImpl.getRepositoryPath(portletDataContext, repository);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element repositoryElement = repositoriesElement.addElement("repository");
        repositoryElement.addAttribute("class-name", repository.getClassName());
        portletDataContext.addClassedModel(repositoryElement, path, (ClassedModel)repository, _NAMESPACE);
        List repositoryEntries = RepositoryEntryUtil.findByRepositoryId((long)repository.getRepositoryId());
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            DLPortletDataHandlerImpl.exportRepositoryEntry(portletDataContext, repositoryEntriesElement, repositoryEntry);
        }
    }

    protected static void exportRepositoryEntry(PortletDataContext portletDataContext, Element repositoryEntriesElement, RepositoryEntry repositoryEntry) throws Exception {
        String path = DLPortletDataHandlerImpl.getRepositoryEntryPath(portletDataContext, repositoryEntry);
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        Element repositoryEntryElement = repositoryEntriesElement.addElement("repository-entry");
        portletDataContext.addClassedModel(repositoryEntryElement, path, (ClassedModel)repositoryEntry, _NAMESPACE);
    }

    protected static String getFileEntryBinPath(PortletDataContext portletDataContext, FileEntry fileEntry) {
        StringBundler sb = new StringBundler(5);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/bin/");
        sb.append(fileEntry.getFileEntryId());
        sb.append("/");
        sb.append(fileEntry.getVersion());
        return sb.toString();
    }

    protected static String getFileEntryFileEntryTypeStructureFieldsPath(PortletDataContext portletDataContext, FileEntry fileEntry, String fileEntryTypeUuid, long structureId) {
        StringBundler sb = new StringBundler(4);
        String fileEntryPath = DLPortletDataHandlerImpl.getFileEntryPath(portletDataContext, fileEntry);
        sb.append(StringUtil.replace((String)fileEntryPath, (String)".xml", (String)""));
        sb.append("/file-entry-type/");
        sb.append(fileEntryTypeUuid);
        sb.append("/structure-fields/");
        sb.append(structureId);
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFileEntryTypeName(String uuid, long groupId, String name, int count) throws Exception {
        DLFileEntryType dlFileEntryType = DLFileEntryTypeUtil.fetchByG_N((long)groupId, (String)name);
        if (dlFileEntryType == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(dlFileEntryType.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return DLPortletDataHandlerImpl.getFileEntryTypeName(uuid, groupId, name, ++count);
    }

    protected static String getFileEntryTypePath(PortletDataContext portletDataContext, DLFileEntryType dlFileEntryType) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/entry-types/");
        sb.append(dlFileEntryType.getFileEntryTypeId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFileRankPath(PortletDataContext portletDataContext, DLFileRank fileRank) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/ranks/");
        sb.append(fileRank.getFileRankId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFileShortcutPath(PortletDataContext portletDataContext, DLFileShortcut fileShortcut) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/shortcuts/");
        sb.append(fileShortcut.getFileShortcutId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getFolderName(String uuid, long groupId, long parentFolderId, String name, int count) throws Exception {
        Folder folder = FolderUtil.fetchByR_P_N(groupId, parentFolderId, name);
        if (folder == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(folder.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return DLPortletDataHandlerImpl.getFolderName(uuid, groupId, parentFolderId, name, ++count);
    }

    protected static String getFolderPath(PortletDataContext portletDataContext, Folder folder) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/folders/");
        sb.append(folder.getFolderId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getImportFolderPath(PortletDataContext portletDataContext, long folderId) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getSourcePortletPath("20"));
        sb.append("/folders/");
        sb.append(folderId);
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getRepositoryEntryPath(PortletDataContext portletDataContext, RepositoryEntry repositoryEntry) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/repository-entries/");
        sb.append(repositoryEntry.getRepositoryEntryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getRepositoryPath(PortletDataContext portletDataContext, Repository repository) {
        StringBundler sb = new StringBundler(4);
        sb.append(portletDataContext.getPortletPath("20"));
        sb.append("/repositories/");
        sb.append(repository.getRepositoryId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static void importFileEntryType(PortletDataContext portletDataContext, Element fileEntryTypeElement) throws Exception {
        String path = fileEntryTypeElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        DLFileEntryType dlFileEntryType = (DLFileEntryType)portletDataContext.getZipEntryAsObject(path);
        long userId = portletDataContext.getUserId(dlFileEntryType.getUserUuid());
        String name = DLPortletDataHandlerImpl.getFileEntryTypeName(dlFileEntryType.getUuid(), portletDataContext.getScopeGroupId(), dlFileEntryType.getName(), 2);
        List structureElements = fileEntryTypeElement.elements("structure");
        for (Element structureElement : structureElements) {
            DDMPortletDataHandlerImpl.importStructure(portletDataContext, structureElement);
        }
        String[] ddmStructureUuids = StringUtil.split((String)fileEntryTypeElement.attributeValue("structureUuids"));
        long[] ddmStrutureIds = new long[ddmStructureUuids.length];
        int i2 = 0;
        while (i2 < ddmStructureUuids.length) {
            DDMStructure existingStructure = DDMStructureUtil.fetchByUUID_G((String)ddmStructureUuids[i2], (long)portletDataContext.getScopeGroupId());
            ddmStrutureIds[i2] = existingStructure.getStructureId();
            ++i2;
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext(path, (ClassedModel)dlFileEntryType, _NAMESPACE);
        DLFileEntryType importedDLFileEntryType = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DLFileEntryType existingDLFileEntryType = DLFileEntryTypeUtil.fetchByUUID_G((String)dlFileEntryType.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingDLFileEntryType == null) {
                serviceContext.setUuid(dlFileEntryType.getUuid());
                importedDLFileEntryType = DLFileEntryTypeLocalServiceUtil.addFileEntryType((long)userId, (long)portletDataContext.getScopeGroupId(), (String)name, (String)dlFileEntryType.getDescription(), (long[])ddmStrutureIds, (ServiceContext)serviceContext);
            } else {
                DLFileEntryTypeLocalServiceUtil.updateFileEntryType((long)userId, (long)existingDLFileEntryType.getFileEntryTypeId(), (String)name, (String)dlFileEntryType.getDescription(), (long[])ddmStrutureIds, (ServiceContext)serviceContext);
                importedDLFileEntryType = existingDLFileEntryType;
            }
        } else {
            importedDLFileEntryType = DLFileEntryTypeLocalServiceUtil.addFileEntryType((long)userId, (long)portletDataContext.getScopeGroupId(), (String)name, (String)dlFileEntryType.getDescription(), (long[])ddmStrutureIds, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)dlFileEntryType, (ClassedModel)importedDLFileEntryType, _NAMESPACE);
        String importedDLFileEntryDDMStructureKey = DLUtil.getDDMStructureKey((DLFileEntryType)importedDLFileEntryType);
        List ddmStructures = importedDLFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            String ddmStructureKey = ddmStructure.getStructureKey();
            if (!DLUtil.isAutoGeneratedDLFileEntryTypeDDMStructureKey((String)ddmStructureKey) || ddmStructureKey.equals(importedDLFileEntryDDMStructureKey)) continue;
            ddmStructure.setStructureKey(importedDLFileEntryDDMStructureKey);
            DDMStructureLocalServiceUtil.updateDDMStructure((DDMStructure)ddmStructure);
        }
    }

    protected static void importFileRank(PortletDataContext portletDataContext, DLFileRank fileRank, String fileEntryUuid) throws Exception {
        long userId = portletDataContext.getUserId(fileRank.getUserUuid());
        long groupId = portletDataContext.getScopeGroupId();
        FileEntry fileEntry = FileEntryUtil.fetchByUUID_R(fileEntryUuid, groupId);
        if (fileEntry == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to retrieve file " + fileEntryUuid + " to import file rank"));
            }
            return;
        }
        long fileEntryId = fileEntry.getFileEntryId();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCreateDate(fileRank.getCreateDate());
        DLAppLocalServiceUtil.updateFileRank((long)portletDataContext.getScopeGroupId(), (long)portletDataContext.getCompanyId(), (long)userId, (long)fileEntryId, (ServiceContext)serviceContext);
    }

    protected static void importFileShortcut(PortletDataContext portletDataContext, Element fileShortcutElement) throws Exception {
        String path = fileShortcutElement.attributeValue("path");
        if (!portletDataContext.isPathNotProcessed(path)) {
            return;
        }
        DLFileShortcut fileShortcut = (DLFileShortcut)portletDataContext.getZipEntryAsObject(path);
        DLPortletDataHandlerImpl.importFileShortcut(portletDataContext, fileShortcutElement, fileShortcut);
    }

    protected static void importFileShortcut(PortletDataContext portletDataContext, Element fileShortcutElement, DLFileShortcut fileShortcut) throws Exception {
        String fileEntryUuid;
        FileEntry fileEntry;
        long userId = portletDataContext.getUserId(fileShortcut.getUserUuid());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(DLFolder.class);
        long folderId = MapUtil.getLong((Map)folderIds, (long)fileShortcut.getFolderId(), (long)fileShortcut.getFolderId());
        long groupId = portletDataContext.getScopeGroupId();
        if (folderId != 0L) {
            Folder folder = FolderUtil.findByPrimaryKey(folderId);
            groupId = folder.getRepositoryId();
        }
        if ((fileEntry = FileEntryUtil.fetchByUUID_R(fileEntryUuid = fileShortcutElement.attributeValue("file-entry-uuid"), groupId)) == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to fetch file entry {uuid=" + fileEntryUuid + ", groupId=" + groupId + "}"));
            }
            return;
        }
        long fileEntryId = fileEntry.getFileEntryId();
        ServiceContext serviceContext = portletDataContext.createServiceContext(fileShortcutElement, (ClassedModel)fileShortcut, _NAMESPACE);
        DLFileShortcut importedFileShortcut = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DLFileShortcut existingFileShortcut = DLFileShortcutUtil.fetchByUUID_G((String)fileShortcut.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingFileShortcut == null) {
                serviceContext.setUuid(fileShortcut.getUuid());
                importedFileShortcut = DLAppLocalServiceUtil.addFileShortcut((long)userId, (long)groupId, (long)folderId, (long)fileEntryId, (ServiceContext)serviceContext);
            } else {
                importedFileShortcut = DLAppLocalServiceUtil.updateFileShortcut((long)userId, (long)existingFileShortcut.getFileShortcutId(), (long)folderId, (long)fileEntryId, (ServiceContext)serviceContext);
            }
        } else {
            importedFileShortcut = DLAppLocalServiceUtil.addFileShortcut((long)userId, (long)groupId, (long)folderId, (long)fileEntryId, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)fileShortcut, (ClassedModel)importedFileShortcut, _NAMESPACE);
    }

    protected static void importFolder(PortletDataContext portletDataContext, String folderPath, Element folderElement, Folder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(DLFolder.class);
        long parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext(folderPath, (ClassedModel)folder, _NAMESPACE);
        if (parentFolderId != 0L && parentFolderId == folder.getParentFolderId()) {
            String path = DLPortletDataHandlerImpl.getImportFolderPath(portletDataContext, parentFolderId);
            Folder parentFolder = (Folder)portletDataContext.getZipEntryAsObject(path);
            DLPortletDataHandlerImpl.importFolder(portletDataContext, path, folderElement, parentFolder);
            parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        }
        Folder importedFolder = null;
        if (portletDataContext.isDataStrategyMirror()) {
            Folder existingFolder = FolderUtil.fetchByUUID_R(folder.getUuid(), portletDataContext.getScopeGroupId());
            if (existingFolder == null) {
                String name = DLPortletDataHandlerImpl.getFolderName(null, portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                serviceContext.setUuid(folder.getUuid());
                importedFolder = DLAppLocalServiceUtil.addFolder((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                String name = DLPortletDataHandlerImpl.getFolderName(folder.getUuid(), portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                importedFolder = DLAppLocalServiceUtil.updateFolder((long)existingFolder.getFolderId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            }
        } else {
            String name = DLPortletDataHandlerImpl.getFolderName(null, portletDataContext.getScopeGroupId(), parentFolderId, folder.getName(), 2);
            importedFolder = DLAppLocalServiceUtil.addFolder((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        DLPortletDataHandlerImpl.importFolderFileEntryTypes(portletDataContext, folderElement, importedFolder, serviceContext);
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder, _NAMESPACE);
    }

    protected static void importFolderFileEntryTypes(PortletDataContext portletDataContext, Element folderElement, Folder folder, ServiceContext serviceContext) throws Exception {
        String[] fileEntryTypeUuids = StringUtil.split((String)folderElement.attributeValue("fileEntryTypeUuids"));
        ArrayList<Long> fileEntryTypeIds = new ArrayList<Long>();
        String defaultFileEntryTypeUuid = GetterUtil.getString((String)folderElement.attributeValue("defaultFileEntryTypeUuid"));
        long defaultFileEntryTypeId = 0L;
        String[] stringArray = fileEntryTypeUuids;
        int n = fileEntryTypeUuids.length;
        int n2 = 0;
        while (n2 < n) {
            String fileEntryTypeUuid = stringArray[n2];
            DLFileEntryType dlFileEntryType = DLFileEntryTypeUtil.fetchByUUID_G((String)fileEntryTypeUuid, (long)portletDataContext.getScopeGroupId());
            if (dlFileEntryType != null) {
                fileEntryTypeIds.add(dlFileEntryType.getFileEntryTypeId());
                if (defaultFileEntryTypeUuid.equals(dlFileEntryType.getUuid())) {
                    defaultFileEntryTypeId = dlFileEntryType.getFileEntryTypeId();
                }
            }
            ++n2;
        }
        DLFileEntryTypeLocalServiceUtil.updateFolderFileEntryTypes((DLFolder)((DLFolder)folder.getModel()), fileEntryTypeIds, (long)defaultFileEntryTypeId, (ServiceContext)serviceContext);
    }

    protected static void importMetaData(PortletDataContext portletDataContext, Element fileEntryElement, ServiceContext serviceContext) throws Exception {
        String fileEntryTypeUuid = fileEntryElement.attributeValue("fileEntryTypeUuid");
        if (Validator.isNull((String)fileEntryTypeUuid)) {
            return;
        }
        DLFileEntryType dlFileEntryType = DLFileEntryTypeUtil.fetchByUUID_G((String)fileEntryTypeUuid, (long)portletDataContext.getScopeGroupId());
        if (dlFileEntryType == null) {
            serviceContext.setAttribute("fileEntryTypeId", (Serializable)Integer.valueOf(-1));
            return;
        }
        serviceContext.setAttribute("fileEntryTypeId", (Serializable)Long.valueOf(dlFileEntryType.getFileEntryTypeId()));
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            Element structureFieldsElement = (Element)fileEntryElement.selectSingleNode("structure-fields[@structureUuid='".concat(ddmStructure.getUuid()).concat("']"));
            if (structureFieldsElement == null) continue;
            String path = structureFieldsElement.attributeValue("path");
            Fields fields = (Fields)portletDataContext.getZipEntryAsObject(path);
            serviceContext.setAttribute(String.valueOf(Fields.class.getName()) + ddmStructure.getStructureId(), (Serializable)fields);
        }
    }

    protected static boolean isFileEntryTypeExportable(long companyId, DLFileEntryType dlFileEntryType) throws PortalException, SystemException {
        if (dlFileEntryType.getFileEntryTypeId() == 0L) {
            return false;
        }
        Group group = GroupLocalServiceUtil.getCompanyGroup((long)companyId);
        return dlFileEntryType.getGroupId() != group.getGroupId();
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        if (!portletDataContext.addPrimaryKey(DLPortletDataHandlerImpl.class, "deleteData")) {
            DLAppLocalServiceUtil.deleteAll((long)portletDataContext.getScopeGroupId());
        }
        return null;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPermissions("com.liferay.portlet.documentlibrary", portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("documentlibrary-data");
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId != 0L) {
            rootElement.addAttribute("root-folder-id", String.valueOf(rootFolderId));
        }
        Element fileEntryTypesElement = rootElement.addElement("file-entry-types");
        Element foldersElement = rootElement.addElement("folders");
        Element fileEntriesElement = rootElement.addElement("file-entries");
        Element fileShortcutsElement = rootElement.addElement("file-shortcuts");
        Element fileRanksElement = rootElement.addElement("file-ranks");
        Element repositoriesElement = rootElement.addElement("repositories");
        Element repositoryEntriesElement = rootElement.addElement("repository-entries");
        List dlFileEntryTypes = DLFileEntryTypeServiceUtil.getFileEntryTypes((long[])new long[]{portletDataContext.getScopeGroupId()});
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            if (!DLPortletDataHandlerImpl.isFileEntryTypeExportable(portletDataContext.getCompanyId(), dlFileEntryType)) continue;
            DLPortletDataHandlerImpl.exportFileEntryType(portletDataContext, fileEntryTypesElement, dlFileEntryType);
        }
        List<Folder> folders = FolderUtil.findByRepositoryId(portletDataContext.getScopeGroupId());
        for (Folder folder : folders) {
            DLPortletDataHandlerImpl.exportFolder(portletDataContext, fileEntryTypesElement, foldersElement, fileEntriesElement, fileShortcutsElement, fileRanksElement, repositoriesElement, repositoryEntriesElement, folder, false);
        }
        List<FileEntry> fileEntries = FileEntryUtil.findByR_F(portletDataContext.getScopeGroupId(), 0L);
        for (FileEntry fileEntry : fileEntries) {
            DLPortletDataHandlerImpl.exportFileEntry(portletDataContext, fileEntryTypesElement, foldersElement, fileEntriesElement, fileRanksElement, repositoriesElement, repositoryEntriesElement, fileEntry, true);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "shortcuts")) {
            List fileShortcuts = DLFileShortcutUtil.findByG_F((long)portletDataContext.getScopeGroupId(), (long)0L);
            for (DLFileShortcut fileShortcut : fileShortcuts) {
                DLPortletDataHandlerImpl.exportFileShortcut(portletDataContext, fileEntryTypesElement, foldersElement, fileShortcutsElement, repositoriesElement, repositoryEntriesElement, fileShortcut);
            }
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        long rootFolderId;
        portletDataContext.importPermissions("com.liferay.portlet.documentlibrary", portletDataContext.getSourceGroupId(), portletDataContext.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element repositoriesElement = rootElement.element("repositories");
        if (repositoriesElement != null) {
            List repositoryElements = repositoriesElement.elements("repository");
            for (Element repositoryElement : repositoryElements) {
                DLPortletDataHandlerImpl.importRepository(portletDataContext, repositoryElement);
            }
        }
        Element repositoryEntriesElement = rootElement.element("repository-entries");
        List repositoryEntryElements = repositoryEntriesElement.elements("repository-entry");
        for (Element repositoryEntryElement : repositoryEntryElements) {
            DLPortletDataHandlerImpl.importRepositoryEntry(portletDataContext, repositoryEntryElement);
        }
        Element fileEntryTypesElement = rootElement.element("file-entry-types");
        List fileEntryTypeElements = fileEntryTypesElement.elements("file-entry-type");
        for (Element fileEntryTypeElement : fileEntryTypeElements) {
            DLPortletDataHandlerImpl.importFileEntryType(portletDataContext, fileEntryTypeElement);
        }
        Element foldersElement = rootElement.element("folders");
        List folderElements = foldersElement.elements("folder");
        for (Element folderElement : folderElements) {
            DLPortletDataHandlerImpl.importFolder(portletDataContext, folderElement);
        }
        Element fileEntriesElement = rootElement.element("file-entries");
        List fileEntryElements = fileEntriesElement.elements("file-entry");
        for (Element fileEntryElement : fileEntryElements) {
            DLPortletDataHandlerImpl.importFileEntry(portletDataContext, fileEntryElement);
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "shortcuts")) {
            List fileShortcutElements = rootElement.element("file-shortcuts").elements("file-shortcut");
            for (Element fileShortcutElement : fileShortcutElements) {
                DLPortletDataHandlerImpl.importFileShortcut(portletDataContext, fileShortcutElement);
            }
        }
        if (portletDataContext.getBooleanParameter(_NAMESPACE, "ranks")) {
            Element fileRanksElement = rootElement.element("file-ranks");
            List fileRankElements = fileRanksElement.elements("file-rank");
            for (Element fileRankElement : fileRankElements) {
                DLPortletDataHandlerImpl.importFileRank(portletDataContext, fileRankElement);
            }
        }
        if ((rootFolderId = GetterUtil.getLong((String)rootElement.attributeValue("root-folder-id"))) > 0L) {
            Map folderIds = portletDataContext.getNewPrimaryKeysMap(DLFolder.class);
            rootFolderId = MapUtil.getLong((Map)folderIds, (long)rootFolderId, (long)rootFolderId);
            portletPreferences.setValue("rootFolderId", String.valueOf(rootFolderId));
        }
        return portletPreferences;
    }
}

