/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryMetadataLocalServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.StorageException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryMetadataLocalServiceImpl
extends DLFileEntryMetadataLocalServiceBaseImpl {
    public void deleteFileEntryMetadata(long fileEntryId) throws PortalException, SystemException {
        List fileEntryMetadatas = this.dlFileEntryMetadataPersistence.findByFileEntryId(fileEntryId);
        for (DLFileEntryMetadata fileEntryMetadata : fileEntryMetadatas) {
            this.deleteFileEntryMetadata(fileEntryMetadata);
        }
    }

    public DLFileEntryMetadata getFileEntryMetadata(long fileEntryMetadataId) throws PortalException, SystemException {
        return this.dlFileEntryMetadataPersistence.findByPrimaryKey(fileEntryMetadataId);
    }

    public DLFileEntryMetadata getFileEntryMetadata(long ddmStructureId, long fileVersionId) throws PortalException, SystemException {
        return this.dlFileEntryMetadataPersistence.findByD_F(ddmStructureId, fileVersionId);
    }

    public long getFileEntryMetadataCount(long fileEntryId, long fileVersionId) throws SystemException {
        return this.dlFileEntryMetadataPersistence.countByF_V(fileEntryId, fileVersionId);
    }

    public void updateFileEntryMetadata(long companyId, List<DDMStructure> ddmStructures, long fileEntryTypeId, long fileEntryId, long fileVersionId, Map<String, Fields> fieldsMap, ServiceContext serviceContext) throws PortalException, SystemException {
        for (DDMStructure ddmStructure : ddmStructures) {
            Fields fields = fieldsMap.get(ddmStructure.getStructureKey());
            if (fields == null) continue;
            this.updateFileEntryMetadata(companyId, ddmStructure, fileEntryTypeId, fileEntryId, fileVersionId, fields, serviceContext);
        }
    }

    public void updateFileEntryMetadata(long fileEntryTypeId, long fileEntryId, long fileVersionId, Map<String, Fields> fieldsMap, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryType fileEntryType = this.dlFileEntryTypeLocalService.getFileEntryType(fileEntryTypeId);
        List ddmStructures = fileEntryType.getDDMStructures();
        this.updateFileEntryMetadata(fileEntryType.getCompanyId(), ddmStructures, fileEntryTypeId, fileEntryId, fileVersionId, fieldsMap, serviceContext);
    }

    protected void deleteFileEntryMetadata(DLFileEntryMetadata fileEntryMetadata) throws PortalException, SystemException {
        this.dlFileEntryMetadataPersistence.remove((BaseModel)fileEntryMetadata);
        StorageEngineUtil.deleteByClass((long)fileEntryMetadata.getDDMStorageId());
        this.ddmStructureLinkLocalService.deleteClassStructureLink(fileEntryMetadata.getFileEntryMetadataId());
    }

    protected void updateFileEntryMetadata(long companyId, DDMStructure ddmStructure, long fileEntryTypeId, long fileEntryId, long fileVersionId, Fields fields, ServiceContext serviceContext) throws StorageException, SystemException {
        DLFileEntryMetadata fileEntryMetadata = this.dlFileEntryMetadataPersistence.fetchByD_F(ddmStructure.getStructureId(), fileVersionId);
        if (fileEntryMetadata != null) {
            StorageEngineUtil.update((long)fileEntryMetadata.getDDMStorageId(), (Fields)fields, (ServiceContext)serviceContext);
        } else {
            long fileEntryMetadataId = this.counterLocalService.increment();
            fileEntryMetadata = this.dlFileEntryMetadataPersistence.create(fileEntryMetadataId);
            long ddmStorageId = StorageEngineUtil.create((long)companyId, (long)ddmStructure.getStructureId(), (Fields)fields, (ServiceContext)serviceContext);
            fileEntryMetadata.setDDMStorageId(ddmStorageId);
            fileEntryMetadata.setDDMStructureId(ddmStructure.getStructureId());
            fileEntryMetadata.setFileEntryTypeId(fileEntryTypeId);
            fileEntryMetadata.setFileEntryId(fileEntryId);
            fileEntryMetadata.setFileVersionId(fileVersionId);
            this.dlFileEntryMetadataPersistence.update((BaseModel)fileEntryMetadata, false);
            long classNameId = PortalUtil.getClassNameId(DLFileEntryMetadata.class);
            this.ddmStructureLinkLocalService.addStructureLink(classNameId, fileEntryMetadata.getFileEntryMetadataId(), ddmStructure.getStructureId(), serviceContext);
        }
        try {
            String namespace = String.valueOf(ddmStructure.getStructureId());
            for (String fieldName : ddmStructure.getFieldNames()) {
                String fieldDataType = ddmStructure.getFieldDataType(fieldName);
                if (!fieldDataType.equals("file-upload")) continue;
                DDMUtil.uploadFieldFile((long)fileEntryMetadata.getDDMStructureId(), (long)fileEntryMetadata.getDDMStorageId(), (BaseModel)fileEntryMetadata, (String)fieldName, (String)namespace, (ServiceContext)serviceContext);
            }
        }
        catch (Exception exception) {}
    }
}

