/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryImpl;
import com.liferay.portlet.documentlibrary.service.base.DLFileEntryServiceBaseImpl;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryServiceImpl
extends DLFileEntryServiceBaseImpl {
    public DLFileEntry addFileEntry(long groupId, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, long fileEntryTypeId, Map<String, Fields> fieldsMap, File file, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "ADD_DOCUMENT");
        return this.dlFileEntryLocalService.addFileEntry(this.getUserId(), groupId, repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, fieldsMap, file, is, size, serviceContext);
    }

    public DLFileVersion cancelCheckOut(long fileEntryId) throws PortalException, SystemException {
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "UPDATE");
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {}
        return this.dlFileEntryLocalService.cancelCheckOut(this.getUserId(), fileEntryId);
    }

    public void checkInFileEntry(long fileEntryId, boolean major, String changeLog, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "UPDATE");
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {}
        this.dlFileEntryLocalService.checkInFileEntry(this.getUserId(), fileEntryId, major, changeLog, serviceContext);
    }

    public void checkInFileEntry(long fileEntryId, String lockUuid) throws PortalException, SystemException {
        try {
            DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "UPDATE");
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {}
        this.dlFileEntryLocalService.checkInFileEntry(this.getUserId(), fileEntryId, lockUuid);
    }

    public DLFileEntry checkOutFileEntry(long fileEntryId) throws PortalException, SystemException {
        return this.checkOutFileEntry(fileEntryId, new ServiceContext());
    }

    public DLFileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.checkOutFileEntry(fileEntryId, null, DLFileEntryImpl.LOCK_EXPIRATION_TIME, serviceContext);
    }

    public DLFileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime) throws PortalException, SystemException {
        return this.checkOutFileEntry(fileEntryId, owner, expirationTime, new ServiceContext());
    }

    public DLFileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "UPDATE");
        if (expirationTime <= 0L || expirationTime > DLFileEntryImpl.LOCK_EXPIRATION_TIME) {
            expirationTime = DLFileEntryImpl.LOCK_EXPIRATION_TIME;
        }
        return this.dlFileEntryLocalService.checkOutFileEntry(this.getUserId(), fileEntryId, owner, expirationTime, serviceContext);
    }

    public DLFileEntry copyFileEntry(long groupId, long repositoryId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getFileEntry(fileEntryId);
        String sourceFileName = "A." + dlFileEntry.getExtension();
        InputStream inputStream = DLStoreUtil.getFileAsStream((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getFolderId(), (String)dlFileEntry.getName());
        DLFileEntry newDlFileEntry = this.addFileEntry(groupId, repositoryId, destFolderId, sourceFileName, dlFileEntry.getMimeType(), dlFileEntry.getTitle(), dlFileEntry.getDescription(), null, dlFileEntry.getFileEntryTypeId(), null, null, inputStream, dlFileEntry.getSize(), serviceContext);
        DLFileVersion dlFileVersion = dlFileEntry.getFileVersion();
        DLFileVersion newDlFileVersion = newDlFileEntry.getFileVersion();
        this.dlFileEntryLocalService.copyFileEntryMetadata(dlFileVersion.getCompanyId(), dlFileVersion.getFileEntryTypeId(), fileEntryId, newDlFileVersion.getFileVersionId(), dlFileVersion.getFileVersionId(), serviceContext);
        return newDlFileEntry;
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "DELETE");
        this.dlFileEntryLocalService.deleteFileEntry(this.getUserId(), fileEntryId);
    }

    public void deleteFileEntry(long groupId, long folderId, String title) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.getFileEntry(groupId, folderId, title);
        this.deleteFileEntry(dlFileEntry.getFileEntryId());
    }

    public void deleteFileVersion(long fileEntryId, String version) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "DELETE");
        this.dlFileEntryLocalService.deleteFileVersion(this.getUserId(), fileEntryId, version);
    }

    public DLFileEntry fetchFileEntryByImageId(long imageId) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryFinder.fetchByAnyImageId(imageId);
        if (dlFileEntry != null) {
            DLFileEntryPermission.check(this.getPermissionChecker(), dlFileEntry, "VIEW");
        }
        return dlFileEntry;
    }

    public InputStream getFileAsStream(long fileEntryId, String version) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileEntryLocalService.getFileAsStream(this.getGuestOrUserId(), fileEntryId, version);
    }

    public InputStream getFileAsStream(long fileEntryId, String version, boolean incrementCounter) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileEntryLocalService.getFileAsStream(this.getGuestOrUserId(), fileEntryId, version, incrementCounter);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFileEntryPersistence.filterFindByG_F(groupId, folderId, start, end, obc);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, long fileEntryTypeId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFileEntryPersistence.filterFindByG_F_F(groupId, folderId, fileEntryTypeId, start, end, obc);
    }

    public List<DLFileEntry> getFileEntries(long groupId, long folderId, String[] mimeTypes, int start, int end, OrderByComparator obc) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFileEntryFinder.findByG_U_F_M_S(groupId, 0L, folderIds, mimeTypes, -1, start, end, obc);
    }

    public int getFileEntriesCount(long groupId, long folderId) throws SystemException {
        return this.dlFileEntryPersistence.filterCountByG_F(groupId, folderId);
    }

    public int getFileEntriesCount(long groupId, long folderId, long fileEntryTypeId) throws SystemException {
        return this.dlFileEntryPersistence.filterCountByG_F_F(groupId, folderId, fileEntryTypeId);
    }

    public int getFileEntriesCount(long groupId, long folderId, String[] mimeTypes) throws SystemException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.dlFileEntryFinder.countByG_U_F_M_S(groupId, 0L, folderIds, mimeTypes, -1);
    }

    public DLFileEntry getFileEntry(long fileEntryId) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
        return this.dlFileEntryLocalService.getFileEntry(fileEntryId);
    }

    public DLFileEntry getFileEntry(long groupId, long folderId, String title) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(groupId, folderId, title);
        DLFileEntryPermission.check(this.getPermissionChecker(), dlFileEntry, "VIEW");
        return dlFileEntry;
    }

    public DLFileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryPersistence.findByUUID_G(uuid, groupId);
        DLFileEntryPermission.check(this.getPermissionChecker(), dlFileEntry, "VIEW");
        return dlFileEntry;
    }

    public Lock getFileEntryLock(long fileEntryId) {
        try {
            return this.lockLocalService.getLock(DLFileEntry.class.getName(), fileEntryId);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getFoldersFileEntriesCount(long groupId, List<Long> folderIds, int status) throws SystemException {
        if (folderIds.size() <= PropsValues.SQL_DATA_MAX_PARAMETERS) {
            return this.dlFileEntryFinder.filterCountByG_F_S(groupId, folderIds, status);
        }
        int start = 0;
        int end = PropsValues.SQL_DATA_MAX_PARAMETERS;
        int filesCount = this.dlFileEntryFinder.filterCountByG_F_S(groupId, folderIds.subList(start, end), status);
        folderIds.subList(start, end).clear();
        return filesCount += this.getFoldersFileEntriesCount(groupId, folderIds, status);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end, OrderByComparator obc) throws SystemException {
        long[] folderIds = this.dlFolderService.getFolderIds(groupId, rootFolderId);
        if (folderIds.length == 0) {
            return Collections.emptyList();
        }
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.filterFindByG_F(groupId, folderIds, start, end, obc);
        }
        return this.dlFileEntryPersistence.filterFindByG_U_F(groupId, userId, folderIds, start, end, obc);
    }

    public List<DLFileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator obc) throws SystemException {
        long[] folderIds = this.dlFolderService.getFolderIds(groupId, rootFolderId);
        if (folderIds.length == 0) {
            return Collections.emptyList();
        }
        List folderIdsList = ListUtil.toList((long[])folderIds);
        return this.dlFileEntryFinder.findByG_U_F_M_S(groupId, userId, folderIdsList, mimeTypes, status, start, end, obc);
    }

    public int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId) throws SystemException {
        long[] folderIds = this.dlFolderService.getFolderIds(groupId, rootFolderId);
        if (folderIds.length == 0) {
            return 0;
        }
        if (userId <= 0L) {
            return this.dlFileEntryPersistence.filterCountByG_F(groupId, folderIds);
        }
        return this.dlFileEntryPersistence.filterCountByG_U_F(groupId, userId, folderIds);
    }

    public int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status) throws SystemException {
        long[] folderIds = this.dlFolderService.getFolderIds(groupId, rootFolderId);
        if (folderIds.length == 0) {
            return 0;
        }
        List folderIdsList = ListUtil.toList((long[])folderIds);
        return this.dlFileEntryFinder.countByG_U_F_M_S(groupId, userId, folderIdsList, mimeTypes, status);
    }

    public boolean hasFileEntryLock(long fileEntryId) throws PortalException, SystemException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
        long folderId = dlFileEntry.getFolderId();
        boolean hasLock = this.lockLocalService.hasLock(this.getUserId(), DLFileEntry.class.getName(), fileEntryId);
        if (!hasLock && folderId != 0L) {
            hasLock = this.dlFolderService.hasInheritableLock(folderId);
        }
        return hasLock;
    }

    public boolean isFileEntryCheckedOut(long fileEntryId) throws PortalException, SystemException {
        return this.dlFileEntryLocalService.isFileEntryCheckedOut(fileEntryId);
    }

    public DLFileEntry moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "UPDATE");
        return this.dlFileEntryLocalService.moveFileEntry(this.getUserId(), fileEntryId, newFolderId, serviceContext);
    }

    public Lock refreshFileEntryLock(String lockUuid, long expirationTime) throws PortalException, SystemException {
        return this.lockLocalService.refresh(lockUuid, expirationTime);
    }

    public void revertFileEntry(long fileEntryId, String version, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "UPDATE");
        this.dlFileEntryLocalService.revertFileEntry(this.getUserId(), fileEntryId, version, serviceContext);
    }

    public DLFileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, long fileEntryTypeId, Map<String, Fields> fieldsMap, File file, InputStream is, long size, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "UPDATE");
        return this.dlFileEntryLocalService.updateFileEntry(this.getUserId(), fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, fileEntryTypeId, fieldsMap, file, is, size, serviceContext);
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException, SystemException {
        return this.dlFileEntryLocalService.verifyFileEntryCheckOut(fileEntryId, lockUuid);
    }

    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws PortalException, SystemException {
        return this.dlFileEntryLocalService.verifyFileEntryLock(fileEntryId, lockUuid);
    }
}

