/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileRank;
import com.liferay.portlet.documentlibrary.service.base.DLFileRankLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.comparator.FileRankCreateDateComparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileRankLocalServiceImpl
extends DLFileRankLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFileRankLocalServiceImpl.class);

    public DLFileRank addFileRank(long groupId, long companyId, long userId, long fileEntryId, ServiceContext serviceContext) throws SystemException {
        DLFileRank dlFileRank;
        block3: {
            long fileRankId = this.counterLocalService.increment();
            dlFileRank = this.dlFileRankPersistence.create(fileRankId);
            dlFileRank.setGroupId(groupId);
            dlFileRank.setCompanyId(companyId);
            dlFileRank.setUserId(userId);
            dlFileRank.setCreateDate(serviceContext.getCreateDate(null));
            dlFileRank.setFileEntryId(fileEntryId);
            try {
                this.dlFileRankPersistence.update((BaseModel)dlFileRank, false);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {companyId=" + companyId + ", userId=" + userId + ", fileEntryId=" + fileEntryId + "}"));
                }
                if ((dlFileRank = this.dlFileRankPersistence.fetchByC_U_F(companyId, userId, fileEntryId, false)) != null) break block3;
                throw se;
            }
        }
        return dlFileRank;
    }

    public void checkFileRanks() throws SystemException {
        List staleFileRanks = this.dlFileRankFinder.findByStaleRanks(PropsValues.DL_FILE_RANK_MAX_SIZE);
        for (Object[] staleFileRank : staleFileRanks) {
            long groupId = (Long)staleFileRank[0];
            long userId = (Long)staleFileRank[1];
            List dlFileRanks = this.dlFileRankPersistence.findByG_U(groupId, userId, PropsValues.DL_FILE_RANK_MAX_SIZE, -1, (OrderByComparator)new FileRankCreateDateComparator());
            for (DLFileRank dlFileRank : dlFileRanks) {
                long fileRankId = dlFileRank.getFileRankId();
                try {
                    this.dlFileRankPersistence.remove((BaseModel)dlFileRank);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to remove file rank " + fileRankId));
                }
            }
        }
    }

    public void deleteFileRank(DLFileRank dlFileRank) throws SystemException {
        this.dlFileRankPersistence.remove((BaseModel)dlFileRank);
    }

    public void deleteFileRank(long fileRankId) throws PortalException, SystemException {
        DLFileRank dlFileRank = this.dlFileRankPersistence.findByPrimaryKey(fileRankId);
        this.deleteFileRank(dlFileRank);
    }

    public void deleteFileRanksByFileEntryId(long fileEntryId) throws SystemException {
        List dlFileRanks = this.dlFileRankPersistence.findByFileEntryId(fileEntryId);
        for (DLFileRank dlFileRank : dlFileRanks) {
            this.deleteFileRank(dlFileRank);
        }
    }

    public void deleteFileRanksByUserId(long userId) throws SystemException {
        List dlFileRanks = this.dlFileRankPersistence.findByUserId(userId);
        for (DLFileRank dlFileRank : dlFileRanks) {
            this.deleteFileRank(dlFileRank);
        }
    }

    public List<DLFileRank> getFileRanks(long groupId, long userId) throws SystemException {
        return this.dlFileRankPersistence.findByG_U(groupId, userId, 0, PropsValues.DL_FILE_RANK_MAX_SIZE, (OrderByComparator)new FileRankCreateDateComparator());
    }

    public DLFileRank updateFileRank(long groupId, long companyId, long userId, long fileEntryId, ServiceContext serviceContext) throws SystemException {
        if (!PropsValues.DL_FILE_RANK_ENABLED) {
            return null;
        }
        DLFileRank dlFileRank = this.dlFileRankPersistence.fetchByC_U_F(companyId, userId, fileEntryId);
        if (dlFileRank != null) {
            dlFileRank.setCreateDate(serviceContext.getCreateDate(null));
            try {
                this.dlFileRankPersistence.update((BaseModel)dlFileRank, false);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Update failed, fetch {companyId=" + companyId + ", userId=" + userId + ", fileEntryId=" + fileEntryId + "}"));
                }
            }
        } else {
            dlFileRank = this.addFileRank(groupId, companyId, userId, fileEntryId, serviceContext);
        }
        return dlFileRank;
    }
}

