/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchDirectoryException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.service.base.DLFolderLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFolderLocalServiceImpl
extends DLFolderLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DLFolderLocalServiceImpl.class);

    public DLFolder addFolder(long userId, long groupId, long repositoryId, boolean mountPoint, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        Date now = new Date();
        this.validateFolder(groupId, parentFolderId, name);
        long folderId = this.counterLocalService.increment();
        DLFolder dlFolder = this.dlFolderPersistence.create(folderId);
        dlFolder.setUuid(serviceContext.getUuid());
        dlFolder.setGroupId(groupId);
        dlFolder.setCompanyId(user.getCompanyId());
        dlFolder.setUserId(user.getUserId());
        dlFolder.setCreateDate(serviceContext.getCreateDate(now));
        dlFolder.setModifiedDate(serviceContext.getModifiedDate(now));
        dlFolder.setRepositoryId(repositoryId);
        dlFolder.setMountPoint(mountPoint);
        dlFolder.setParentFolderId(parentFolderId);
        dlFolder.setName(name);
        dlFolder.setDescription(description);
        dlFolder.setOverrideFileEntryTypes(false);
        dlFolder.setExpandoBridgeAttributes(serviceContext);
        this.dlFolderPersistence.update((BaseModel)dlFolder, false);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFolderResources(dlFolder, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            if (serviceContext.isDeriveDefaultPermissions()) {
                serviceContext.deriveDefaultPermissions(repositoryId, DLFolderConstants.getClassName());
            }
            this.addFolderResources(dlFolder, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        if (parentFolderId != 0L) {
            DLFolder parentDLFolder = this.dlFolderPersistence.findByPrimaryKey(parentFolderId);
            parentDLFolder.setLastPostDate(now);
            this.dlFolderPersistence.update((BaseModel)parentDLFolder, false);
        }
        this.dlAppHelperLocalService.addFolder((Folder)new LiferayFolder(dlFolder), serviceContext);
        return dlFolder;
    }

    public void deleteAll(long groupId) throws PortalException, SystemException {
        block3: {
            Group group = this.groupLocalService.getGroup(groupId);
            List dlFolders = this.dlFolderPersistence.findByG_P(groupId, 0L);
            for (DLFolder dlFolder : dlFolders) {
                this.deleteFolder(dlFolder);
            }
            this.dlFileEntryLocalService.deleteFileEntries(groupId, 0L);
            try {
                DLStoreUtil.deleteDirectory((long)group.getCompanyId(), (long)groupId, (String)"");
            }
            catch (NoSuchDirectoryException nsde) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)nsde.getMessage());
            }
        }
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.deleteFolder(dlFolder);
    }

    public List<DLFolder> getCompanyFolders(long companyId, int start, int end) throws SystemException {
        return this.dlFolderPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyFoldersCount(long companyId) throws SystemException {
        return this.dlFolderPersistence.countByCompanyId(companyId);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long groupId, long folderId, int status, int start, int end) throws SystemException {
        return this.dlFolderFinder.findFE_FS_ByG_F_S(groupId, folderId, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status) throws SystemException {
        int fileEntriesCount = 0;
        fileEntriesCount = status == -1 ? this.dlFileEntryPersistence.countByG_F(groupId, folderId) : this.dlFolderFinder.countFE_ByG_F_S(groupId, folderId, status);
        int fileShortcutsCount = this.dlFileShortcutPersistence.countByG_F_S(groupId, folderId, 0);
        return fileEntriesCount + fileShortcutsCount;
    }

    public DLFolder getFolder(long folderId) throws PortalException, SystemException {
        return this.dlFolderPersistence.findByPrimaryKey(folderId);
    }

    public DLFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        return this.dlFolderPersistence.findByG_P_N(groupId, parentFolderId, name);
    }

    public long getFolderId(long companyId, long folderId) throws SystemException {
        DLFolder dlFolder;
        if (folderId != 0L && ((dlFolder = this.dlFolderPersistence.fetchByPrimaryKey(folderId)) == null || companyId != dlFolder.getCompanyId())) {
            folderId = 0L;
        }
        return folderId;
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.getFolders(groupId, parentFolderId, true);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, boolean includeMountfolders) throws SystemException {
        if (includeMountfolders) {
            return this.dlFolderPersistence.findByG_P(groupId, parentFolderId);
        }
        return this.dlFolderPersistence.findByG_P_M(groupId, parentFolderId, false);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator obc) throws SystemException {
        if (includeMountfolders) {
            return this.dlFolderPersistence.findByG_P(groupId, parentFolderId, start, end, obc);
        }
        return this.dlFolderPersistence.findByG_P_M(groupId, parentFolderId, false, start, end, obc);
    }

    public List<DLFolder> getFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.getFolders(groupId, parentFolderId, true, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFolderFinder.findF_FE_FS_ByG_F_S_M_M(groupId, folderId, status, null, includeMountFolders, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFolderFinder.findF_FE_FS_ByG_F_S_M_M(groupId, folderId, status, mimeTypes, includeMountFolders, start, end, obc);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, boolean includeMountFolders) throws SystemException {
        return this.dlFolderFinder.countF_FE_FS_ByG_F_S_M_M(groupId, folderId, status, null, includeMountFolders);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long groupId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws SystemException {
        return this.dlFolderFinder.countF_FE_FS_ByG_F_S_M_M(groupId, folderId, status, mimeTypes, includeMountFolders);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.getFoldersCount(groupId, parentFolderId, true);
    }

    public int getFoldersCount(long groupId, long parentFolderId, boolean includeMountfolders) throws SystemException {
        if (includeMountfolders) {
            return this.dlFolderPersistence.countByG_P(groupId, parentFolderId);
        }
        return this.dlFolderPersistence.countByG_P_M(groupId, parentFolderId, false);
    }

    public int getFoldersFileEntriesCount(long groupId, List<Long> folderIds, int status) throws SystemException {
        if (folderIds.size() <= PropsValues.SQL_DATA_MAX_PARAMETERS) {
            return this.dlFileEntryFinder.countByG_F_S(groupId, folderIds, status);
        }
        int start = 0;
        int end = PropsValues.SQL_DATA_MAX_PARAMETERS;
        int filesCount = this.dlFileEntryFinder.countByG_F_S(groupId, folderIds.subList(start, end), status);
        folderIds.subList(start, end).clear();
        return filesCount += this.getFoldersFileEntriesCount(groupId, folderIds, status);
    }

    public DLFolder getMountFolder(long repositoryId) throws PortalException, SystemException {
        return this.dlFolderPersistence.findByRepositoryId(repositoryId);
    }

    public List<DLFolder> getMountFolders(long groupId, long parentFolderId, int start, int end, OrderByComparator obc) throws SystemException {
        return this.dlFolderPersistence.findByG_P_M(groupId, parentFolderId, true, start, end, obc);
    }

    public int getMountFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.dlFolderPersistence.countByG_P_M(groupId, parentFolderId, true);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List dlFolders = this.dlFolderPersistence.findByG_P(groupId, folderId);
        for (DLFolder dlFolder : dlFolders) {
            folderIds.add(dlFolder.getFolderId());
            this.getSubfolderIds(folderIds, dlFolder.getGroupId(), dlFolder.getFolderId());
        }
    }

    public DLFolder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(dlFolder, parentFolderId);
        this.validateFolder(dlFolder.getFolderId(), dlFolder.getGroupId(), parentFolderId, dlFolder.getName());
        dlFolder.setModifiedDate(serviceContext.getModifiedDate(null));
        dlFolder.setParentFolderId(parentFolderId);
        dlFolder.setExpandoBridgeAttributes(serviceContext);
        this.dlFolderPersistence.update((BaseModel)dlFolder, false);
        this.dlAppHelperLocalService.moveFolder((Folder)new LiferayFolder(dlFolder));
        return dlFolder;
    }

    public DLFolder updateFolder(long folderId, long parentFolderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFolder dlFolder = null;
        if (folderId > 0L) {
            dlFolder = this.dlFolderLocalService.updateFolderAndFileEntryTypes(folderId, parentFolderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, overrideFileEntryTypes, serviceContext);
            this.dlFileEntryTypeLocalService.cascadeFileEntryTypes(serviceContext.getUserId(), dlFolder);
        }
        ArrayList<ObjectValuePair> workflowDefinitions = new ArrayList<ObjectValuePair>();
        if (fileEntryTypeIds.isEmpty()) {
            fileEntryTypeIds.add(-1L);
        } else {
            workflowDefinitions.add(new ObjectValuePair((Object)-1L, (Object)""));
        }
        for (long fileEntryTypeId : fileEntryTypeIds) {
            String workflowDefinition = ParamUtil.getString((ServiceContext)serviceContext, (String)("workflowDefinition" + fileEntryTypeId));
            workflowDefinitions.add(new ObjectValuePair((Object)fileEntryTypeId, (Object)workflowDefinition));
        }
        this.workflowDefinitionLinkLocalService.updateWorkflowDefinitionLinks(serviceContext.getUserId(), serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), DLFolder.class.getName(), folderId, workflowDefinitions);
        return dlFolder;
    }

    public DLFolder updateFolder(long folderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.updateFolder(folderId, folderId, name, description, defaultFileEntryTypeId, fileEntryTypeIds, overrideFileEntryTypes, serviceContext);
    }

    public DLFolder updateFolderAndFileEntryTypes(long folderId, long parentFolderId, String name, String description, long defaultFileEntryTypeId, List<Long> fileEntryTypeIds, boolean overrideFileEntryTypes, ServiceContext serviceContext) throws PortalException, SystemException {
        if (!overrideFileEntryTypes) {
            fileEntryTypeIds = Collections.emptyList();
        }
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(dlFolder, parentFolderId);
        this.validateFolder(folderId, dlFolder.getGroupId(), parentFolderId, name);
        dlFolder.setModifiedDate(serviceContext.getModifiedDate(null));
        dlFolder.setParentFolderId(parentFolderId);
        dlFolder.setName(name);
        dlFolder.setDescription(description);
        dlFolder.setExpandoBridgeAttributes(serviceContext);
        dlFolder.setOverrideFileEntryTypes(overrideFileEntryTypes);
        dlFolder.setDefaultFileEntryTypeId(defaultFileEntryTypeId);
        this.dlFolderPersistence.update((BaseModel)dlFolder, false);
        if (fileEntryTypeIds != null) {
            this.dlFileEntryTypeLocalService.updateFolderFileEntryTypes(dlFolder, fileEntryTypeIds, defaultFileEntryTypeId, serviceContext);
        }
        this.dlAppHelperLocalService.updateFolder((Folder)new LiferayFolder(dlFolder), serviceContext);
        return dlFolder;
    }

    public void updateLastPostDate(long folderId, Date lastPostDate) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        dlFolder.setLastPostDate(lastPostDate);
        this.dlFolderPersistence.update((BaseModel)dlFolder, false);
    }

    protected void addFolderResources(DLFolder dlFolder, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(dlFolder.getCompanyId(), dlFolder.getGroupId(), dlFolder.getUserId(), DLFolder.class.getName(), dlFolder.getFolderId(), false, addGroupPermissions, addGuestPermissions);
    }

    protected void addFolderResources(DLFolder dlFolder, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(dlFolder.getCompanyId(), dlFolder.getGroupId(), dlFolder.getUserId(), DLFolder.class.getName(), dlFolder.getFolderId(), groupPermissions, guestPermissions);
    }

    protected void addFolderResources(long folderId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(dlFolder, addGroupPermissions, addGuestPermissions);
    }

    protected void addFolderResources(long folderId, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(dlFolder, groupPermissions, guestPermissions);
    }

    protected void deleteFolder(DLFolder dlFolder) throws PortalException, SystemException {
        block3: {
            List dlFolders = this.dlFolderPersistence.findByG_P(dlFolder.getGroupId(), dlFolder.getFolderId());
            for (DLFolder curDLFolder : dlFolders) {
                this.deleteFolder(curDLFolder);
            }
            this.resourceLocalService.deleteResource(dlFolder.getCompanyId(), DLFolder.class.getName(), 4, dlFolder.getFolderId());
            this.webDAVPropsLocalService.deleteWebDAVProps(DLFolder.class.getName(), dlFolder.getFolderId());
            this.dlFileEntryLocalService.deleteFileEntries(dlFolder.getGroupId(), dlFolder.getFolderId());
            this.dlFileEntryTypeLocalService.unsetFolderFileEntryTypes(dlFolder.getFolderId());
            this.expandoValueLocalService.deleteValues(DLFolder.class.getName(), dlFolder.getFolderId());
            this.dlAppHelperLocalService.deleteFolder((Folder)new LiferayFolder(dlFolder));
            this.dlFolderPersistence.remove((BaseModel)dlFolder);
            try {
                DLStoreUtil.deleteDirectory((long)dlFolder.getCompanyId(), (long)dlFolder.getFolderId(), (String)"");
            }
            catch (NoSuchDirectoryException nsde) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)nsde.getMessage());
            }
        }
    }

    protected long getParentFolderId(DLFolder dlFolder, long parentFolderId) throws SystemException {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (dlFolder.getFolderId() == parentFolderId) {
            return dlFolder.getParentFolderId();
        }
        DLFolder parentDLFolder = this.dlFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentDLFolder == null || dlFolder.getGroupId() != parentDLFolder.getGroupId()) {
            return dlFolder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, dlFolder.getGroupId(), dlFolder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return dlFolder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) throws SystemException {
        DLFolder parentDLFolder;
        if (parentFolderId != 0L && ((parentDLFolder = this.dlFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentDLFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected void validateFolder(long folderId, long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        this.validateFolderName(name);
        try {
            this.dlFileEntryLocalService.getFileEntry(groupId, parentFolderId, name);
            throw new DuplicateFileException(name);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            DLFolder dlFolder = this.dlFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
            if (dlFolder != null && dlFolder.getFolderId() != folderId) {
                throw new DuplicateFolderNameException(name);
            }
            return;
        }
    }

    protected void validateFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        long folderId = 0L;
        this.validateFolder(folderId, groupId, parentFolderId, name);
    }

    protected void validateFolderName(String name) throws PortalException {
        if (!AssetUtil.isValidWord(name)) {
            throw new FolderNameException();
        }
    }
}

