/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.documentlibrary.model.DLSync;
import com.liferay.portlet.documentlibrary.service.base.DLSyncLocalServiceBaseImpl;
import java.util.Date;

public class DLSyncLocalServiceImpl
extends DLSyncLocalServiceBaseImpl {
    public DLSync addSync(long fileId, String fileUuid, long companyId, long repositoryId, long parentFolderId, String name, String type, String version) throws PortalException, SystemException {
        return this.addSync(fileId, fileUuid, companyId, repositoryId, parentFolderId, name, "", type, version);
    }

    public DLSync addSync(long fileId, String fileUuid, long companyId, long repositoryId, long parentFolderId, String name, String description, String type, String version) throws PortalException, SystemException {
        if (!this.isDefaultRepository(parentFolderId)) {
            return null;
        }
        Date now = new Date();
        long syncId = this.counterLocalService.increment();
        DLSync dlSync = this.dlSyncPersistence.create(syncId);
        dlSync.setCompanyId(companyId);
        dlSync.setCreateDate(now);
        dlSync.setDescription(description);
        dlSync.setModifiedDate(now);
        dlSync.setFileId(fileId);
        dlSync.setFileUuid(fileUuid);
        dlSync.setRepositoryId(repositoryId);
        dlSync.setParentFolderId(parentFolderId);
        dlSync.setEvent("add");
        dlSync.setType(type);
        dlSync.setName(name);
        dlSync.setVersion(version);
        this.dlSyncPersistence.update((BaseModel)dlSync, false);
        return dlSync;
    }

    public DLSync updateSync(long fileId, long parentFolderId, String name, String event, String version) throws PortalException, SystemException {
        return this.updateSync(fileId, parentFolderId, name, "", event, version);
    }

    public DLSync updateSync(long fileId, long parentFolderId, String name, String description, String event, String version) throws PortalException, SystemException {
        if (!this.isDefaultRepository(parentFolderId)) {
            return null;
        }
        DLSync dlSync = null;
        if (event == "delete") {
            dlSync = this.dlSyncPersistence.fetchByFileId(fileId);
            if (dlSync == null) {
                return null;
            }
        } else {
            dlSync = this.dlSyncPersistence.findByFileId(fileId);
        }
        dlSync.setModifiedDate(new Date());
        dlSync.setParentFolderId(parentFolderId);
        dlSync.setName(name);
        dlSync.setDescription(description);
        dlSync.setEvent(event);
        dlSync.setVersion(version);
        this.dlSyncPersistence.update((BaseModel)dlSync, false);
        return dlSync;
    }

    protected boolean isDefaultRepository(long folderId) throws PortalException, SystemException {
        if (folderId == 0L) {
            return true;
        }
        Folder folder = this.dlAppLocalService.getFolder(folderId);
        return folder.isDefaultRepository();
    }
}

