/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;

public class DLFileEntryPermission {
    public static void check(PermissionChecker permissionChecker, DLFileEntry dlFileEntry, String actionId) throws PortalException, SystemException {
        if (!DLFileEntryPermission.contains(permissionChecker, dlFileEntry, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, FileEntry fileEntry, String actionId) throws PortalException, SystemException {
        if (!fileEntry.containsPermission(permissionChecker, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long fileEntryId, String actionId) throws PortalException, SystemException {
        if (!DLFileEntryPermission.contains(permissionChecker, fileEntryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DLFileEntry dlFileEntry, String actionId) throws PortalException, SystemException {
        DLFolder dlFolder;
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)dlFileEntry.getGroupId(), (String)DLFileEntry.class.getName(), (long)dlFileEntry.getFileEntryId(), (String)"20", (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        DLFileVersion latestDLFileVersion = dlFileEntry.getLatestFileVersion(false);
        if (latestDLFileVersion.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)dlFileEntry.getGroupId(), (String)DLFileEntry.class.getName(), (long)dlFileEntry.getFileEntryId(), (String)actionId)) != null) {
            return hasPermission;
        }
        if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE && dlFileEntry.getFolderId() != 0L && !DLFolderPermission.contains(permissionChecker, dlFolder = DLFolderLocalServiceUtil.getFolder((long)dlFileEntry.getFolderId()), "ACCESS") && !DLFolderPermission.contains(permissionChecker, dlFolder, "VIEW")) {
            return false;
        }
        if (permissionChecker.hasOwnerPermission(dlFileEntry.getCompanyId(), DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), dlFileEntry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(dlFileEntry.getGroupId(), DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, FileEntry fileEntry, String actionId) throws PortalException, SystemException {
        return fileEntry.containsPermission(permissionChecker, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long fileEntryId, String actionId) throws PortalException, SystemException {
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileEntryId);
        return fileEntry.containsPermission(permissionChecker, actionId);
    }
}

