/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pacl.PACLClassLoaderUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.AdvancedFileSystemStore;
import com.liferay.portlet.documentlibrary.store.CMISStore;
import com.liferay.portlet.documentlibrary.store.FileSystemStore;
import com.liferay.portlet.documentlibrary.store.JCRStore;
import com.liferay.portlet.documentlibrary.store.S3Store;
import com.liferay.portlet.documentlibrary.store.Store;

public class StoreFactory {
    private static final String[][] _DL_HOOK_STORES = new String[][]{{"com.liferay.documentlibrary.util.AdvancedFileSystemHook", AdvancedFileSystemStore.class.getName()}, {"com.liferay.documentlibrary.util.CMISHook", CMISStore.class.getName()}, {"com.liferay.documentlibrary.util.FileSystemHook", FileSystemStore.class.getName()}, {"com.liferay.documentlibrary.util.JCRHook", JCRStore.class.getName()}, {"com.liferay.documentlibrary.util.S3Hook", S3Store.class.getName()}};
    private static Log _log = LogFactoryUtil.getLog(StoreFactory.class);
    private static Store _store;
    private static boolean _warned;

    public static void checkProperties() {
        if (_warned) {
            return;
        }
        String dlHookImpl = PropsUtil.get("dl.hook.impl");
        if (Validator.isNotNull((String)dlHookImpl)) {
            boolean found = false;
            String[][] stringArray = _DL_HOOK_STORES;
            int n = _DL_HOOK_STORES.length;
            int n2 = 0;
            while (n2 < n) {
                String[] dlHookStoreParts = stringArray[n2];
                if (dlHookImpl.equals(dlHookStoreParts[0])) {
                    PropsValues.DL_STORE_IMPL = dlHookStoreParts[1];
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                PropsValues.DL_STORE_IMPL = dlHookImpl;
            }
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(8);
                sb.append("Liferay is configured with the legacy ");
                sb.append("property \"dl.hook.impl=" + dlHookImpl + "\" ");
                sb.append("in portal-ext.properties. Please reconfigure ");
                sb.append("to use the new property \"");
                sb.append("dl.store.impl\". Liferay will ");
                sb.append("attempt to temporarily set \"");
                sb.append("dl.store.impl=");
                sb.append(String.valueOf(PropsValues.DL_STORE_IMPL) + "\".");
                _log.warn((Object)sb.toString());
            }
        }
        _warned = true;
    }

    public static Store getInstance() {
        if (_store == null) {
            StoreFactory.checkProperties();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Instantiate " + PropsValues.DL_STORE_IMPL));
            }
            ClassLoader classLoader = PACLClassLoaderUtil.getPortalClassLoader();
            try {
                _store = (Store)classLoader.loadClass(PropsValues.DL_STORE_IMPL).newInstance();
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Return " + _store.getClass().getName()));
        }
        return _store;
    }

    public static void setInstance(Store store) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Set " + store.getClass().getName()));
        }
        _store = store;
    }
}

