/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.io.File;
import java.io.InputStream;

public class DLAppUtil {
    public static String getExtension(String title, String sourceFileName) {
        String extension = FileUtil.getExtension((String)sourceFileName);
        if (Validator.isNull((String)extension)) {
            extension = FileUtil.getExtension((String)title);
        }
        return extension;
    }

    public static String getMimeType(String sourceFileName, String mimeType, String title, File file, InputStream is) {
        if (Validator.isNull((String)mimeType) || !mimeType.equals("application/octet-stream")) {
            return mimeType;
        }
        if (Validator.isNull((String)title)) {
            title = sourceFileName;
        }
        String extension = DLAppUtil.getExtension(title, sourceFileName);
        String titleWithExtension = DLUtil.getTitleWithExtension((String)title, (String)extension);
        mimeType = file != null ? MimeTypesUtil.getContentType((File)file, (String)titleWithExtension) : MimeTypesUtil.getContentType((InputStream)is, (String)titleWithExtension);
        return mimeType;
    }

    public static boolean isMajorVersion(FileVersion previousFileVersion, FileVersion currentFileVersion) {
        long previousVersion;
        long currentVersion = GetterUtil.getLong((String)currentFileVersion.getVersion());
        return currentVersion - (previousVersion = GetterUtil.getLong((String)previousFileVersion.getVersion())) >= 1L;
    }
}

